/**++
 *   
 *   LICENSE
 *   -------
 *   
 *   Copyright (c) 2004 Renato Mancuso
 *   All rights reserved.
 *   
 *   Redistribution and use in source and binary forms, with or without modification, are 
 *   permitted provided that the following conditions are met:
 *   
 *   - Redistributions of source code must retain the above copyright notice, this list 
 *     of conditions and the following disclaimer.
 *   
 *   - Redistributions in binary form must reproduce the above copyright notice, this list
 *     of conditions and the following disclaimer in the documentation and/or other materials 
 *     provided with the distribution.
 *   
 *   - Neither the name of Renato Mancuso nor the names of its contributors may be used to 
 *     endorse or promote products derived from this software without specific prior written 
 *     permission.
 *   
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS 
 *   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
 *   AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 *   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 *   IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 *   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *   
--**/


#ifndef OPEN_EMBL_PARSER_EVENTS_INCLUDED
#define OPEN_EMBL_PARSER_EVENTS_INCLUDED

#if !defined(OPEN_EMBL_NO_PRAGMA_ONCE)
#pragma once
#endif

#include "ObjMacros.hpp"
#include "FieldDefs.hpp"

namespace OpenEMBL
{
namespace Phoenix
{

    DECLARE_INTERFACE(IParserEventsListener)
    {
        // Errors/Warnings
        METHOD onError  (long theLineNumber, int theErrorCode, LPCSTR theMessage) PURE;
        METHOD onWarning(long theLineNumber, int theWarningNumber, LPCSTR theMessage) PURE;

        // Entry
        METHOD onBeginEntry(long theLineNumber) PURE;
        METHOD onEndEntry() PURE;

        // Individual Fields
        METHOD onID(long theLineNumber, IDLine const & theField) PURE;
        METHOD onAC(long theLineNumber, ACLine const & theField) PURE;
        METHOD onSV(long theLineNumber, SVLine const & theField) PURE;
        METHOD onDT(long theLineNumber, DTLine const & theField) PURE;
        METHOD onDE(long theLineNumber, DELine const & theField) PURE;
        METHOD onKW(long theLineNumber, KWLine const & theField) PURE;
        METHOD onDR(long theLineNumber, DRLine const & theField) PURE;
        METHOD onCC(long theLineNumber, CCLine const & theField) PURE;
        METHOD onSQ(long theLineNumber, SQLine const & theField) PURE;
        METHOD onXX(long theLineNumber, XXLine const & theField) PURE;

        // Taxonomy lines
        METHOD onBeginTaxonomyLines(long theLineNumber) PURE;
        METHOD onOS(long theLineNumber, OSLine const & theField) PURE;    
        METHOD onOC(long theLineNumber, OCLine const & theField) PURE;
        METHOD onOG(long theLineNumber, OGLine const & theField) PURE;        
        METHOD onEndTaxonomyLines() PURE;

        // Feature Table
        METHOD onBeginFeatureTable(long theLineNumber) PURE;
        METHOD onBeginFeatureKey(long theLineNumber, FeatureKey const & theField) PURE;
        METHOD onFeatureQualifier(long theLineNumber, FeatureQualifier const  & theQualifier) PURE;   
        METHOD onEndFeatureKey() PURE;
        METHOD onEndFeatureTable() PURE;

        // Sequence Data
        METHOD onBeginSequenceData(long theLineNumber) PURE;
        METHOD onSequenceLine(long theLineNumber, SequenceLine const & theField) PURE;
        METHOD onEndSequenceData() PURE;

        // TPA lines
        METHOD onBeginTPALines(long theLineNumber) PURE;
        METHOD onAS(long theLineNumber, ASLine const & theField) PURE;
        METHOD onEndTPALines() PURE;

        // CO lines
        METHOD onBeginCOLines(long theLineNumber, bool isComplement) PURE;
        METHOD onCOSegmentInfo (long theLineNumber, COSegmentInfo const & theSegmentInfo) PURE;
        METHOD onCOGapInfo (long theLineNumber, COGapInfo const & theGapInfo) PURE;
        METHOD onEndCOLines() PURE;

        // Private line types
        METHOD onACStar(long theLineNumber, ACStarLine const & theField) PURE;

        // Publications
        METHOD onBeginPublication(long theLineNumber) PURE;

        METHOD onRN(long theLineNumber, RNLine const & theField) PURE; 
        METHOD onRC(long theLineNumber, RCLine const & theField) PURE;
        METHOD onRP(long theLineNumber, RPLine const & theField) PURE;
        METHOD onRX(long theLineNumber, RXLine const & theField) PURE;
        METHOD onRG(long theLineNumber, RGLine const & theField) PURE;
        METHOD onRA(long theLineNumber, RALine const & theField) PURE;
        METHOD onRT(long theLineNumber, RTLine const & theField) PURE;

        //>> RL line types
        METHOD onSubmission        (long theLineNumber, SubmissionInfo         const & theField) PURE;
        METHOD onUnpublished       (long theLineNumber, UnpublishedInfo        const & theField) PURE;
        METHOD onBook              (long theLineNumber, BookInfo               const & theField) PURE;
        METHOD onThesis            (long theLineNumber, ThesisInfo             const & theField) PURE;
        METHOD onPatent            (long theLineNumber, PatentInfo             const & theField) PURE;
        METHOD onOnlineJournal     (long theLineNumber, OnlineJournalInfo      const & theField) PURE;
        METHOD onElectronicResource(long theLineNumber, ElectronicResourceInfo const & theField) PURE;
		METHOD onMiscResource      (long theLineNumber, MiscResourceInfo       const & theField) PURE;
        METHOD onJournalArticle    (long theLineNumber, JournalArticleInfo     const & theField) PURE;

        METHOD onEndPublication() PURE;
    };


}
}

#endif // OPEN_EMBL_PARSER_EVENTS_INCLUDED
