/**++
 *   
 *   LICENSE
 *   -------
 *   
 *   Copyright (c) 2004 Renato Mancuso
 *   All rights reserved.
 *   
 *   Redistribution and use in source and binary forms, with or without modification, are 
 *   permitted provided that the following conditions are met:
 *   
 *   - Redistributions of source code must retain the above copyright notice, this list 
 *     of conditions and the following disclaimer.
 *   
 *   - Redistributions in binary form must reproduce the above copyright notice, this list
 *     of conditions and the following disclaimer in the documentation and/or other materials 
 *     provided with the distribution.
 *   
 *   - Neither the name of Renato Mancuso nor the names of its contributors may be used to 
 *     endorse or promote products derived from this software without specific prior written 
 *     permission.
 *   
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS 
 *   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
 *   AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 *   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 *   IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 *   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *   
--**/


#ifndef OPEN_EMBL_PARSER_EVENTS_SOURCE_INCLUDED
#define OPEN_EMBL_PARSER_EVENTS_SOURCE_INCLUDED

#if !defined(OPEN_EMBL_NO_PRAGMA_ONCE)
#pragma once
#endif

#include "ObjMacros.hpp"
#include "ParserEvents.hpp"

namespace OpenEMBL
{
namespace Phoenix
{

    //
    // multicast of parser events
    //
    DECLARE_INTERFACE(IParserEventsSource)
    {
        // Errors/Warnings
        METHOD broadcastError  (long theLineNumber, int theErrorCode, char const* theMessage) PURE;
        METHOD broadcastWarning(long theLineNumber, int theWarningNumber, char const* theMessage) PURE;

        // Entry
        METHOD broadcastBeginEntry(long theLineNumber) PURE;
        METHOD broadcastEndEntry() PURE;

        // Individual Fields
        METHOD broadcastID(long theLineNumber, IDLine const & theField) PURE;
        METHOD broadcastAC(long theLineNumber, ACLine const & theField) PURE;
        METHOD broadcastSV(long theLineNumber, SVLine const & theField) PURE;
        METHOD broadcastDT(long theLineNumber, DTLine const & theField) PURE;
        METHOD broadcastDE(long theLineNumber, DELine const & theField) PURE;
        METHOD broadcastKW(long theLineNumber, KWLine const & theField) PURE;
        METHOD broadcastDR(long theLineNumber, DRLine const & theField) PURE;
        METHOD broadcastCC(long theLineNumber, CCLine const & theField) PURE;
        METHOD broadcastSQ(long theLineNumber, SQLine const & theField) PURE;
        METHOD broadcastXX(long theLineNumber, XXLine const & theField) PURE;

        // Taxonomy lines
        METHOD broadcastBeginTaxonomyLines(long theLineNumber) PURE;
        METHOD broadcastOS(long theLineNumber, OSLine const & theField) PURE;    
        METHOD broadcastOC(long theLineNumber, OCLine const & theField) PURE;
        METHOD broadcastOG(long theLineNumber, OGLine const & theField) PURE;        
        METHOD broadcastEndTaxonomyLines() PURE;

        // Feature keys
        METHOD broadcastBeginFeatureTable(long theLineNumber) PURE;
        METHOD broadcastBeginFeatureKey(long theLineNumber, FeatureKey const & theKey) PURE;
        METHOD broadcastFeatureQualifier(long theLineNumber, FeatureQualifier const & theQualifier) PURE;
        METHOD broadcastEndFeatureKey() PURE;        
        METHOD broadcastEndFeatureTable() PURE;

        // Sequence Data
        METHOD broadcastBeginSequenceData(long theLineNumber) PURE;
        METHOD broadcastSequenceLine(long theLineNumber, SequenceLine const & theField) PURE;
        METHOD broadcastEndSequenceData() PURE;

        // TPA lines
        METHOD broadcastBeginTPALines(long theLineNumber) PURE;
        METHOD broadcastAS(long theLineNumber, ASLine const & theField) PURE;
        METHOD broadcastEndTPALines() PURE;

        // CO lines
        METHOD broadcastBeginCOLines(long theLineNumber, bool isComplement) PURE;        
        METHOD broadcastCOSegmentInfo (long theLineNumber, COSegmentInfo const & theSegmentInfo) PURE;
        METHOD broadcastCOGapInfo (long theLineNumber, COGapInfo const & theGapInfo) PURE;
        METHOD broadcastEndCOLines() PURE;

        // Private line types
        METHOD broadcastACStar(long theLineNumber, ACStarLine const & theField) PURE;

        // Publications
        METHOD broadcastBeginPublication(long theLineNumber) PURE;

        METHOD broadcastRN(long theLineNumber, RNLine const & theField) PURE;
        METHOD broadcastRC(long theLineNumber, RCLine const & theField) PURE;
        METHOD broadcastRP(long theLineNumber, RPLine const & theField) PURE;
        METHOD broadcastRX(long theLineNumber, RXLine const & theField) PURE;
        METHOD broadcastRG(long theLineNumber, RGLine const & theField) PURE;
        METHOD broadcastRA(long theLineNumber, RALine const & theField) PURE;
        METHOD broadcastRT(long theLineNumber, RTLine const & theField) PURE;

        //>> RL line types
        METHOD broadcastSubmission        (long theLineNumber, SubmissionInfo         const & theField) PURE;
        METHOD broadcastUnpublished       (long theLineNumber, UnpublishedInfo        const & theField) PURE;
        METHOD broadcastBook              (long theLineNumber, BookInfo               const & theField) PURE;
        METHOD broadcastThesis            (long theLineNumber, ThesisInfo             const & theField) PURE;
        METHOD broadcastPatent            (long theLineNumber, PatentInfo             const & theField) PURE;
        METHOD broadcastOnlineJournal     (long theLineNumber, OnlineJournalInfo      const & theField) PURE;
        METHOD broadcastElectronicResource(long theLineNumber, ElectronicResourceInfo const & theField) PURE;
		METHOD broadcastMiscResource      (long theLineNumber, MiscResourceInfo const & theField) PURE;
        METHOD broadcastJournalArticle    (long theLineNumber, JournalArticleInfo     const & theField) PURE;

        METHOD broadcastEndPublication() PURE;
    };

}
}

#endif // OPEN_EMBL_PARSER_EVENTS_SOURCE_INCLUDED

