/**++
 *   
 *   LICENSE
 *   -------
 *   
 *   Copyright (c) 2004 Renato Mancuso
 *   All rights reserved.
 *   
 *   Redistribution and use in source and binary forms, with or without modification, are 
 *   permitted provided that the following conditions are met:
 *   
 *   - Redistributions of source code must retain the above copyright notice, this list 
 *     of conditions and the following disclaimer.
 *   
 *   - Redistributions in binary form must reproduce the above copyright notice, this list
 *     of conditions and the following disclaimer in the documentation and/or other materials 
 *     provided with the distribution.
 *   
 *   - Neither the name of Renato Mancuso nor the names of its contributors may be used to 
 *     endorse or promote products derived from this software without specific prior written 
 *     permission.
 *   
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS 
 *   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
 *   AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 *   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 *   IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 *   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *   
--**/


#ifndef OPEN_EMBL_PARSER_IMPL_INCLUDED
#define OPEN_EMBL_PARSER_IMPL_INCLUDED

#if !defined(OPEN_EMBL_NO_PRAGMA_ONCE)
#pragma once
#endif

#include "TextSource.hpp"
#include "ParserItf.hpp"
#include "ParserCtx.hpp"
#include "ParserOptions.hpp"
#include "ParserEventsSource.hpp"

namespace OpenEMBL
{
namespace Phoenix
{

    class ParserImpl
        : public  virtual IParser
        , private virtual IParserCtx
        , private virtual IParserEventsSource
    {
    public:
        // construction
        ParserImpl();      
        ~ParserImpl() throw();

        void    setOptions     (ParserOptions const & theOptions);
        void    setTextSource  (ITextSource*   theTextSource);
        void    addListener    (IParserEventsListener* theListener);

        // Parser
        METHOD parse();        

    private:
        // methods
        void initialize();
        void finalize();
        void goToNextEntry();
        void parseEntry();

        // TextSource (ParserCtx)
        METHOD_(LPCSTR)  currentLine() const NO_THROW;
        METHOD_(long)    currentLineNumber() const NO_THROW;
        METHOD_(bool)    nextLine();

        // ErrorLog (ParserCtx)
        METHOD logError(long theLineNumber, int theErrorCode, LPCSTR theMessage);
        METHOD logWarning(long theLineNumber, int theWarning, LPCSTR theMessage);

        // ParserEventsSource
        METHOD broadcastError  (long theLineNumber, int theErrorCode, char const* theMessage);
        METHOD broadcastWarning(long theLineNumber, int theWarningNumber, char const* theMessage);
        METHOD broadcastBeginEntry(long theLineNumber);
        METHOD broadcastEndEntry();
        METHOD broadcastID(long theLineNumber, IDLine const & theField);
        METHOD broadcastAC(long theLineNumber, ACLine const & theField);
        METHOD broadcastSV(long theLineNumber, SVLine const & theField);
        METHOD broadcastDT(long theLineNumber, DTLine const & theField);
        METHOD broadcastDE(long theLineNumber, DELine const & theField);
        METHOD broadcastKW(long theLineNumber, KWLine const & theField);
        METHOD broadcastDR(long theLineNumber, DRLine const & theField);
        METHOD broadcastCC(long theLineNumber, CCLine const & theField);
        METHOD broadcastSQ(long theLineNumber, SQLine const & theField);
        METHOD broadcastXX(long theLineNumber, XXLine const & theField);
        METHOD broadcastBeginTaxonomyLines(long theLineNumber);
        METHOD broadcastOS(long theLineNumber, OSLine const & theField);    
        METHOD broadcastOC(long theLineNumber, OCLine const & theField);
        METHOD broadcastOG(long theLineNumber, OGLine const & theField);        
        METHOD broadcastEndTaxonomyLines();
        METHOD broadcastBeginFeatureTable(long theLineNumber);
        METHOD broadcastBeginFeatureKey(long theLineNumber, FeatureKey const & theKey);
        METHOD broadcastFeatureQualifier(long theLineNumber, FeatureQualifier const & theQualifier);
        METHOD broadcastEndFeatureKey();        
        METHOD broadcastEndFeatureTable();
        METHOD broadcastBeginSequenceData(long theLineNumber);
        METHOD broadcastSequenceLine(long theLineNumber, SequenceLine const & theField);
        METHOD broadcastEndSequenceData();
        METHOD broadcastBeginTPALines(long theLineNumber);
        METHOD broadcastAS(long theLineNumber, ASLine const & theField);
        METHOD broadcastEndTPALines();
        METHOD broadcastBeginCOLines(long theLineNumber, bool isComplement);        
        METHOD broadcastCOSegmentInfo (long theLineNumber, COSegmentInfo const & theSegmentInfo);
        METHOD broadcastCOGapInfo (long theLineNumber, COGapInfo const & theGapInfo);
        METHOD broadcastEndCOLines();
        METHOD broadcastACStar(long theLineNumber, ACStarLine const & theField);
        METHOD broadcastBeginPublication(long theLineNumber);
        METHOD broadcastRN(long theLineNumber, RNLine const & theField);
        METHOD broadcastRC(long theLineNumber, RCLine const & theField);
        METHOD broadcastRP(long theLineNumber, RPLine const & theField);
        METHOD broadcastRX(long theLineNumber, RXLine const & theField);
        METHOD broadcastRG(long theLineNumber, RGLine const & theField);
        METHOD broadcastRA(long theLineNumber, RALine const & theField);
        METHOD broadcastRT(long theLineNumber, RTLine const & theField);
        METHOD broadcastSubmission        (long theLineNumber, SubmissionInfo         const & theField);
        METHOD broadcastUnpublished       (long theLineNumber, UnpublishedInfo        const & theField);
        METHOD broadcastBook              (long theLineNumber, BookInfo               const & theField);
        METHOD broadcastThesis            (long theLineNumber, ThesisInfo             const & theField);
        METHOD broadcastPatent            (long theLineNumber, PatentInfo             const & theField);
        METHOD broadcastOnlineJournal     (long theLineNumber, OnlineJournalInfo      const & theField);
        METHOD broadcastElectronicResource(long theLineNumber, ElectronicResourceInfo const & theField);
		METHOD broadcastMiscResource      (long theLineNumber, MiscResourceInfo       const & theField);
        METHOD broadcastJournalArticle    (long theLineNumber, JournalArticleInfo     const & theField);
        METHOD broadcastEndPublication();   

    private:
        ITextSource*                    m_pTextSource;
        ParserOptions                   m_Options;
        std::vector<IParserEventsListener*>     m_Listeners;
    };

}
}

#endif // OPEN_EMBL_PARSER_IMPL_INCLUDED
