/**++
 *   
 *   LICENSE
 *   -------
 *   
 *   Copyright (c) 2004 Renato Mancuso
 *   All rights reserved.
 *   
 *   Redistribution and use in source and binary forms, with or without modification, are 
 *   permitted provided that the following conditions are met:
 *   
 *   - Redistributions of source code must retain the above copyright notice, this list 
 *     of conditions and the following disclaimer.
 *   
 *   - Redistributions in binary form must reproduce the above copyright notice, this list
 *     of conditions and the following disclaimer in the documentation and/or other materials 
 *     provided with the distribution.
 *   
 *   - Neither the name of Renato Mancuso nor the names of its contributors may be used to 
 *     endorse or promote products derived from this software without specific prior written 
 *     permission.
 *   
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS 
 *   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
 *   AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 *   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 *   IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 *   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *   
--**/


#include "ParserImpl.hpp"

#include <cassert>

#define BROADCAST_0(method) \
    for (size_t i = 0; i <m_Listeners.size(); ++i) \
        m_Listeners[i]->method ()

#define BROADCAST_1(method, arg1) \
    for (size_t i = 0; i <m_Listeners.size(); ++i) \
        m_Listeners[i]->method (arg1)

#define BROADCAST_2(method, arg1, arg2) \
    for (size_t i = 0; i <m_Listeners.size(); ++i) \
        m_Listeners[i]->method (arg1, arg2)

#define BROADCAST_3(method, arg1, arg2, arg3) \
    for (size_t i = 0; i <m_Listeners.size(); ++i) \
        m_Listeners[i]->method (arg1, arg2, arg3)

namespace OpenEMBL
{
namespace Phoenix
{

    METHODIMP ParserImpl::broadcastError(long theLineNumber, int theErrorCode, char const* theMessage)
    {
        BROADCAST_3(onError, theLineNumber, theErrorCode, theMessage);
    }

    METHODIMP ParserImpl::broadcastWarning(long theLineNumber, int theWarningNumber, char const* theMessage)
    {
        BROADCAST_3(onWarning, theLineNumber, theWarningNumber, theMessage);
    }

    METHODIMP ParserImpl::broadcastBeginEntry(long theLineNumber) 
    { 
        BROADCAST_1(onBeginEntry, theLineNumber);
    }

    METHODIMP ParserImpl::broadcastEndEntry()
    { 
        BROADCAST_0(onEndEntry);
    }

    METHODIMP ParserImpl::broadcastID(long theLineNumber, IDLine const & theField)
    { 
        BROADCAST_2(onID, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastAC(long theLineNumber, ACLine const & theField)
    { 
        BROADCAST_2(onAC, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastSV(long theLineNumber, SVLine const & theField)
    { 
        BROADCAST_2(onSV, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastDT(long theLineNumber, DTLine const & theField)
    { 
        BROADCAST_2(onDT, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastDE(long theLineNumber, DELine const & theField)
    { 
        BROADCAST_2(onDE, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastKW(long theLineNumber, KWLine const & theField)
    { 
        BROADCAST_2(onKW, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastDR(long theLineNumber, DRLine const & theField)
    { 
        BROADCAST_2(onDR, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastCC(long theLineNumber, CCLine const & theField)
    { 
        BROADCAST_2(onCC, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastSQ(long theLineNumber, SQLine const & theField)
    { 
        BROADCAST_2(onSQ, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastXX(long theLineNumber, XXLine const & theField)
    { 
        BROADCAST_2(onXX, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastBeginTaxonomyLines(long theLineNumber)
    { 
        BROADCAST_1(onBeginTaxonomyLines, theLineNumber);
    }

    METHODIMP ParserImpl::broadcastOS(long theLineNumber, OSLine const & theField)    
    { 
        BROADCAST_2(onOS, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastOC(long theLineNumber, OCLine const & theField)
    { 
        BROADCAST_2(onOC, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastOG(long theLineNumber, OGLine const & theField)        
    { 
        BROADCAST_2(onOG, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastEndTaxonomyLines()
    { 
        BROADCAST_0(onEndTaxonomyLines);
    }

    METHODIMP ParserImpl::broadcastBeginFeatureTable(long theLineNumber)
    { 
        BROADCAST_1(onBeginFeatureTable, theLineNumber);
    }

    METHODIMP ParserImpl::broadcastEndFeatureTable()
    { 
        BROADCAST_0(onEndFeatureTable);
    }

    METHODIMP ParserImpl::broadcastBeginFeatureKey(long theLineNumber, FeatureKey const & theKey)
    { 
        BROADCAST_2(onBeginFeatureKey, theLineNumber, theKey);
    }

    METHODIMP ParserImpl::broadcastFeatureQualifier(long theLineNumber, FeatureQualifier const & theQualifier)
    { 
        BROADCAST_2(onFeatureQualifier, theLineNumber, theQualifier);
    }

    METHODIMP ParserImpl::broadcastEndFeatureKey()
    { 
        BROADCAST_0(onEndFeatureKey);
    }

    METHODIMP ParserImpl::broadcastBeginSequenceData(long theLineNumber)
    { 
        BROADCAST_1(onBeginSequenceData, theLineNumber);
    }

    METHODIMP ParserImpl::broadcastSequenceLine(long theLineNumber, SequenceLine const & theField)
    { 
        BROADCAST_2(onSequenceLine, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastEndSequenceData()
    { 
        BROADCAST_0(onEndSequenceData);
    }

    METHODIMP ParserImpl::broadcastBeginTPALines(long theLineNumber)
    { 
        BROADCAST_1(onBeginTPALines, theLineNumber);
    }

    METHODIMP ParserImpl::broadcastAS(long theLineNumber, ASLine const & theField)
    { 
        BROADCAST_2(onAS, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastEndTPALines()
    { 
        BROADCAST_0(onEndTPALines);
    }

    METHODIMP ParserImpl::broadcastBeginCOLines(long theLineNumber, bool isComplement)        
    { 
        BROADCAST_2(onBeginCOLines, theLineNumber, isComplement);
    }

    METHODIMP ParserImpl::broadcastCOSegmentInfo (long theLineNumber, COSegmentInfo const & theSegmentInfo)
    { 
        BROADCAST_2(onCOSegmentInfo, theLineNumber, theSegmentInfo);
    }

    METHODIMP ParserImpl::broadcastCOGapInfo (long theLineNumber, COGapInfo const & theGapInfo)
    { 
        BROADCAST_2(onCOGapInfo, theLineNumber, theGapInfo);
    }

    METHODIMP ParserImpl::broadcastEndCOLines()
    { 
        BROADCAST_0(onEndCOLines);
    }

    METHODIMP ParserImpl::broadcastACStar(long theLineNumber, ACStarLine const & theField)
    { 
        BROADCAST_2(onACStar, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastBeginPublication(long theLineNumber)
    { 
        BROADCAST_1(onBeginPublication, theLineNumber);
    }

    METHODIMP ParserImpl::broadcastRN(long theLineNumber, RNLine const & theField)
    { 
        BROADCAST_2(onRN, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastRC(long theLineNumber, RCLine const & theField)
    { 
        BROADCAST_2(onRC, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastRP(long theLineNumber, RPLine const & theField)
    { 
        BROADCAST_2(onRP, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastRX(long theLineNumber, RXLine const & theField)
    { 
        BROADCAST_2(onRX, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastRG(long theLineNumber, RGLine const & theField)
    { 
        BROADCAST_2(onRG, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastRA(long theLineNumber, RALine const & theField)
    { 
        BROADCAST_2(onRA, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastRT(long theLineNumber, RTLine const & theField)
    { 
        BROADCAST_2(onRT, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastSubmission        (long theLineNumber, SubmissionInfo         const & theField)
    { 
        BROADCAST_2(onSubmission, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastUnpublished       (long theLineNumber, UnpublishedInfo        const & theField)
    { 
        BROADCAST_2(onUnpublished, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastBook              (long theLineNumber, BookInfo               const & theField)
    { 
        BROADCAST_2(onBook, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastThesis            (long theLineNumber, ThesisInfo             const & theField)
    { 
        BROADCAST_2(onThesis, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastPatent            (long theLineNumber, PatentInfo             const & theField)
    { 
        BROADCAST_2(onPatent, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastOnlineJournal     (long theLineNumber, OnlineJournalInfo      const & theField)
    { 
        BROADCAST_2(onOnlineJournal, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastElectronicResource(long theLineNumber, ElectronicResourceInfo const & theField)
    { 
        BROADCAST_2(onElectronicResource, theLineNumber, theField);
    }

	METHODIMP ParserImpl::broadcastMiscResource(long theLineNumber, MiscResourceInfo const & theField)
    { 
        BROADCAST_2(onMiscResource, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastJournalArticle    (long theLineNumber, JournalArticleInfo     const & theField)
    { 
        BROADCAST_2(onJournalArticle, theLineNumber, theField);
    }

    METHODIMP ParserImpl::broadcastEndPublication()
    { 
        BROADCAST_0(onEndPublication);
    }

}
}
