/**++
 *   
 *   LICENSE
 *   -------
 *   
 *   Copyright (c) 2004 Renato Mancuso
 *   All rights reserved.
 *   
 *   Redistribution and use in source and binary forms, with or without modification, are 
 *   permitted provided that the following conditions are met:
 *   
 *   - Redistributions of source code must retain the above copyright notice, this list 
 *     of conditions and the following disclaimer.
 *   
 *   - Redistributions in binary form must reproduce the above copyright notice, this list
 *     of conditions and the following disclaimer in the documentation and/or other materials 
 *     provided with the distribution.
 *   
 *   - Neither the name of Renato Mancuso nor the names of its contributors may be used to 
 *     endorse or promote products derived from this software without specific prior written 
 *     permission.
 *   
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS 
 *   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
 *   AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 *   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 *   IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 *   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *   
--**/


//
// This file defines the parser warning numbers
//
// fields: numerical code, symbolic name, severity, description
//
//
// To process the severity you must #include "WarningSeverity.hpp"
//
//	    WARNING_SEVERITY_HIGH	= 1,
//	    WARNING_SEVERITY_MEDIUM     = 2,
//	    WARNING_SEVERITY_LOW	= 3,
//	    WARNING_SEVERITY_INFO	= 4
//

PARSER_WARNING( 1,
		WARNING_NO_ENTRY_FOUND,
		WARNING_SEVERITY_HIGH,
		"no entry found in file")

PARSER_WARNING( 2,
                WARNING_RESET_PARSER_INPUT,
                WARNING_SEVERITY_INFO,
                "skipping lines while looking for start of next record")

PARSER_WARNING( 3,
                WARNING_EMPTY_LINE_AT_END_OF_RECORD,
                WARNING_SEVERITY_INFO,
                "empty line found at end of record")

PARSER_WARNING( 4,
                WARNING_SPURIOUS_CHARACTER_IN_TERMINATOR_LINE,
                WARNING_SEVERITY_INFO,
                "non-space characters found in terminator line")

PARSER_WARNING( 5,
                WARNING_SPURIOUS_CHARACTER_IN_XX_LINE,
                WARNING_SEVERITY_INFO,
                "non-space characters found in spacer line")
               
PARSER_WARNING( 6,
                WARNING_BAD_FIELD_CODE_IN_SEQUENCE_LINE,
                WARNING_SEVERITY_LOW,
                "sequence lines should start with 2 blanks")

PARSER_WARNING( 7,
                WARNING_MISSING_LIST_TERMINATOR,
                WARNING_SEVERITY_LOW,
                "missing list terminator at end of line")
                
PARSER_WARNING( 8,
                WARNING_MISSING_OC_LINE,
                WARNING_SEVERITY_HIGH,
                "missing OC line in taxonomy block")

PARSER_WARNING( 9,
                WARNING_MISSING_RT_LINE_TERMINATOR,
                WARNING_SEVERITY_HIGH,
                "missing ; at end of RT line")
               
PARSER_WARNING(10,
                WARNING_MISSING_RT_LINE_FINAL_QUOTE,
                WARNING_SEVERITY_HIGH,
                "missing terminal quotation mark at end of RT line")
                
PARSER_WARNING(11,
                WARNING_MISSING_RT_LINE_INITIAL_QUOTE,
                WARNING_SEVERITY_HIGH,
                "missing quotation mark at start of RT line")

PARSER_WARNING(12,
                WARNING_SPURIOUS_CHARACTER_IN_RL_ONLINE_JOURNAL_LINE,
                WARNING_SEVERITY_INFO,
                "non-space characters found past end of RL line (online journal)")

PARSER_WARNING(13,
                WARNING_MISSING_EDITOR_LIST_TERMINATOR,
                WARNING_SEVERITY_HIGH,
                "the list of editors is not terminated by the string (eds.)")

PARSER_WARNING(14,
                WARNING_MISSING_PUBLICATION_DATE,
                WARNING_SEVERITY_HIGH,
                "missing publication date")
                
PARSER_WARNING(15,
                WARNING_INVALID_TERMINATOR_IN_PUBLISHER_INFO,
                WARNING_SEVERITY_MEDIUM,
                "publisher info line should not be terminated by dot or semicolon")
                
PARSER_WARNING(16,
                WARNING_MISSING_FINAL_DOT,
                WARNING_SEVERITY_INFO,
                "line is not terminated by dot")

PARSER_WARNING(17,
                WARNING_RL_JOURNAL_MISSING_LAST_PAGE,
                WARNING_SEVERITY_INFO,
                "missing last page, assuming last page = first page")

PARSER_WARNING(18,
                WARNING_JOURNAL_EMPTY_ISSUE,
                WARNING_SEVERITY_HIGH,
                "issue field is empty")

PARSER_WARNING(19,
                WARNING_MISSING_LIST_SEPARATOR,
                WARNING_SEVERITY_LOW,
                "missing list separator at end of line")

PARSER_WARNING(20,
                WARNING_SKIPPING_LINES_SEARCHING_FOR_FKEY,
                WARNING_SEVERITY_INFO,
                "skipping lines searching for next feature key")

PARSER_WARNING(21,
                WARNING_FEATURE_KEY_NOT_IN_PLACE,
                WARNING_SEVERITY_HIGH,
                "feature key does not start at column 6")

PARSER_WARNING(22,
                WARNING_FEATURE_QUAL_NOT_IN_PLACE,
                WARNING_SEVERITY_HIGH,
                "feature qualifier does not start at column 22")

PARSER_WARNING(23,
                WARNING_SPACE_BEFORE_QUALIFIER_NAME,
                WARNING_SEVERITY_HIGH,
                "space found bewteen / character and qualifier name")
                
PARSER_WARNING(24,
                WARNING_SPACE_AFTER_QUALIFIER_NAME,
                WARNING_SEVERITY_HIGH,
                "space found bewteen qualifier name and = character")
                
PARSER_WARNING(25,
                WARNING_SPACE_BEFORE_QUALIFIER_VALUE,
                WARNING_SEVERITY_HIGH,
                "space found bewteen qualifier value and = character")
                
PARSER_WARNING(26,
                WARNING_UNRECOGNIZED_ACCESSION_NUMBER_FORMAT,
                WARNING_SEVERITY_LOW,
                "unrecognized accession number format")
                
