/**++
 *   
 *   LICENSE
 *   -------
 *   
 *   Copyright (c) 2004 Renato Mancuso
 *   All rights reserved.
 *   
 *   Redistribution and use in source and binary forms, with or without modification, are 
 *   permitted provided that the following conditions are met:
 *   
 *   - Redistributions of source code must retain the above copyright notice, this list 
 *     of conditions and the following disclaimer.
 *   
 *   - Redistributions in binary form must reproduce the above copyright notice, this list
 *     of conditions and the following disclaimer in the documentation and/or other materials 
 *     provided with the distribution.
 *   
 *   - Neither the name of Renato Mancuso nor the names of its contributors may be used to 
 *     endorse or promote products derived from this software without specific prior written 
 *     permission.
 *   
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS 
 *   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
 *   AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 *   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 *   IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 *   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *   
--**/

#ifndef OPEN_EMBL_REGEX_INCLUDED
#define OPEN_EMBL_REGEX_INCLUDED

#if !defined(OPEN_EMBL_NO_PRAGMA_ONCE)
#pragma once
#endif

#include <pcre.h>
#include <cstdlib>
#include <vector>
#include <string>
#include <stdexcept>
#include <utility>

#include "NonCopyable.hpp"


namespace OpenEMBL
{
namespace Phoenix
{

    class  Regex;
    class  Match;
    struct CaptureGroup;

    class Regex
        : NonCopyable
    {
    public:

        class exception : public std::runtime_error
	    {
	    public:
            exception( const std::string & msg ) 
                : runtime_error( msg ) 
            { }
	    };


	    Regex( const char* re, unsigned options = 0U );
	    ~Regex();

        Match find( std::string const & line ) const;

    private:
        static void check( int errorCode );

        void    compile( const char* s, unsigned options );        
        int     getCaptureCount() const;

	    pcre*           _re;
        pcre_extra*     _study;
    };


    class Match
    {

        friend class Regex;

        enum { INVALID_INDEX_VALUE = -1 };

    public:
        Match() {}

        bool matched() const throw()  { return _ovector.size() > 0; }
        operator bool() const throw() { return matched(); }

        std::string str( size_t index ) const;

        CaptureGroup operator[]( size_t index ) const;

    private:
        Match( std::string const & line, std::vector<int> & ovector );

        std::string         _str;
        std::vector<int>    _ovector;
    };


    struct CaptureGroup
    {
        bool matched;
        int  first;
        int  last;        
    };
   
    
    bool regexSearch( std::string const & line, Match & match, Regex const & re );
    std::string regexMerge( std::string const & line, Regex const & re, char const * replacement );



}
}

#endif // OPEN_EMBL_REGEX_INCLUDED
