/**++
 *   
 *   LICENSE
 *   -------
 *   
 *   Copyright (c) 2004 Renato Mancuso
 *   All rights reserved.
 *   
 *   Redistribution and use in source and binary forms, with or without modification, are 
 *   permitted provided that the following conditions are met:
 *   
 *   - Redistributions of source code must retain the above copyright notice, this list 
 *     of conditions and the following disclaimer.
 *   
 *   - Redistributions in binary form must reproduce the above copyright notice, this list
 *     of conditions and the following disclaimer in the documentation and/or other materials 
 *     provided with the distribution.
 *   
 *   - Neither the name of Renato Mancuso nor the names of its contributors may be used to 
 *     endorse or promote products derived from this software without specific prior written 
 *     permission.
 *   
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS 
 *   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
 *   AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 *   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 *   IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 *   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *   
--**/


#ifndef OPEN_EMBL_TEXT_FILE_INCLUDED
#define OPEN_EMBL_TEXT_FILE_INCLUDED

#if !defined(OPEN_EMBL_NO_PRAGMA_ONCE)
#pragma once
#endif 

#include <new>

#include "NonCopyable.hpp"
#include "TextSource.hpp"
#include "OSError.hpp"
#include "LineTooLong.hpp"


#if defined(_MSC_VER)
#   pragma warning(push)
#   pragma warning(disable: 4290)
#endif

namespace OpenEMBL
{
namespace Phoenix
{

    //
    // This is an implementation of the TextSource interface
    // on a disk file
    //

    class TextFileImpl;

    class TextFile 
        : public virtual ITextSource
        , NonCopyable
    {
    public:
        explicit TextFile(char const* theFilename) throw (std::bad_alloc, OSError);
        ~TextFile() throw();

        METHOD_(LPCSTR) currentLine() const NO_THROW;
        METHOD_(long)   currentLineNumber() const NO_THROW;
        METHOD_(bool)   nextLine() throw(OSError, LineTooLong);

    private:
        TextFileImpl*   m_pImpl;
    };

}
}

#if defined(_MSC_VER)
#   pragma warning(pop)
#endif

#endif // OPEN_EMBL_TEXT_FILE_INCLUDED
