/**++
 *   
 *   LICENSE
 *   -------
 *   
 *   Copyright (c) 2004 Renato Mancuso
 *   All rights reserved.
 *   
 *   Redistribution and use in source and binary forms, with or without modification, are 
 *   permitted provided that the following conditions are met:
 *   
 *   - Redistributions of source code must retain the above copyright notice, this list 
 *     of conditions and the following disclaimer.
 *   
 *   - Redistributions in binary form must reproduce the above copyright notice, this list
 *     of conditions and the following disclaimer in the documentation and/or other materials 
 *     provided with the distribution.
 *   
 *   - Neither the name of Renato Mancuso nor the names of its contributors may be used to 
 *     endorse or promote products derived from this software without specific prior written 
 *     permission.
 *   
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS 
 *   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
 *   AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 *   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 *   IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 *   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *   
--**/


#include "TextSourceOnStringListAdapter.hpp"

namespace OpenEMBL
{
namespace Phoenix
{

    TextSourceOnStringListAdapter::TextSourceOnStringListAdapter(
        std::vector<std::string> const & theLines,
        long                             theInitialOffset)
        : m_Lines(theLines)
        , m_Current(0)
        , m_Offset(theInitialOffset)
    {
    }

    METHODIMP_(LPCSTR) 
    TextSourceOnStringListAdapter::currentLine() const NO_THROW
    {
        if (m_Current < m_Lines.size())
            return m_Lines[m_Current].c_str();

        return NULL;
    }

    METHODIMP_(long)   
    TextSourceOnStringListAdapter::currentLineNumber() const NO_THROW
    {
        return long(m_Current) + m_Offset;
    }

    METHODIMP_(bool)   
    TextSourceOnStringListAdapter::nextLine()
    {
        if (m_Current < m_Lines.size())
            ++m_Current;

        return m_Current < m_Lines.size();
    }

}
}

