//
// regex support
//

#include <cxxtest/TestSuite.h>
#include <Regex.hpp>

using namespace OpenEMBL::Phoenix;

class RegexTestSuite : public CxxTest::TestSuite
{
    Regex* _re;


public:
    void setUp()
    {
        _re = new Regex( "(\\d{2})\\s(JAN|FEB|MAR|APR)\\s(\\d{4})", PCRE_CASELESS );
    }

    void tearDown()
    {
        delete _re;
    }

    void testCreate( void )
    {
        Regex re( "\\d+" );    
    }

    void testNoMatch( void )
    {
        std::string line = "bxx";
        Match m;

        TS_ASSERT( !regexSearch( line, m, *_re ) );
    }

    void testCaptureGroups( void )
    {
        std::string line = "12 JAN 2004";

        Match m;

        TS_ASSERT( regexSearch( line, m, *_re ) );

        TS_ASSERT( m.str(0) == line );
        TS_ASSERT( m.str(1) == "12" );
        TS_ASSERT( m.str(2) == "JAN" );
        TS_ASSERT( m.str(3) == "2004" );
    }

    void testMatchCaseless( void )
    {
        std::string s1 = "12 Jan 1987";
        std::string s2 = "18 MAR 2004";

        Match m;

        if ( regexSearch( s2, m, *_re ) )
        {
            TS_ASSERT( m.str(0) == s2 );
        }
        else
        {
            TS_FAIL( "case sensitive match: Failed" );
        }

        if ( regexSearch( s1, m, *_re ) )
        {
            TS_ASSERT( m.str(0) == s1 );
        }
        else
        {
            TS_FAIL( "case insensitive match: Failed" );
        }
    }

    void testMerge( void )
    {
        std::string line    = "I was born in 18 APR 2005 in Ottawa";
        std::string result  = regexMerge( line, *_re, "19 Nov 1969" );
        TS_ASSERT( result == "I was born in 19 Nov 1969 in Ottawa" );
    }

    void testMergeNot( void )
    {
        std::string line = "bxx";
        std::string result = regexMerge( line, *_re, "UKK" );

        TS_ASSERT( result == line );
    }

};
