//
// string handling
//

#include <cxxtest/TestSuite.h>
#include <StringUtils.hpp>

using namespace OpenEMBL::Phoenix;

class StringUtilsTestSuite : public CxxTest::TestSuite
{
public:

    void testTrimLeft( void )
    {
        TS_ASSERT( trimLeft( "   123" ) == "123" );
        TS_ASSERT( trimLeft( "123 " ) == "123 " );
        TS_ASSERT( trimLeft( "123" ) == "123" );
        TS_ASSERT( trimLeft( "    " ) == "" );
        TS_ASSERT( trimLeft( " " ) == "" );
        TS_ASSERT( trimLeft( "" ) == "" );
    }

    void testTrimRight( void )
    {
        TS_ASSERT( trimRight( "   123" ) == "   123" );
        TS_ASSERT( trimRight( "123 " ) == "123" );
        TS_ASSERT( trimRight( "123" ) == "123" );
        TS_ASSERT( trimRight( "    " ) == "" );
        TS_ASSERT( trimRight( " " ) == "" );
        TS_ASSERT( trimRight( "" ) == "" );
    }

    void testTrim( void )
    {
        TS_ASSERT( trim( "   123" ) == "123" );
        TS_ASSERT( trim( "123   " ) == "123" );
        TS_ASSERT( trim( "123" ) == "123" );
        TS_ASSERT( trim( "    " ) == "" );
        TS_ASSERT( trim( " " ) == "" );
        TS_ASSERT( trim( "" ) == "" );
    }

    void testRemoveTerminator( void )
    {
        std::string line = "ABCD#";

        removeTerminator( line, '#' );
        TS_ASSERT( line == "ABCD" );

        removeTerminator( line, '#' );
        TS_ASSERT( line == "ABCD" );

        line = "#";

        removeTerminator( line, '#' );
        TS_ASSERT( line == "" );
    }

    void testStrCaseCmp( void )
    {
        const char* left  = "ABCD";
        const char* right = "abcd";

        TS_ASSERT( strCaseCmp( left, right ) == 0 );
    }

    void testStrCaseCmpNoMatch( void )
    {
        const char* left  = "ABCD";
        const char* right = "abcdx";

        TS_ASSERT( strCaseCmp( left, right ) != 0 );
    }

    void testStrCaseNCmp( void )
    {
        const char* left  = "ABCDxxx";
        const char* right = "abcdkkk";

        TS_ASSERT( strNCaseCmp( left, right, 4 ) == 0 );
    }

    void testStrCaseNCmpNoMatch( void )
    {
        const char* left  = "ABCD";
        const char* right = "abc";

        TS_ASSERT( strNCaseCmp( left, right, 4 ) != 0 );
    }

};
