/**++
*   
*   LICENSE
*   -------
*   
*   Copyright (c) 2004, 2006 Renato Mancuso
*   All rights reserved.
*   
*   Redistribution and use in source and binary forms, with or without modification, are 
*   permitted provided that the following conditions are met:
*   
*   - Redistributions of source code must retain the above copyright notice, this list 
*     of conditions and the following disclaimer.
*   
*   - Redistributions in binary form must reproduce the above copyright notice, this list
*     of conditions and the following disclaimer in the documentation and/or other materials 
*     provided with the distribution.
*   
*   - Neither the name of Renato Mancuso nor the names of its contributors may be used to 
*     endorse or promote products derived from this software without specific prior written 
*     permission.
*   
*   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS 
*   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
*   AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
*   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
*   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
*   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
*   IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
*   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*   
--**/

#include <Phoenix.hpp>
#include <string>
#include <fstream>

namespace MyNamespace {

	class CdsExtractor 
		: private OpenEMBL::Phoenix::FileParserHost
	{
	public:
		// typedefs
		typedef OpenEMBL::Phoenix::StringList StringList;
		typedef OpenEMBL::Phoenix::String String;

		// construction
		CdsExtractor(char const * theFilename);
		~CdsExtractor() throw();

		void run();		

	private:
		void handleError(
			long          theLineNumber,
			int           theErrorCode,
			char const*   theDescription,
			char const*   theMessage);

		void handleWarning(
			long            theLineNumber,
			int             theWarningNumber,
			int             theWarningLevel,
			char const*     theDescription,
			char const*     theMessage);

		METHOD onBeginEntry(long theLineNumber);
		METHOD onEndEntry();
		METHOD onID(long theLineNumber, const OpenEMBL::Phoenix::IDLine & theField);
		METHOD onBeginFeatureKey(long theLineNumber, OpenEMBL::Phoenix::FeatureKey const & theField);
		METHOD onEndFeatureKey();
		METHOD onFeatureQualifier(long theLineNumber, OpenEMBL::Phoenix::FeatureQualifier const  & theQualifier);

		void openOutfile(const char* fileName);
		void closeOutfile();
		void saveCDS();
		void dequoteQualifierValue( StringList & value );
		void getQualifierValues( String const & qualifierName, std::vector<StringList> & values );
		void getUniprotIdList( std::vector<StringList> const & dbXrefs, StringList  & ids );
		String getUniprotId();
		String getProteinId();
		String getGeneName();
		void writeFastaHeader();
		void writeSequence();
		bool isPartialCDS( OpenEMBL::Phoenix::LocationElementList const & locationElements );
		bool isPartialFlag( long flags );
		
		static int getMinValue( int a, int b );

	private:
		std::string     _accession;
		std::ofstream*	_outfile;
		bool			_inCDS;

		OpenEMBL::Phoenix::FeatureKey _key;
		std::vector<OpenEMBL::Phoenix::FeatureQualifier> _qualifiers;
	};

} // namespace