
/* Genomic Comparison Tool
   Master Thesis of computer science

   Author: Yue Lu
   Version: 1.1

*/


/* this class is the table model for the
	datasetTable
*/
import java.awt.*;
import java.awt.event.*;
import java.sql.*;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;


//it is implement AbstractTableModel, so it needs to implement all the methods

public class DataSetTableModel extends AbstractTableModel
{
	//constructor
	public DataSetTableModel(ResultSet rs)
   {

    try
      {  rsmd = rs.getMetaData();

         int columns = getColumnCount();

		//make the two dimension array to put the query data
         Data=new Object[10][columns+1];
		 int i=0;
         while (rs.next())
         {
			for(int j=1; j<=columns; j++)
			{
				Data[i][j-1]=rs.getObject(j);
				//System.out.println("Data"+Data[i][j-1]);

			}
			i++;
         }

         rowNum=i;
         //System.out.println("rowNum"+rowNum);
      }

      catch(SQLException e)
      {
		  System.out.println("Error 11" + e);
      }

   }
	//get the values from each row and column
   public Object getValueAt(int row, int column)
   {
	   if (row < rowNum){

         return Data[row][column];
	 }
      else{

         return null;
	 }
   }

	//get the row count
   public int getRowCount()
   {
	   return rowNum;
   }

	//get the column name
   public String getColumnName(int column)
   {
	   try
      {
		  return rsmd.getColumnName(column + 1);
      }

      catch(SQLException e)
      {
		  System.out.println("" + e);

          return "";
      }
   }

	//get the column count
   public int getColumnCount()
   {
	   try
      {
		  return rsmd.getColumnCount();
      }

      catch(SQLException e)
      {
		  System.out.println("" + e);
          return 0;
      }

   }

   private ResultSetMetaData rsmd;
   private Object[][]Data;
   private int rowNum;

}