

/* Genomic Comparison Tool
   Master Thesis of computer science

   Author: Yue Lu
   Version: 1.1

*/



/* This is the whole interface program, it used gridbagLayout
   to arrange the interface.
*/


import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.net.*;
import java.sql.*;
import java.io.*;
import java.util.*;


public class VisualInterface extends JFrame {

  /*Constructor*/

  public VisualInterface ()
  {
    //set Icon
      
    setIconImage(Toolkit.getDefaultToolkit().createImage(VisualInterface.class.getResource("in-line-nucl.gif")));

    //get contentPane, set BorderLayout
    Container contentPane = getContentPane();
    contentPane.setLayout(new BorderLayout());
    
    //Set the frame size as the user's screen size
	Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
	height=(int)screenSize.height*4/7;
	System.out.println("Loading, Please Wait............");
    this.setSize(new Dimension(screenSize.width,screenSize.height-25));
    this.setTitle("Genome Comparison Tool");

//**************************************************************************
	//JToolBar

	//Open Database Button

	ImageIcon OpenImage = new ImageIcon("open_folder.gif");
	JButton OpenButton = new JButton();
	OpenButton.setIcon(OpenImage);
	OpenButton.setText("Open Database");
	OpenButton.setBorder(null);
	OpenButton.setMaximumSize(new Dimension(200, 30));
        OpenButton.setPreferredSize(new Dimension(250, 40));
	OpenButton.setToolTipText("Open Dataset");

	//Open database button actionListener
    OpenButton.addActionListener(new java.awt.event.ActionListener() {
    public void actionPerformed(ActionEvent e) {
      OpenButton_actionPerformed(e);
      }
    });

    //Help Button
 	ImageIcon HelpImage = new ImageIcon("help1.gif");

	JButton HelpButton = new JButton();
	HelpButton.setIcon(HelpImage);
	HelpButton.setText("Readme");
	HelpButton.setBorder(null);
	HelpButton.setMaximumSize(new Dimension(200, 30));
	HelpButton.setPreferredSize(new Dimension(250, 40));
	HelpButton.setToolTipText("Read Me");

	//Help Button actionListener
    HelpButton.addActionListener(new java.awt.event.ActionListener() {
    public void actionPerformed(ActionEvent e) {
      HelpButton_actionPerformed(e);
      }
    });

	//Exit button
	ImageIcon ExitImage = new ImageIcon("exit.gif");

	JButton ExitButton= new JButton();
	ExitButton.setIcon(ExitImage);
	ExitButton.setText("Exit");
	ExitButton.setBorder(null);
	ExitButton.setMaximumSize(new Dimension(200, 30));
        ExitButton.setPreferredSize(new Dimension(250, 40));
        ExitButton.setToolTipText("Exit Genome Comparison Tool");

	//Exit Button actionListener
    ExitButton.addActionListener(new java.awt.event.ActionListener() {
    public void actionPerformed(ActionEvent e) {
      ExitButton_actionPerformed(e);
      }
    });

        //Overview button
        ImageIcon OverviewImage = new ImageIcon("overview.gif");
	
        JButton OverviewButton = new JButton();
        OverviewButton.setIcon(OverviewImage);
        OverviewButton.setText("Overview");
	OverviewButton.setBorder(null);
	OverviewButton.setMaximumSize(new Dimension(150, 30));
	OverviewButton.setPreferredSize(new Dimension(250, 40));
	OverviewButton.setToolTipText("Overview of the system");

	//Help Button actionListener
    OverviewButton.addActionListener(new java.awt.event.ActionListener() {
    public void actionPerformed(ActionEvent e) {
      OverviewButton_actionPerformed(e);
      }
    });

        ImageIcon InterfaceImage = new ImageIcon("interface.gif");
        
        JButton InterfaceButton = new JButton();
        InterfaceButton.setIcon(InterfaceImage);
        InterfaceButton.setText("Interface Description");
	InterfaceButton.setBorder(null);
	InterfaceButton.setMaximumSize(new Dimension(200, 40));
	InterfaceButton.setPreferredSize(new Dimension(250, 40));
	InterfaceButton.setToolTipText("Interface Description");

	//Help Button actionListener
    InterfaceButton.addActionListener(new java.awt.event.ActionListener() {
    public void actionPerformed(ActionEvent e) {
      InterfaceButton_actionPerformed(e);
      }
    });

	JToolBar MenuTool = new JToolBar();

	MenuTool.add(OpenButton);
 	MenuTool.add(HelpButton);
 	MenuTool.add(InterfaceButton);
	MenuTool.add(OverviewButton);
 	MenuTool.add(ExitButton);


 	//add the ToolBar to the north of contentPane
 	contentPane.add(MenuTool, BorderLayout.NORTH);


//***********************************************************************


	//add the whole Panel to the center of the contentPane
    WholePanel.setLayout(new GridBagLayout());
    contentPane.add(WholePanel, BorderLayout.CENTER);


//************************************************************************
    //DisplayPanel for graphics of the database
    DisplayPanel.setBorder(BorderFactory.createEtchedBorder());
	DisplayPanel.setLayout(new BorderLayout());
	scrollPane4= new JScrollPane(DisplayPanel,
	    JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
	  	JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);



//************************************************************************

    //for displaying dataset
    DataPanel.setBackground(Color.white);
    DataPanel.setBorder(BorderFactory.createEtchedBorder());
    DataPanel.setMinimumSize(new Dimension(10, 10));
	DataPanel.setPreferredSize(new Dimension(10, 10));
	DataPanel.setMaximumSize(new Dimension(screenSize.width, 20));
	scrollPane5= new JScrollPane(DataPanel,
	    JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
	  	JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);



//************************************************************************


	JPanel BottomPanel = new JPanel();
    BottomPanel.setBorder(BorderFactory.createEtchedBorder());
    BottomPanel.setMinimumSize(new Dimension(14, 14));
    BottomPanel.setLayout(new GridBagLayout());
    BottomPanel.setMaximumSize(new Dimension(screenSize.width, 100));


//*************************************************************************

    //Panel for table name list
    JPanel TableNamePanel = new JPanel();
    TableNamePanel.setMinimumSize(new Dimension(14, 14));
    TableNamePanel.setLayout(new GridBagLayout());

 	//Label for DataSet
 	JLabel DataSetLabel = new JLabel();
	DataSetLabel.setHorizontalAlignment(SwingConstants.LEFT);
        DataSetLabel.setText("Dataset");

        //Icon for the arrow
  	JLabel IconLabel1 = new JLabel();
        IconLabel1.setIcon(new ImageIcon("cy_r_arr.gif"));
        IconLabel1.setMaximumSize(new Dimension(100, 27));
	IconLabel1.setPreferredSize(new Dimension(100, 27));



   /* add Table_Name to the TableList*/
    JList TableList = new JList();
    DatabaseTableName Table_Name=new DatabaseTableName();
    Vector words1=Table_Name.getTableName();
    TableList = new JList(words1);
    JScrollPane scrollPane1 = new JScrollPane(TableList);
    TableList.setBackground(Color.lightGray);
    TableList.setBorder(BorderFactory.createLoweredBevelBorder());
    TableList.setToolTipText("Click the table to display the attributes in the table");

    //the actionListener for the Table list
    TableList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
	      public void valueChanged(ListSelectionEvent e) {
	        TableList_valueChanged(e);
	      }
    });

    //add Labels and list to the Panel
    TableNamePanel.add(DataSetLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 7, 0, 35), 44, 0));
    TableNamePanel.add(scrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 7, 0, 0), 112, 68));
    TableNamePanel.add(IconLabel1, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.SOUTHEAST, GridBagConstraints.NONE, new Insets(17, 0, 21, 0), -35, 3));

//************************************************************************************


    //Panel for attribute list
    JPanel AttributPanel = new JPanel();
    AttributPanel.setMinimumSize(new Dimension(14, 14));
    AttributPanel.setLayout(new GridBagLayout());

    //Label for attribute
    JLabel AttributeLabel = new JLabel();
    AttributeLabel.setHorizontalAlignment(SwingConstants.LEFT);
    AttributeLabel.setText("Features");

    //Icon for arrow
    JLabel IconLabel2 = new JLabel();
    IconLabel2.setIcon(new ImageIcon("cy_r_arr.gif"));
    IconLabel2.setMaximumSize(new Dimension(100, 27));
    IconLabel2.setPreferredSize(new Dimension(100, 27));



    /* add Column_Name to the AttributeList*/

    JScrollPane scrollPane2 = new JScrollPane(AttributeList);
    AttributeList.setBackground(Color.lightGray);
    AttributeList.setBorder(BorderFactory.createLoweredBevelBorder());
    AttributeList.setToolTipText("Select the feature you want to display to show all the different values for that feature" );

    // add the actionListener for the Attibute list
    AttributeList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
     public void valueChanged(ListSelectionEvent e) {
        AttributeList_valueChanged(e);
        System.out.println("Inside VisualInterface after calling AttributeList_valueChanged");
      }
    });


	//add Labels and list to the Panel
    AttributPanel.add(AttributeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 4, 0, 0), 29, 0));
    AttributPanel.add(IconLabel2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.SOUTHWEST, GridBagConstraints.NONE, new Insets(20, 0, 20, 0), -35, 0));
    AttributPanel.add(scrollPane2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.SOUTHEAST, GridBagConstraints.BOTH, new Insets(0, 4, 0, 0), 110, 70));


//*****************************************************************************************

	//Panel for Jtable and buttons
	JPanel ColorShapePanel = new JPanel();
	ColorShapePanel.setLayout(new GridBagLayout());
	ColorShapePanel.setMinimumSize(new Dimension(14, 14));

	//Panel for ColorShape Table
  	JPanel TablePanel = new JPanel();
  	TablePanel.setLayout(new GridBagLayout());

  	//Label for the Color and Shape table
  	JLabel ColorShapeLabel = new JLabel();
        ColorShapeLabel.setHorizontalAlignment(SwingConstants.LEFT);
        ColorShapeLabel.setText("Color and shape");

	/* add the color JTable using defaultTableModel*/

    TableModel Color_Table=new ColorTableModel(columnNames,0);
    ColorTable=new JTable(Color_Table);

    ColorTable.setBackground(Color.lightGray);
    ColorTable.setBorder(BorderFactory.createLoweredBevelBorder());
    ColorTable.setToolTipText("Click the color column to select color, and click shape column to select shape");
    ColorTable.setRowSelectionAllowed(true);
    ColorTable.setSelectionBackground(Color.blue);
    ColorTable.clearSelection();

    // set up default renderers and editors
        System.out.println("Inside VisualInterface class before setting defaultrenderer as ColorTableCellRenderer for ColorTable");
	ColorTable.setDefaultRenderer(Color.class,
	new ColorTableCellRenderer());

	ColorTable.setDefaultEditor(Color.class,
	new ColorTableCellEditor());

	// set up the combo box for the Shape

	JComboBox shapeCombo = new JComboBox();

	//use the customer Icon Image
	Icon blank = new blank();
	Icon Shape1 = new Shape1();
	Icon Shape2 = new Shape2();
	Icon Shape3 = new Shape3();
	Icon Shape4 = new Shape4();

	//add the Icons to the JComboBox
	shapeCombo.addItem(blank);
	shapeCombo.addItem(Shape1);
	shapeCombo.addItem(Shape2);
	shapeCombo.addItem(Shape3);
	shapeCombo.addItem(Shape4);

	//init the Color Shape Table
	TableColumnModel columnModel = ColorTable.getColumnModel();
	TableColumn shapeColumn
	     = columnModel.getColumn(3);

	 //set up the default celleditor for combobox
	shapeColumn.setCellEditor(new DefaultCellEditor(shapeCombo));

        JScrollPane scrollPane3 = new JScrollPane(ColorTable);

	//add the label to TablePanel
        TablePanel.add(ColorShapeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
           ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 4, 0, 7), 107, 0));

        //add the table to the TablePanel
        TablePanel.add(scrollPane3, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 4, 0, 7), 237, 87));


        //add the TablePanel to the ColorShapePanel
        ColorShapePanel.add(TablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
	        ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(2, 4, 0, 0), 0, 1));

//**************************************************************************************

    //Panel for buttons
	JPanel ButtonPanel = new JPanel();


    // Cancel button

    JButton CancelButton = new JButton();//Cancel
    CancelButton.setFont(new java.awt.Font("Dialog", 0, 10));
    CancelButton.setMaximumSize(new Dimension(71, 25));
    CancelButton.setMinimumSize(new Dimension(71, 27));
    CancelButton.setPreferredSize(new Dimension(71, 27));
    CancelButton.setText("Cancel");

    //the actionListener for the cancelbutton
    CancelButton.addActionListener(new java.awt.event.ActionListener() {
    public void actionPerformed(ActionEvent e) {
      CancelButton_actionPerformed(e);
      }
    });


    //delete button

    JButton DeleteButton = new JButton();//delete
    DeleteButton.setFont(new java.awt.Font("Dialog", 0, 10));
    DeleteButton.setMaximumSize(new Dimension(71, 25));
    DeleteButton.setMinimumSize(new Dimension(71, 25));
    DeleteButton.setPreferredSize(new Dimension(71, 25));
    DeleteButton.setText("Delete");

    //the actionListener for the deletebutton
    DeleteButton.addActionListener(new java.awt.event.ActionListener() {
    public void actionPerformed(ActionEvent e) {
      DeleteButton_actionPerformed(e);
      }
    });


    // display button

    JButton DisplayButton = new JButton();//display
    DisplayButton.setFont(new java.awt.Font("Dialog", 0, 10));
    DisplayButton.setPreferredSize(new Dimension(71, 25));
    DisplayButton.setText("Display");

    //the actionListener for the displaybutton
    DisplayButton.addActionListener(new java.awt.event.ActionListener() {
    public void actionPerformed(ActionEvent e) {
      DisplayButton_actionPerformed(e);
      }
    });


	//add the buttons to the button Panel
    ButtonPanel.add(CancelButton, null);
    ButtonPanel.add(DeleteButton, null);
    ButtonPanel.add(DisplayButton, null);


	//add the buttonPanel to the ColorShape Panel
    ColorShapePanel.add(ButtonPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0
	       ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(2, 9, 0, 4), -155, 70));

//***************************************************************************

// add the three Panels to the Bottom Panel
    BottomPanel.add(TableNamePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(2, 1, 3, 0), 147, 74));
	BottomPanel.add(AttributPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.SOUTHWEST, GridBagConstraints.BOTH, new Insets(5, 0, 0, 6), 147, 74));
 	BottomPanel.add(ColorShapePanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(2, 0, 3, 3), 330, 74));

// add three Panels to the WholePanel

    WholePanel.add(scrollPane4, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(2, 2, 0, 2), 657, height-30));
    WholePanel.add(scrollPane5, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 2, 0, 2), 659, 5));
    WholePanel.add(BottomPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 2, 2, 2), 658, 65));

  }


//*****************************************************************************

  /* when close the window, close the database connection*/

  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {

	  DatabaseConnection connection=DatabaseConnection.getInstance();
	  connection.Close_Database();
	  System.out.println("Goodbye, please close the window!");
      System.exit(0);
    }
  }


//******************************************************************************

  /* ActionListener for TableList*/
   void TableList_valueChanged(ListSelectionEvent evt)
   {

	   	DefaultTableModel model = (DefaultTableModel)ColorTable.getModel();

	   	//remove all the rows in the table when user select cancel
	   	model.setNumRows(0);

	   //init the FilteredAttribute to get the column name
	   //which has less than 20 distinct values
	   TableFilteredAttribute FilteredAttribute=new TableFilteredAttribute(evt, AttributeList);

		//get the table name which selected by the user
	   Table_Name=FilteredAttribute.getTableName();
   }


//*******************************************************************************

/* ActionListener for the Attribute List*/

   void AttributeList_valueChanged(ListSelectionEvent evt)
   {
	   //add the column name and value which user selected to the Color Shape table
		AttributeSelection Attribute=new AttributeSelection(evt, ColorTable, Table_Name);
                System.out.println("After selecting attribute in AttributeList_valueChanged");
   }


//********************************************************************************

 //CancelButton actionlistener
 void CancelButton_actionPerformed(ActionEvent e) {


 	DefaultTableModel model = (DefaultTableModel)ColorTable.getModel();

	//remove all the rows in the table when user select cancel
	model.setNumRows(0); 
 }

//**********************************************************************************

//DeleteButton actionlistner
  void DeleteButton_actionPerformed(ActionEvent e) {

	 // int[] selected = ColorTable.getSelectedRows();
         // remove rows from model, starting at the last
         // index so that the row numbers aren't affected

	DefaultTableModel model = (DefaultTableModel)ColorTable.getModel();
      /**System.out.println("The number of selected items is " + selected.length);
	//remove the rows which seleced by the user
	//for (int i = selected.length - 1; i >= 0; i--)
        for (int i = selected.length-1; i >= 0; i--)
        {
            System.out.println("Deleting " + selected[i]);
     	model.removeRow(selected[i]);
        } */
      // am trying to write code which would remove the most recently added rows
     int numberOfRows = ColorTable.getRowCount();
     String columnName =(String) model.getValueAt(numberOfRows-1,0);
     System.out.println("The number of rows present in ColorTable is "+numberOfRows + " and the value at the last one is " + columnName);
     for (int i=numberOfRows-1;i>=0;i--)
     {
            
         if(((String)model.getValueAt(i,0)).equals(columnName)) 
         {
         model.removeRow(i);
         }
     }
    }
  

//***********************************************************************************

//DisplayButton actionlistener
  void DisplayButton_actionPerformed(ActionEvent e) {

   if(Table_Name !=null){

	DefaultTableModel model = (DefaultTableModel)ColorTable.getModel();

	//get the data in the color shape table
	Color_Data=model.getDataVector();

	//init the DatabaseVisualDisplay to use the Color_data
	//to fill the color or the shape of each rectangle

	Component Display=new DatabaseVisualDisplay(Table_Name,Color_Data);
	Display.setBackground(Color.white);

	//remove the old panel
	WholePanel.remove(scrollPane4);

	//add the new DisplayPanel
	 scrollPane4 = new JScrollPane(Display,
		JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
  		JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);

	    WholePanel.add(scrollPane4, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(2, 2, 0, 2), 657,height-30 ));

	//Mouse listener for the mouse click on the square

	 Display.addMouseListener(new MouseAdapter()
	  {  public void mousePressed(MouseEvent evt)

	  	 {
			 //get the location of the mouse
			int x = evt.getX();
	  	    int y = evt.getY();

	  	    current = find(x, y);

	  		if(current!=-1)
	  		{

				//init the DatabaseDataDisplay to display the dataset in the JTable
	  	        DatabaseDataDisplay D_Display=new DatabaseDataDisplay(Table_Name, current);
	  	    	D_Display.setBackground(Color.white);

				//remove the old panel
				WholePanel.remove(scrollPane5);

				//add the new DataPanel
				scrollPane5 = new JScrollPane(D_Display,
				  	JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
  					JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
  				WholePanel.add(scrollPane5, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
            		,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 2, 0, 2), 659, 5));

	  	        WholePanel.validate();
	  	       }
	  	  }
	   });


	WholePanel.validate();


    }
  }


//************************************************************************************

// Open the Access Database
  void OpenButton_actionPerformed(ActionEvent e)
  {
	  Runtime r= Runtime.getRuntime();
	  try{

		//  open the Access database
	  	Process p=r.exec("rundll32"+" "+"Url.dll,FileProtocolHandler"+" "+"VDApp.mdb");

	  }
	  catch(Exception ex)
	  {
		  ex.printStackTrace();
	  }
  }


//*************************************************************************************

//Open the README.doc
  void HelpButton_actionPerformed(ActionEvent e)
  {
	  Runtime r= Runtime.getRuntime();
	  try{

		  //open the MS word document
	  	Process p=r.exec("rundll32"+" "+"Url.dll,FileProtocolHandler"+" "+"README.doc");

	  }
	  catch(Exception ex)
	  {
		  ex.printStackTrace();
	  }
  }


//*************************************************************************************

//exit the program and close the database
  void ExitButton_actionPerformed(ActionEvent e)
  {
	  //exit the program and close the database

	  DatabaseConnection connection=DatabaseConnection.getInstance();
	  connection.Close_Database();
	  System.out.println("Goodbye, please close the window!");
      System.exit(0);
  }

//**************************************************************************************

//Open the README.doc
  void OverviewButton_actionPerformed(ActionEvent e)
  {
	  Runtime r= Runtime.getRuntime();
	  try{

		  //open the MS word document
	  	Process p=r.exec("rundll32"+" "+"Url.dll,FileProtocolHandler"+" "+"Overview.doc");

	  }
	  catch(Exception ex)
	  {
		  ex.printStackTrace();
	  }
  }
//***************************************************************************************

//Open the README.doc
  void InterfaceButton_actionPerformed(ActionEvent e)
  {
	  Runtime r= Runtime.getRuntime();
	  try{

		  //open the MS word document
	  	Process p=r.exec("rundll32"+" "+"Url.dll,FileProtocolHandler"+" "+"Interface Description.doc");

	  }
	  catch(Exception ex)
	  {
		  ex.printStackTrace();
	  }
  }
//***************************************************************************************


//find the position of the gene in the genome table
  public int find(int x, int y)
  {
	  //get the whole database row number
	String Num_Query="Select * from ["+Table_Name+"]";
	DatabaseRowNumber num=new DatabaseRowNumber(Num_Query);
	int number=num.getRowNumber();

	//return the location the mouse click
	int length=number/100;
    if(x>100 && x<900 && y>24 && y<(100*8*length))
     	return (y-24)/8*100+(x-100)/8+1;
  	else
  	  	return -1;
   }

//**************************************************************************************

  //private member variables

  private JPanel WholePanel = new JPanel();

  //two main Panels on the screen, DisplayPanel is for display graphics
  private JPanel DisplayPanel = new background();

  //scrollPane for DisplayPanel
  private JScrollPane scrollPane4;

  //Panel for display dataset JTable
  private JPanel DataPanel = new JPanel();

  //scrollPane for dataPanel
  private JScrollPane scrollPane5;

  private JList AttributeList = new JList();
  private JTable ColorTable;

  private Object[] columnNames={"Attribute", "Value", "Color", "Shape"};
  private String Table_Name;
  private static Vector Color_Data;
  private int current;
  private int height;


}