
//~--- JDK imports ------------------------------------------------------------

/**
@author Lalitha Viswanath
 */

/* the tableCellEditor for the color column*/
import java.awt.*;
import java.awt.event.*;

import java.io.*;

import java.util.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

//~--- classes ----------------------------------------------------------------

public class ColorTableCellEditor extends ColorTableCellRenderer
        implements TableCellEditor {
    private EventListenerList listenerList = new EventListenerList();
    private ChangeEvent       changeEvent  = new ChangeEvent(this);
    private JDialog           ColorChooserDialog;
    private JColorChooser     ColorValue;
    private Color             color;

    //~--- constructors -------------------------------------------------------

    ColorTableCellEditor() {
        ColorValue = new JColorChooser();

        // listener for OK button
        ActionListener okListener = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                stopCellEditing();
            }
        };

        // listener for Cancel button
        ActionListener cancelListener = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                cancelCellEditing();
            }
        };

        // create a dialog for JColorChooser
        ColorChooserDialog = JColorChooser.createDialog(null, "select color",
                false, ColorValue, okListener, cancelListener);
    }

    //~--- methods ------------------------------------------------------------

    /**
     * Adds CellEditorListener
     * @param l Listener
     */
    public void addCellEditorListener(CellEditorListener l) {
        listenerList.add(CellEditorListener.class, l);
    }

    /**
     * cancels cell editing
     */
    public void cancelCellEditing() {
        Object[] listeners = listenerList.getListenerList();

        // cancel the listener if the listener type matched
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] == CellEditorListener.class) {
                // Lazily create the event:
                if (changeEvent == null) {
                    changeEvent = new ChangeEvent(this);
                }

                ((CellEditorListener) listeners[i + 1]).editingCanceled(
                    changeEvent);
            }
        }

        ColorChooserDialog.setVisible(false);
    }

    /**
     * removes CellEditorListener
     * @param l removes Listener L
     */
    public void removeCellEditorListener(CellEditorListener l) {
        listenerList.remove(CellEditorListener.class, l);
    }

    /**
     *
     * @param e Event Object
     * @return
     */
    public boolean shouldSelectCell(final EventObject e) {
        ColorChooserDialog.setVisible(true);

        return true;
    }

    /**
     * determines whether cell editing has stopped or not
     * @return returns true or false based on whether cell editing is
     * stopped or not
     */
    public boolean stopCellEditing() {
        Object[] listeners = listenerList.getListenerList();

        // stop the listener if the listener type matched
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] == CellEditorListener.class) {
                // Lazily create the event:
                if (changeEvent == null) {
                    changeEvent = new ChangeEvent(this);
                }

                ((CellEditorListener) listeners[i + 1]).editingStopped(
                    changeEvent);
            }
        }

        ColorChooserDialog.setVisible(false);

        return true;
    }

    //~--- get methods --------------------------------------------------------

    /**
     * returns cellEditor
     * @return returns value of particular cell editor
     */
    public Object getCellEditorValue() {
        return ColorValue.getColor();
    }

    /**
     *
     * @param table
     * @param value
     * @param isSelected
     * @param row
     * @param column
     * @return
     */
    public Component getTableCellEditorComponent(final JTable table,
            final Object value, final boolean isSelected, final int row,
            final int column) {
        ColorValue.setColor((Color) value);

        Component Color_Panel = getTableCellRendererComponent(table, value,
                                    isSelected, true, row, column);

        return Color_Panel;
    }

    /**
     *
     * @param e
     * @return
     */
    public boolean isCellEditable(final EventObject e) {
        return true;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
