
//~--- JDK imports ------------------------------------------------------------

import java.awt.*;

import java.io.*;

/* the program for display each protein's data */
import java.net.*;

import java.sql.*;

import java.util.*;

import javax.swing.*;


//~--- classes ----------------------------------------------------------------

//The Panle which will show the dataset data when user click on it

/**
 * Class for displaying information from Table when user clicks on the gene
 * @author Yue Lu
 * @version 1.2
 * @design Dr. George Fox, Yue Lu, Lalitha Viswanath
 */
public class DatabaseDataDisplay extends JPanel {
    public static final long serialVersionUID = 24362462L;

    //~--- fields -------------------------------------------------------------

    private Connection        con;
    private Graphics          g;
    private DataSetTableModel model;
    private String            proteinNum;
    private JScrollPane       scrollPane;
    private String            tableName;

    //~--- constructors -------------------------------------------------------

    // constructor

    /**
     * Constructor
     * @param Name Table Name from which data is to be retreived
     * @param num gene number (corrresponding to ID number) in database whose
     * data is to be retreived
     */
    public DatabaseDataDisplay(final String Name, final int num) {
        tableName  = Name;
        proteinNum = "" + num;

        // use the BorderLayout to layout the JTable
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(2000, 50));

        try {

            // get the instance of the database connection
            DatabaseConnection connection = DatabaseConnection.getInstance();

            con = connection.getConnection();

            // get the information of the protein
            Statement stmt  = con.createStatement();
            String    query = "SELECT * FROM [" + tableName + "] where ID="
                              + proteinNum;
            ResultSet rs = stmt.executeQuery(query);

            // init the datasetTableMedel
            if (model != null) {
                model = null;
            }

            model = new DataSetTableModel(rs);

            // add the JTable to the Panel
            JTable table = new JTable(model);

            table.setBackground(Color.white);

            scrollPane = new JScrollPane(table);

            this.add(scrollPane, "Center");
        } catch (SQLException ex) {
            System.out.println(
                "Error in Obtaining data from Database\n Class: DatabaseDataDisplay \n"
                + ex);
        }
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
