
//~--- JDK imports ------------------------------------------------------------

import java.awt.*;
import java.awt.event.*;

import java.io.*;

/* this class get database connection instance and
        get the resultset as a list
*/
import java.net.*;

import java.sql.*;

import java.util.*;

import javax.swing.*;
import javax.swing.event.*;

//~--- classes ----------------------------------------------------------------

/**
 * Class for executing a query by connecting to MS-Access Database VDApp
 * @author Yue Lu, Lalitha Viswanath
 * @version 1.2
 * @design Dr.George Fox, Yu Lu, Lalitha Viswanath
 */
public class DatabaseQueryString {
    private Vector<Object>     list = new Vector<Object>(2, 2);
    private HashMap    hmap = new HashMap(10);
    private Connection con;
    private String     query;

    //~--- constructors -------------------------------------------------------

    /**
     * Constructor that takes in query string, used to execute by connecting to Database
     * @param query Query String for connecting to database
     */
    public DatabaseQueryString(final String query) {
        try {

            // get the database connection instance
            DatabaseConnection connection = DatabaseConnection.getInstance();

            con = connection.getConnection();

            // execute the query
            if (query != null) {
                Statement stmt = con.createStatement();
                ResultSet rs   = stmt.executeQuery(query);

                // add the ResultSet to the vector
                list.removeAllElements();

                while (rs.next()) {
                    list.addElement(rs.getObject(1));
                    list.addElement(rs.getObject(2));
                }

                stmt.close();
                // rs.close();
            }
        } catch (SQLException ex) {
            System.out.println(
                "Error in DatabaseQueryString\n Class:DatabaseQueryString\n"
                + ex);
        }
    }

    //~--- get methods --------------------------------------------------------

    // return the query as a Vector

    /**
     * returns list of attributes
     * @return returns list of attributes
     */
    public Vector getList() {
        return list;
    }

    /**
     * returns HashMap
     * @return HashMap
     */
    public HashMap getMap() {
        return hmap;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
