
//~--- JDK imports ------------------------------------------------------------

import java.awt.*;

import java.io.*;

/* this class get database connection instance and
        get row number of the resultset
*/
import java.net.*;

import java.sql.*;

import java.util.*;

import javax.swing.*;

//~--- classes ----------------------------------------------------------------

/**
 * Class for retreiving total number of rows in database for a particular table
 * @author Yue Lu, Lalitha Viswanath
 * @version 1.2
 * @design Dr.George Fox, Yue Lu, Lalitha Viswanath
 */
public class DatabaseRowNumber {
    private int        m  = 0;
    String             qs = new String();
    private Connection con;
    private int[]      directions;
    private ResultSet  rs;

    //~--- constructors -------------------------------------------------------

    // constructor

    /**
     * Takes querystring as input and executes corresponding query
     * @param query query String
     */
    public DatabaseRowNumber(final String query) {
        try {

            // get the database connection instance
            DatabaseConnection connection = DatabaseConnection.getInstance();

            con = connection.getConnection();
            qs  = query;

            // execute the query
            Statement stmt = con.createStatement();

            // ResultSet rs = stmt.executeQuery(query);
            rs = stmt.executeQuery(query);

            // count the row number
            while (rs.next()) {
                m++;
            }

            stmt.close();
            // rs.close();
        } catch (SQLException ex) {
            System.out.println(
                "Error in accessing Database\nClass:DatabaseRowNumber\n" + ex);
        }
    }

    //~--- methods ------------------------------------------------------------

    /**
     * Finds directions by  connecting to database and searching for
     * presence of column named "directions" or columns named "start" and "stop"
     * In case neither is present, directions are set to "0", else
     * if gene is on forward strand, directions is set to "1" and if the gene is on
     * reverse strand, directions is set to "2"
     * Flag determines whether directions are to be displayed or not.
     * Flag=1 means the directions are to be determined by mining
     * through the database
     * Flag=0 means that directions are not to be displayed and hence
     * directions array can be set to zeroes.(default)
     * @param flag Flag determines whether directions are to be displayed or not.
     * Flag=1 means the directions are to be determined by mining
     * through the database
     * Flag=0 means that directions are not to be displayed and hence
     * directions array can be set to zeroes.(default)
     */
    public void finddirections(final int flag) {
        directions = new int[m];

        for (int i = 0; i < m; i++) {
            directions[i] = 0;
        }

        if (flag == 1) {
            try {
                DatabaseConnection connection =
                    DatabaseConnection.getInstance();

                con = connection.getConnection();

                Statement stmt = con.createStatement();

                rs         = stmt.executeQuery(qs);
                directions = new int[m];

                for (int i = 0; i < m; i++) {
                    directions[i] = 0;
                }

                ResultSetMetaData rsmd                = rs.getMetaData();
                int               noCols              = rsmd.getColumnCount();
                int               i                   = 0,
                                  temp                = 0;
                int               startFlag           = 0,
                                  stopFlag            = 0,
                                  directionFlag       = 0;
                int               startLocation       = 0,
                                  stopLocation        = 0,
                                  directionLocation   = 0;
                boolean           searchForDirections = false;

                for (i = 1; i <= noCols; i++) {
                    String colName = rsmd.getColumnName(i);

                    if (colName.trim().equalsIgnoreCase("start")) {
                        startFlag     = 1;
                        startLocation = i;
                    } else if (colName.trim().equalsIgnoreCase("stop")) {
                        stopFlag     = 1;
                        stopLocation = i;
                    } else if (colName.trim().equalsIgnoreCase("direction")) {
                        directionFlag     = 1;
                        directionLocation = i;
                    }

                    if (((startFlag == 1) && (stopFlag == 1))
                            || (directionFlag == 1)) {
                        searchForDirections = true;

                        break;
                    }
                }

                // System.out.println(" Start location is " + startLocation + " Stop location is " + stopLocation + " direction Location is " + directionLocation);
                // ////
                i = 0;

                if (searchForDirections) {
                    while (rs.next()) {
                        // looks to see if start and stop are set
                        // if they are, then sets directions as per them
                        // if not, checks for direction flag
                        // if that is set, then takes that (ONLY IF START AND STOP ARE NOT SET -- in the case that all 3 r given --- )
                        // if direction is setto anything other than d or c no direction is set
                        // columns shud therefore be named start , stop or direction only.....in case any other column names are given,
                        // then it will not display direction
                        if ((startFlag == 1) && (stopFlag == 1)) {
                            int start = rs.getInt(startLocation);
                            int stop  = rs.getInt(stopLocation);

                            if (start < stop) {
                                // 1 is forward strand
                                directions[i] = 1;
                            } else {
                                // 2 is reverse strand
                                directions[i] = 2;
                            }
                        } else if (directionFlag == 1) {
                            String direction = rs.getString(directionLocation);

                            if (direction.trim().equalsIgnoreCase("R")) {
                                directions[i] = 1;
                            } else if (direction.trim().equalsIgnoreCase(
                                    "L")) {
                                // 2 is reverse strand
                                directions[i] = 2;
                            }
                        }

                        i++;
                    }

                    stmt.close();
                    /*
                     *   int[] newdirec = new int[m];
                     * newdirec[0]=directions[0];
                     * for(i=1;i<m;i++)
                     *     if(directions[i]==directions[i-1])
                     *         newdirec[i]=0;
                     *     else
                     *         newdirec[i]=directions[i];
                     * for(i=0;i<m;i++)
                     *     directions[i]=newdirec[i];
                     */
                }
            } catch (SQLException s) {
                System.out.println(
                    "Caught Exception while trying to search for directions..... "
                    + s.toString());
                System.exit(0);
            }
        }
    }

    //~--- get methods --------------------------------------------------------

    /**
     * returns the arra containing the directions corresponding to each gene
     * @return returns array containing directions corresponding to each gene/protein
     */
    public int[] getDirections() {
        return directions;
    }

    /**
     * returns the ResultSet generated
     * @return Result Set
     */
    public ResultSet getResultSet() {
        return rs;
    }

    // return the row number

    /**
     * returns total number of rows in table
     * @return returns number of rows in table
     */
    public int getRowNumber() {
        return m;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
