
//~--- JDK imports ------------------------------------------------------------

import java.awt.*;
import java.awt.event.*;

import java.io.*;

/* this class get database connection instance and
        the tables name in all database
*/
import java.net.*;

import java.sql.*;

import java.util.*;

import javax.swing.*;
import javax.swing.event.*;

//~--- classes ----------------------------------------------------------------

/**
 * Class for returning the TableName
 * @author Yue Lu, Lalitha Viswanath
 * @version 1.2
 * @design Dr.George Fox, Yue Lu, Lalitha Viswanath
 */
public class DatabaseTableName {
    private Vector<String> Table_Name = new Vector<String>(0, 1);
    private Connection     con;
    private String         query;

    //~--- constructors -------------------------------------------------------

    // constructor

    /**
     * Constructor
     */
    public DatabaseTableName() {
        try {
            // get the database connection instance
            DatabaseConnection connection = DatabaseConnection.getInstance();

            con = connection.getConnection();

            // use the DatabasMetaData to get the names of the tables in the database
            DatabaseMetaData md = con.getMetaData();
            ResultSet        rs = md.getTables(null, null, null,
                                               new String[] { "TABLE" });

            while (rs.next()) {
                String tmp = new String();

                tmp = rs.getString(3);

                Table_Name.addElement(tmp);
            }
            // rs.close();
        } catch (SQLException ex) {
            System.out.println(
                "Error in obtaining table names from Database\nClass: DatabaseTableName\n"
                + ex);
        }
    }

    //~--- get methods --------------------------------------------------------

    // reurn the database table names

    /**
     * returns the Table Name
     * @return returns the table Name
     */
    public Vector getTableName() {
        return Table_Name;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
