
/* Genomic Comparison Tool
   Master Thesis of computer science

   Author: Yue Lu
   Version: 1.1

*/

/* this class will get the database connection instance
        and get the attributes of the selected table which
        distinct values are less than 20
*/



//~--- JDK imports ------------------------------------------------------------

import java.awt.*;
import java.awt.event.*;

import java.io.*;

import java.net.*;

import java.sql.*;

import java.util.*;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.*;

//~--- classes ----------------------------------------------------------------

/**
 * Class for retreiving attributes from Database Table
 * @author Yue Lu
 * @version 1.2
 * @design Dr.George Fox, Yue Lu, Lalitha Viswanath
 */
public class TableFilteredAttribute {
    Vector<String> Filtered_Column = new Vector<String>(0, 1);
    private String Table_Name;

    //~--- constructors -------------------------------------------------------

    // constructor

    /**
     * Constructor
     */
    public TableFilteredAttribute(ListSelectionEvent evt, JList jList2) {
        if (evt.getValueIsAdjusting() == false) {
            // get the table name which user selected
            JList    source  = (JList) evt.getSource();
            Object[] values1 = source.getSelectedValues();

            Table_Name = "";

            for (int i = 0; i < values1.length; i++) {
                String word = (String) values1[i];

                Table_Name += word + " ";
            }

            // execute the query to screen the column name
            // which has less than 20 distinct values
            String             query       = "select * from [" + Table_Name
                                             + "]";
            DatabaseColumnName Column_Name = new DatabaseColumnName(query);

            // put the column name into a Vector
            Vector words2 = Column_Name.getColumnName();

            for (int i = 0; i < words2.size(); i++) {

                // query the database to get the distinct value of each column
                String Column_query = "Select distinct " + "["
                                      + words2.elementAt(i) + "] from ["
                                      + Table_Name + "]";
                DatabaseRowNumber RowNumber =
                    new DatabaseRowNumber(Column_query);

                if (RowNumber.getRowNumber() < 50) {
                    String tmp = new String();

                    tmp = (String) words2.elementAt(i);

                    Filtered_Column.addElement(tmp);
                }

                jList2.setListData(Filtered_Column);
            }
        }
    }

    //~--- get methods --------------------------------------------------------

    // get the column name which has less than 20 distinct elements

    /**
     * gets number of columns with more than 20 unique attributes
     * @return returns array of column names
     */
    public Vector getFiltered_Column() {
        return Filtered_Column;
    }

    // get the table name that use selected

    /**
     * returns table name
     * @return retruns table name
     */
    public String getTableName() {
        return Table_Name;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
