
/*
 * ZoomFrame.java
 *
 * Created on August 10, 2004, 1:44 PM
 */

/**
 *
 * @author  Lalitha Viswanath
 */
import java.awt.*;
import javax.swing.*;
import java.lang.*;
import java.io.*;
import java.util.*;
import java.sql.*;
/**
 * Class used for displaying subset of genome , when user clicks on specific gene.
 * ZoomGenes displays 200 genes upstream and dosntream of selected gene.
 * As the user increases or decreases size of display,the number of genes
 * displayed also change
 * @author Lalitha Viswanath
 * @version 1.2
 * @design Dr. George Fox, Lalitha Viswanath
 */
public class ZoomGenes extends javax.swing.JPanel {
    
    /**
     * Creates new form ZoomFrame
     * @param currentCell cell on which right-click was done
     * @param total total number of genes to display
     * @param direcs array containing directions corresponding to each gene
     * @param cdata vector containing data corresponding to gene-information to be
     * viewed such as color, shape, etc
     * @param pgcdata vector containing data corresponding to upstream region of gene-information to be
     * viewed such as color, shape, etc
     * @param pogcdata vector containing data corresponding to downstream region of gene-information to be
     * viewed such as color, shape, etc
     * @param Tname Table Name whose data is being viewed
     */
     public ZoomGenes(int currentCell, int total, int[] direcs, Vector cdata, Vector pgcdata, Vector pogcdata, String Tname, int gridFlag) {
        Table_Name=Tname; 
        Color_Data = new Vector(cdata.size());
        Color_Data=cdata;
        
        PreGColor_Data = new Vector(pgcdata.size());
        PreGColor_Data = pgcdata;
        
        PostGColor_Data = new Vector(pogcdata.size());
        PostGColor_Data = pogcdata;
        
        
        current = currentCell;
        current--;
        totalGenes = total;
        totalGenes--;
        directionCells = new int[totalGenes];
        directionCells=direcs;
        
        if(current + 105  >= totalGenes)
            toGene = totalGenes;
        else 
            toGene = current + 105;
        if(current - 105 <= 0)
            fromGene = 0;
        else
            fromGene = current - 105;
         if(toGene-fromGene >= 10)
        {
            col=10;
            row=(toGene-fromGene)/col;
        }
        else
        {
            col=toGene-fromGene;
            row=1;
        }
        
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
              
        this.setSize(new Dimension(d.width/2, d.height/2));
        currentWidth = d.width/2;
        currentHeight = d.height/2;
        this.setVisible(true);
        this.setBackground(Color.white);
        widthOfCell = currentWidth/col;
        heightOfCell = currentHeight/row;
        gridF = gridFlag;
        //System.out.println("Inside the constructor of ZoomGenes " + toGene + "fromGene is " + fromGene + "\ncol is " + col + "rows is " + row + "current " +current + "width oF Cell is "+widthOfCell + "ht of cell " + heightOfCell);
    }
    

     /**
      * paints the Zoom Region
      * @param g Graphics Context
      */     
    public void paintComponent(Graphics g)
    {
        super.paintComponent(g);        
        int ht = this.getHeight();
        int width = this.getWidth();
        boolean flag=false, widthFlag=false, htFlag=false;
        // if the extended size is bigger than previous, increase the amount viewed on screen
        if((width>currentWidth)&&(ht >currentHeight)) {
            if(fromGene-45>=0)
           fromGene = fromGene-45;
        else
            fromGene=0;              
        if(toGene+45 <= totalGenes)
            toGene = toGene + 45;
        else
            toGene = totalGenes;
            flag=true;
        }
        // if size of window has shrunk, decrease the number of genes displayed
        else if((width < currentWidth)&&(ht < currentHeight))
        {
            if(fromGene+45<=totalGenes)
                fromGene=fromGene+45;
            else
                fromGene=totalGenes;
            if(toGene-45>=0)
                toGene=toGene-45;
            else
                toGene=0;
            flag=true;
        }
        // if width has changed, just recompute size of cells, not number of cells to be displayed
        else if ((width > currentWidth)||(width < currentWidth))
        {
            widthFlag=true;
        }
        // if height has increased or decreased, recompute height of cells, not number of cells to be displayed
        else if((ht > currentHeight)||(ht < currentHeight))
        {
            htFlag=true;
        }       
        // if size has become bigger or smaller 
        if(flag) {
        /// then recompute number of col and rows
        if(toGene-fromGene >= 10)
        {
            col=10;
            row=(toGene-fromGene)/col;
        }
        else
        {
            col=toGene-fromGene;
            row=1;
        }
        // recompute width of cell
        widthOfCell = width/col;
        // return compute height of cell
        heightOfCell = ht/row;
        currentWidth=width;
        currentHeight=ht;
        }
        // if width has changed, recompute the width
        if(widthFlag)
        {
            widthOfCell = width/col;
            currentWidth=width;
        }
        // if height has changed, recompute the height
        if(htFlag)
        {
            heightOfCell = ht/row;
            currentHeight = ht;
        }
        //System.out.println(" fromGene is "+ fromGene + " toGene is "+toGene + " current is " + current);
        DrawNum(g);
        DrawRect(g); 
        ColorRect(g);        
    }
    
    private void ColorRect(Graphics g)
    {
        Enumeration enumVar = Color_Data.elements();
          int temp=0;
	  while (enumVar.hasMoreElements())
	  {
	   	 Vector Data=(Vector)enumVar.nextElement();
	   	 Enumeration enum_Data = Data.elements();
	   	 int i=0;
	   	 while(enum_Data.hasMoreElements())
	        {        C_Data[i]=enum_Data.nextElement();
			 i++;
		}
        try
            {
	        String Column_Name=C_Data[0].toString();
		 Object value2=C_Data[1];
		 Color color=(Color)C_Data[3];
                 Icon shape=(Icon)C_Data[4];

		 String shapeString=shape.toString();
		 String s=shapeString.substring(0, 6);

		 if(color!=Color.white || !s.equals("blank.")){                   
			 if(value2=="NullEntry")
                         {query = "select ID, ["+Column_Name+"] from ["+Table_Name+"] where ["+Column_Name+"] is null";
			 }
		 else {
				 String string=new String();
                                 if(value2==null) {
                            value2="null";
                            query = "select ID, ["+Column_Name+"] from ["+Table_Name+"] where ["+Column_Name+"] is NULL";
                        } else
				 if(value2.getClass()==string.getClass())
				 {
					query = "select ID, ["+Column_Name+"] from ["+Table_Name+"] where ["+Column_Name+"]="+"'"+value2+"'";
				 }
				 else
				 {
					 query = "select ID, ["+Column_Name+"] from ["+Table_Name+"] where ["+Column_Name+"]="+value2;
				 }
			 }
			DatabaseConnection connection=DatabaseConnection.getInstance();
			con=connection.getConnection();
			//get all the IDs that match with Column_Name and values
			 Statement stmt = con.createStatement();
        		 rs = stmt.executeQuery(query);
			 while (rs.next())
			 {
				int proteinNum=rs.getInt(1);
                         if(((proteinNum-1)>=fromGene) && ((proteinNum-1)<=toGene))
                         {
                        	DrawColor(proteinNum,color,g, 0);          
				//draw shape on each gene
				DrawShape(proteinNum, s, g,0);
                         }
                       }
			 stmt.close();
			 }
	  }
		  catch (SQLException ex)
		  {
			  System.out.println ("10"+ex);
		  }
	   }
          //**************************************************************** 
          //draw pre-gene information
          Enumeration enumpregene = PreGColor_Data.elements();
          int pregenetemp=0;
	  while (enumpregene.hasMoreElements())
	  {  	 Vector pregeneData=(Vector)enumpregene.nextElement();
	   	 Enumeration enum_Datapregene = pregeneData.elements();
	   	 int i=0;
	   	 while(enum_Datapregene.hasMoreElements())
	        { pregeneC_Data[i]=enum_Datapregene.nextElement();
		 i++;}

	   // get connection with database
	  try
          {
		  //get the Column_Name and value that use want to display
		 String pregeneColumn_Name=pregeneC_Data[0].toString();
		 Object pregenevalue2=pregeneC_Data[1];
		 Color pregenecolor=(Color)pregeneC_Data[3];
                 Icon pregeneshape=(Icon)pregeneC_Data[4];
		 //get the shapes' name
		 String pregeneshapeString=pregeneshape.toString();
		 String pregenes=pregeneshapeString.substring(0, 6);
		 if(pregenecolor!=Color.white || !pregenes.equals("blank.")){
                    
			 if(pregenevalue2=="NullEntry")
                         {
				 query = "select ID, ["+pregeneColumn_Name+"] from ["+Table_Name+"] where ["+pregeneColumn_Name+"] is null";
			 }
			 else {
                             String pregenestring=new String();
                             if(pregenevalue2==null) {
                            pregenevalue2="null";
                            query = "select ID, ["+pregeneColumn_Name+"] from ["+Table_Name+"] where ["+pregeneColumn_Name+"] is NULL";
                        } else
				 if(pregenevalue2.getClass()==pregenestring.getClass())
				 {         
                                     	query = "select ID, ["+pregeneColumn_Name+"] from ["+Table_Name+"] where ["+pregeneColumn_Name+"]="+"'"+pregenevalue2+"'"; }
				 else
				 {   
                                      query = "select ID, ["+pregeneColumn_Name+"] from ["+Table_Name+"] where ["+pregeneColumn_Name+"]="+pregenevalue2;}
                         }
			//get the database connection instance
			DatabaseConnection pregeneconnection=DatabaseConnection.getInstance();
			 con=pregeneconnection.getConnection();
			//get all the IDs that match with Column_Name and values
			 Statement pregenestmt = con.createStatement();
                         rs = pregenestmt.executeQuery(query);
			//iterate the ResultSet to draw the color and Shape for
        		//each gene
			 while (rs.next())
			 {int proteinNum=rs.getInt(1);
				//fill the color on each gene
                          if(((proteinNum-1)>=fromGene) && ((proteinNum-1)<=toGene))
                          {                             
                                DrawColor(proteinNum,pregenecolor,g, -1);
                                //Draw shape on each gene
			        DrawShape(proteinNum, pregenes, g, -1);
                          }
                          
                         }
			 pregenestmt.close();}
                  //rs.close();
                }
	  catch (SQLException ex)
	  {
	  System.out.println ("10"+ex);
	  }
   }
          Enumeration enumpostgene = PostGColor_Data.elements();
          int postgenetemp=0;
	  while (enumpostgene.hasMoreElements())
	  {  	 Vector postgeneData=(Vector)enumpostgene.nextElement();
	   	 Enumeration enum_Datapostgene = postgeneData.elements();
	   	 int i=0;
	   	 while(enum_Datapostgene.hasMoreElements())
	        { postgeneC_Data[i]=enum_Datapostgene.nextElement();
		 i++;}
	   // get connection with database
	  try
          {
		  //get the Column_Name and value that use want to display
		 String postgeneColumn_Name=postgeneC_Data[0].toString();
		 Object postgenevalue2=postgeneC_Data[1];
		 Color postgenecolor=(Color)postgeneC_Data[3];
                 Icon postgeneshape=(Icon)postgeneC_Data[4];
		 //get the shapes' name
		 String postgeneshapeString=postgeneshape.toString();
		 String postgenes=postgeneshapeString.substring(0, 6);
		 if(postgenecolor!=Color.white || !postgenes.equals("blank.")){
                     if(postgenevalue2=="NullEntry")
                         {
                             	 query = "select ID, ["+postgeneColumn_Name+"] from ["+Table_Name+"] where ["+postgeneColumn_Name+"] is null";
			 }
			 else {String postgenestring=new String();
                         if(postgenevalue2==null) {
                            postgenevalue2="null";
                            query = "select ID, ["+postgeneColumn_Name+"] from ["+Table_Name+"] where ["+postgeneColumn_Name+"] is NULL";
                        } else
                       		 if(postgenevalue2.getClass()==postgenestring.getClass())
				 {     
					query = "select ID, ["+postgeneColumn_Name+"] from ["+Table_Name+"] where ["+postgeneColumn_Name+"]="+"'"+postgenevalue2+"'"; 
                                 }
				 else
				 {
					 query = "select ID, ["+postgeneColumn_Name+"] from ["+Table_Name+"] where ["+postgeneColumn_Name+"]="+postgenevalue2;
                                 }
                                 }
			//get the database connection instance
			DatabaseConnection postgeneconnection=DatabaseConnection.getInstance();
			 con=postgeneconnection.getConnection();
			//get all the IDs that match with Column_Name and values
			 Statement postgenestmt = con.createStatement();
                         rs = postgenestmt.executeQuery(query);
			//iterate the ResultSet to draw the color and Shape for
        		//each gene
			 while (rs.next())
			 {int proteinNum=rs.getInt(1);
                          if(((proteinNum-1)>=fromGene) && ((proteinNum-1)<=toGene)){
				 DrawColor(proteinNum,postgenecolor,g, 1);                                 
				//draw shape on each gene
			        DrawShape(proteinNum, postgenes, g, 1);
                          }
                         }
			 postgenestmt.close();}
                    }
	  catch (SQLException ex)
	  {
	  System.out.println ("10"+ex);
	  }
      }
    }
    //fill the color of the rectangle
    /**
     * colors the rectangles in appropriate color
     * @param proteinNum number corresponding to gene to be displayed
     * @param Draw_Color Color to be used for displaying gene
     * @param g Graphics context
     * @param flag determines whether upstream, gene or downstream region is to be displayed.
     * Flag=-1 means upstream region
     * Flag=0 means gene region
     * Flag=1 means downstream region
     */    
   public void DrawColor(int proteinNum, Color Draw_Color, Graphics g, int flag)
   {
                 g.setColor(Draw_Color);
                 g.setXORMode(Color.white);                
  	//set the mode of draw in order to make the color overlap
                if(gridF==1) {
                 if(flag==0){
                 int fromloc=0, toLoc=0;
                 fromloc = ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10)+(3*displayOffX)+1+((widthOfCell*9/10)*2/10)+1;
                 toLoc = ((proteinNum-1-fromGene)/col)*(heightOfCell*8/10)+(2*displayOffY)+1+1;
	  	// fill the rectangles in a small size(not fully filled)
	  	// will make it visually nicer
                g.fillRect(fromloc, toLoc, ((widthOfCell*9/10)*6/10)-1, (heightOfCell*8/10)-1);              
                }
                else if (flag==-1)
                {                                      
                    int fromloc=0, toLoc=0;
                    fromloc = (((proteinNum-1-fromGene))%col)*(widthOfCell*9/10)+(3*displayOffX)+1+1;
                    toLoc = (((proteinNum-1-fromGene))/col)*(heightOfCell*8/10)+(2*displayOffY)+1+1;          
                    g.fillRect(fromloc, toLoc, ((widthOfCell*9/10)*2/10)-1, (heightOfCell*8/10)-1);              
                }
                else if (flag==1)
                {
                    int fromloc=0, toLoc=0;
                    fromloc = (((proteinNum-1-fromGene))%col)*(widthOfCell*9/10)+(3*displayOffX)+1+((widthOfCell*9/10)*8/10)+1;
                    toLoc = (((proteinNum-1-fromGene))/col)*(heightOfCell*8/10)+(2*displayOffY)+1+1;
                   g.fillRect(fromloc, toLoc, ((widthOfCell*9/10)*2/10), (heightOfCell*8/10)-1);
                }
                } else if (gridF==0)
                {
                g.setColor(Draw_Color);
                g.setXORMode(Color.white);                
                int fromloc=0, toLoc=0;
                fromloc = ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10)+(3*displayOffX)+1;
                toLoc = ((proteinNum-1-fromGene)/col)*(heightOfCell*8/10)+(2*displayOffY)+1+1;
	  	// fill the rectangles in a small size(not fully filled)
	  	// will make it visually nicer
                g.fillRect(fromloc, toLoc, ((widthOfCell*9/10))-1, (heightOfCell*8/10)-1);              
                
                }
   }
    private void DrawNum(Graphics g)
    {
        g.setColor(Color.black);
       	//draw horizontal numbers
	 for(int i=fromGene, count=0; i<(fromGene+col); i++, count++)       
       	  {
	  	String num= i + "" ;
                int x = (3*displayOffX) + (widthOfCell*9/10 * count);
		int y=displayOffY;
		g.setFont(f);
		g.drawString(num, x, y);          
	  }
            
	  //draw vertical Numbers
          
           int counter=fromGene+col; 
           String num=counter+ "";
           int x=(int)(0.3*displayOffX);
           int y=(3*displayOffY);
           g.drawString(num, x, y);
                 
	  for(int i=1; i<row; i++)
          {
                num=counter+(i*col) + "";
                x=(int)(0.3*displayOffX);
	       if(i%2==0){
                y=(3*displayOffY)+((heightOfCell*8/10) *  i);
                g.drawString(num, x, y);
                 }
             
	  } 
    }
    //fill the shape in the rectangles
    /**
     * Draws shapes, if user has selected any, on the display
     * @param proteinNum number corresponding to specific gene to be displayed
     * @param shape Shape to be drawn for specific gene
     * @param g Graphics Context
     * @param flag determines whether upstream, gene or downstream region is to be displayed.
     * Flag=-1 means upstream region
     * Flag=0 means gene region
     * Flag=1 means downstream region
     */    
	public void DrawShape(int proteinNum, String shape, Graphics g, int flag)
	{
		//Draw the shape which is shorter than the rectangle
		//will make it look better
                // shape 1 is diagonal from right to left
                // shape 2 is diagonal from left to right
                // shape 3 is vertical line
                 // shape 4 is horizpntal line
                 int x1=0, x2=0, y1=0, y2=0;
		if(shape.equals("Shape1"))
		{
                       //System.out.println("Inside Shape 1");
                     if(gridF==1) {
			g.setColor(Color.BLACK);
			     if(flag==-1)
                            {
                                x2 = (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10);
                                x1 =(3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +((widthOfCell*9/10)*2/10);
                                y1 =(2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10));
                                y2 =(2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
                            }
                        // post gene information
                        else if(flag==1)
                        {
                            x1 =  (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +(widthOfCell*9/10);
                            x2 = (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +((widthOfCell*9/10)*8/10);
                            y1 =  (2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10));
                            y2 =   (2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;                            
                        }
                        // gene information
                        else if (flag==0)
                        {
                            // take x-coords from shape 4 and revert them (i.e. x2 in shape 3 becomes x1 and vice versae)
                            //  take y-coords from shape 3 and DO NOT revert them
                            x1 =  (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +((widthOfCell*9/10)*7/10);
                            x2 = (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +((widthOfCell*9/10)*2/10);
                            y1 =(2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10));
                            y2 =(2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
                        }
                        g.drawLine(x1,y1, x2, y2);
                     } else if (gridF==0) {
                         g.setColor(Color.BLACK);
                            x1 =  (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +((widthOfCell*9/10));
                            x2 = (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10);
                            y1 =(2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10));
                            y2 =(2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
                            g.drawLine(x1,y1, x2, y2);
                     }
		}

                else if(shape.equals("Shape2"))
		{
                     // goes frm right to left
                     // System.out.println("Inside Shape 2");
			g.setColor(Color.BLACK);
			//g.setPaintMode();
                       if(gridF==1) {
                        if(flag==-1)
                       {
                                x1 = (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10);
                                x2 =(3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +((widthOfCell*9/10)*2/10);
                                y1 =(2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10));
                                y2 =(2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
                       }
                        //g.drawLine(((proteinNum-1)%columns)*(widthOfCell*9/10)+(3*displayOffX), ((proteinNum-1)/columns)*(heightOfCell*8/10)+(2*displayOffY)+(heightOfCell*8/10),((proteinNum-1)%columns)*(widthOfCell*9/10)+(3*displayOffX)+((widthOfCell*9/10)*2/10)+2, ((proteinNum-1)/columns)*(heightOfCell*8/10)+(2*displayOffY));
                        // post gene information
                        else if(flag==1)
                        {
                            x2 =  (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +(widthOfCell*9/10);
                            x1 = (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +((widthOfCell*9/10)*8/10);
                            y1 =  (2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10));
                            y2 =   (2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;                            
                        }
                        //g.drawLine(((proteinNum-1)%columns)*(widthOfCell*9/10)+(3*displayOffX)+((widthOfCell*9/10)*8/10), ((proteinNum-1)/columns)*(heightOfCell*8/10)+(2*displayOffY)+(heightOfCell*8/10),((proteinNum-1)%columns)*(widthOfCell*9/10)+(3*displayOffX)+((widthOfCell*9/10)*8/10)+((widthOfCell*9/10)*2/10), ((proteinNum-1)/columns)*(heightOfCell*8/10)+(2*displayOffY));
                        else if(flag==0)
                        {
                            x2 =  (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +((widthOfCell*9/10)*7/10);
                            x1 = (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +((widthOfCell*9/10)*2/10);
                            y1 =(2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10));
                            y2 =(2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
                        }
                        g.drawLine(x1,y1,x2,y2);
                       } else if(gridF==0) {
                            g.setColor(Color.BLACK);
                            x2 =  (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +((widthOfCell*9/10));
                            x1 = (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10);
                            y1 =(2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10));
                            y2 =(2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
                       g.drawLine(x1,y1,x2,y2);
                       }
		}

                else if(shape.equals("Shape4"))
		{
                    //System.out.println("Inside Shape 4");
			g.setColor(Color.BLACK);
			g.setPaintMode();
                        if(gridF==1) {
			if(flag==-1)
                        {
                            x1 = (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10);
                            x2 =  (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +((widthOfCell*9/10)*2/10);
                            y1 = (2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10))+((heightOfCell*8/10)*5/10);
                            y2 = y1;
                        }
                        // post gene information
                        else if(flag==1)
                        {
                            x1 = (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +((widthOfCell*9/10)*8/10);
                            x2 =  (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +(widthOfCell*9/10);
                            y1 = (2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10))+((heightOfCell*8/10)*5/10);
                            y2 = y1;
                        }                           
                        else if(flag==0)
                        {
                            x1 = (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +((widthOfCell*9/10)*2/10);
                            x2 =  (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +((widthOfCell*9/10)*7/10);
                            y1 = (2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10))+((heightOfCell*8/10)*5/10);
                            y2 = y1;
                        }
                        g.drawLine(x1,y1,x2,y2);
                        }else if (gridF==0) {
                            x1 = (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10);
                            x2 =  (3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +((widthOfCell*9/10));
                            y1 = (2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10))+((heightOfCell*8/10)*5/10);
                            y2 = y1;
                            g.setColor(Color.BLACK);
                            g.drawLine(x1,y1,x2,y2);
                        }
		}

                else if(shape.equals("Shape3"))
		{
                    //System.out.println("Inside Shape 3");
			g.setColor(Color.BLACK);
			g.setPaintMode();
                        // pre gene information
			if(gridF==1) {
                        if(flag==-1)
                        {
                    x1 =(3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +((widthOfCell*9/10)*15/100);
                    x2=x1;
                    y1 =  (2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10));
                    y2 =   (2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
                        }                      
                        // post gene information
                        else if(flag==1)
                        {
                    x1 =(3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +((widthOfCell*9/10)*85/100);
                    x2=x1;
                    y1 =  (2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10));
                    y2 =   (2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
                        }                        
                        else if (flag==0)
                        {
                    x1 =(3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) +((widthOfCell*9/10)*5/10);
                    x2=x1;
                    y1 =(2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10));
                    y2 =(2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
                        }
                        g.drawLine(x1, y1, x2, y2);
                        }else if(gridF==0) {
                    g.setColor(Color.BLACK);
                            x1 =(3*displayOffX)+1 + ((proteinNum-1-fromGene)%col)*(widthOfCell*9/10) ;
                    x2=x1;
                    y1 =(2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10));
                    y2 =(2*displayOffY)+1+(((proteinNum-1-fromGene)/col)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
                            g.drawLine(x1, y1, x2, y2);
                        }
		}

	}
 
        
    private void DrawRect(Graphics g)
    {
         
          int i, j, k;
          int proteinCounter=fromGene;
          //System.out.println("fromGene " + fromGene + "toGene "+toGene);
	   for(i=0; i<row; i++)
	  {
	  	for(j=0; j<col;j++, proteinCounter++)
                {
		g.setColor(Color.black);
                if(gridF==1)
                g.drawRect((3*displayOffX)+1 + j*(widthOfCell*9/10), (2*displayOffY)+1+(i*(heightOfCell*8/10)),(widthOfCell*9/10)*2/10,heightOfCell*8/10);
                if(gridF==0)
                    g.drawRect((3*displayOffX)+1 + j*(widthOfCell*9/10), (2*displayOffY)+1+(i*(heightOfCell*8/10)),(widthOfCell*9/10),heightOfCell*8/10);
                if(proteinCounter==current)
                {
                    g.drawRect((3*displayOffX)+1 + j*(widthOfCell*9/10) +((widthOfCell*9/10)*4/10), (2*displayOffY)+1+(i*(heightOfCell*8/10))+(heightOfCell*2/10),(widthOfCell*9/10)*3/10,(heightOfCell*8/10)*4/10);
                     g.fillRect((3*displayOffX)+1 + j*(widthOfCell*9/10) +((widthOfCell*9/10)*4/10), (2*displayOffY)+1+(i*(heightOfCell*8/10))+(heightOfCell*2/10),(widthOfCell*9/10)*3/10,(heightOfCell*8/10)*4/10);

                }
                if(gridF==1)
                g.drawRect((3*displayOffX)+1 + j*(widthOfCell*9/10) +((widthOfCell*9/10)*2/10), (2*displayOffY)+1+(i*(heightOfCell*8/10)),(widthOfCell*9/10)*6/10,heightOfCell*8/10);

                if((proteinCounter<=toGene)&&(directionCells[proteinCounter]==1)) // forward strand
                {
                                     
                    int x1 =(3*displayOffX)+1 + j*(widthOfCell*9/10) +((widthOfCell*9/10)*5/10);
                    int x2=x1;
                    int y1 =  (2*displayOffY)+1+(i*(heightOfCell*8/10))+(heightOfCell*8/10)*3/10;
                    int y2 =   (2*displayOffY)+1+(i*(heightOfCell*8/10))+(heightOfCell*8/10)*8/10;
                    g.drawLine(x1, y1, x2, y2);
                    // draws horizontal line
                    int x11 = (3*displayOffX)+1 + j*(widthOfCell*9/10) +((widthOfCell*9/10)*4/10);
                    int x12 =  (3*displayOffX)+1 + j*(widthOfCell*9/10) +((widthOfCell*9/10)*3/10)+ (widthOfCell*9/10)*3/10;
                    int y11 = (2*displayOffY)+1+(i*(heightOfCell*8/10))+((heightOfCell*8/10)*5/10);
                    int y12 = y11;
                    g.drawLine(x11,y11, x12, y12);
                }
                if(proteinCounter <= toGene) 
                    if(gridF==1)
                 g.drawRect((3*displayOffX)+1 + j*(widthOfCell*9/10) + ((widthOfCell*9/10)*8/10), (2*displayOffY)+1+(i*(heightOfCell*8/10)),((widthOfCell*9/10)*2/10),heightOfCell*8/10);
                }
	  } 
           //System.out.println("Before drawing remaining...the value is "+ proteinCounter);
	//get the rest of rectangle that are not enough for col genes
	  int left=(toGene-fromGene+1)%col;
         //System.out.println(" Left's value is " + left);
         for(k=0; k<left; k++)
	  {
              if(proteinCounter==current)
                {
                   // System.out.println("I m inside this...");
                    g.drawRect((3*displayOffX)+1 + k*(widthOfCell*9/10) +((widthOfCell*9/10)*4/10), (2*displayOffY)+1+(row*(heightOfCell*8/10))+(heightOfCell*2/10),(widthOfCell*9/10)*3/10,(heightOfCell*8/10)*4/10);
                    g.setColor(Color.black);
                    g.fillRect((3*displayOffX)+1 + k*(widthOfCell*9/10) +((widthOfCell*9/10)*4/10), (2*displayOffY)+1+(row*(heightOfCell*8/10))+(heightOfCell*2/10),(widthOfCell*9/10)*3/10,(heightOfCell*8/10)*4/10);
                }
              if(gridF==0)
                  g.drawRect((3*displayOffX)+1 + k*(widthOfCell*9/10), (2*displayOffY)+1+(row*(heightOfCell*8/10)),(widthOfCell*9/10),heightOfCell*8/10);
              if(gridF==1) {
             g.drawRect((3*displayOffX)+1 + k*(widthOfCell*9/10), (2*displayOffY)+1+(row*(heightOfCell*8/10)),(widthOfCell*9/10)*2/10,heightOfCell*8/10);
             g.drawRect((3*displayOffX)+1 + k*(widthOfCell*9/10) +((widthOfCell*9/10)*2/10), (2*displayOffY)+1+(row*(heightOfCell*8/10)),(widthOfCell*9/10)*6/10,heightOfCell*8/10);
              }   
             if(directionCells[proteinCounter]==1) // forward strand
                {
                    int x1 =(3*displayOffX)+1 + k*(widthOfCell*9/10) +((widthOfCell*9/10)*5/10);
                    int x2=x1;
                    int y1 =  (2*displayOffY)+1+(row*(heightOfCell*8/10))+(heightOfCell*8/10)*3/10;
                    int y2 =   (2*displayOffY)+1+(row*(heightOfCell*8/10))+(heightOfCell*8/10)*8/10;
                    g.drawLine(x1, y1, x2, y2);
                    // draws horizontal line
                    int x11 = (3*displayOffX)+1 + k*(widthOfCell*9/10) +((widthOfCell*9/10)*4/10);
                    int x12 =  (3*displayOffX)+1 + k*(widthOfCell*9/10) +((widthOfCell*9/10)*3/10)+ (widthOfCell*9/10)*3/10;
                    int y11 = (2*displayOffY)+1+(row*(heightOfCell*8/10))+((heightOfCell*8/10)*5/10);
                    int y12 = y11;
                    g.drawLine(x11,y11, x12, y12);
                }
                if(gridF==1)
                g.drawRect((3*displayOffX)+1 + k*(widthOfCell*9/10) + ((widthOfCell*9/10)*8/10), (2*displayOffY)+1+(row*(heightOfCell*8/10)),((widthOfCell*9/10)*2/10),heightOfCell*8/10);
              proteinCounter++;
          } 
          //System.out.println("proteinCounter now is "+ proteinCounter);
    }
    
    /**
     * sets font for display
     * @param g Graphics Context
     */    
    public void setFonts(Graphics g)
   {
	  if (f != null) return;
      f = new Font("SansSerif", Font.BOLD, 2);
      fi = new Font("SansSerif",
         Font.BOLD + Font.ITALIC, 6);
      fm = g.getFontMetrics(f);
      fim = g.getFontMetrics(fi);
   }
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {
       // System.exit(0);
    }
    
  
    // Variables declaration - do not modify
    // End of variables declaration
    
 private int current, totalGenes, toGene=0, fromGene=0;
 private int row, col;
 private int widthOfCell, heightOfCell;
 private int displayOffX=10, displayOffY=10;
 private JPanel jpanel;
 private int currentWidth, currentHeight;
 private Font f,fi;
 private FontMetrics fm, fim;
 private int[] directionCells;
 private Vector Color_Data, PreGColor_Data, PostGColor_Data;
 private String Table_Name, query;
 private Object[] C_Data=new Object[5];
 private Object[] pregeneC_Data = new Object[5];
 private Object[] postgeneC_Data = new Object[5];
 private ResultSet rs;
 private Connection con;  
 private static int countertest=1;
  public static final long serialVersionUID = 24362462L;
  private int gridF;
}
