

//~--- JDK imports ------------------------------------------------------------

/* This is class who draws the background and welcome symbol
        of the DisplayPanel
*/
import java.awt.*;
import java.awt.event.*;

import java.io.*;

import java.lang.*;

import java.net.*;

import java.sql.*;

import java.util.*;

import javax.swing.*;

//~--- classes ----------------------------------------------------------------

/**
 * class which displays background image
 * @author Yue Lu, Lalitha Viswanath
 * @version 1.2
 * @design Dr.George Fox, Yue Lu, Lalitha Viswanath
 */
public class background extends JPanel {
    public static final long serialVersionUID = 24362462L;

    //~--- methods ------------------------------------------------------------

    // paintComponent to paint the Image as the JPanel's background

    /**
     * method wich
     * @param g
     */
    public void paintComponent(final Graphics g) {
        super.paintComponent(g);

        Image back = Toolkit.getDefaultToolkit().getImage("dna3.jpg");
        // get the size of the JPanel
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

        // repeatly paint the image till it fill the whole JPanel
        for (int x = 0; x < screenSize.width; x += back.getWidth(this)) {
            for (int y = 0; y < screenSize.height; y += back.getHeight(this)) {
                g.drawImage(back, x, y, this);
            }
        }

        // draw the string for the message on the JPanel
        g.setFont(new Font("Serif", Font.BOLD | Font.ITALIC, 24));
        g.setColor(new Color(145, 145, 255));
        g.drawString("        Genome Display Tool", screenSize.width / 3,
                     screenSize.height / 4);
        g.setFont(new Font("Serif", Font.BOLD, 14));
        g.drawString("Author:            Yue Lu, Lalitha Viswanath",
                     screenSize.width / 3 + 50, screenSize.height / 4 + 50);
        g.drawString(
            "System Design: Dr.George E. Fox,  Yue Lu, Lalitha Viswanath",
            screenSize.width / 3 + 50, screenSize.height / 4 + 70);
        g.drawString("Version:            1.2", screenSize.width / 3 + 50,
                     screenSize.height / 4 + 90);
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
