Attribute VB_Name = "Module1"
Type Codon_data
 co As String * 3
 AA As String * 1
 use As Double
End Type

' Run code to make minimum calculation possible
Public a, b, c As Integer
' Codon database array
Public cd(1 To 65) As Codon_data
Public e As Integer
Public DNA_seq As String
Public AA_seq As String
Public DNA_num As Integer
Public Res_num As Integer
Public OriginalDNA As String * 3
Public OriginalAA As String * 1
Public Codon_chosen As String * 3
Public mismat As Integer
Public Mut_aa As String * 1
Public Force_codon As String * 3
Public Tmopt, Tmmax, Tmmin, Tmscore As Double
Public Lenopt, Lenmax, Lenmin, Lenscore As Double
Public GCopt, GCmax, GCmin, GCscore As Double
Public FFopt, FFmax, FFmin, FFscore As Double
Public RFopt, RFmax, RFmin, RFscore As Double
Public GCEndValue As Integer
Public Endscore As Double
Public TmCri, LenCri, GCCri, FFCri, RFCri, EndCri As Integer
Public Sub RunProgram()
 
 GetUserInput
    
' Don't start if you got error in user input
 If (e = 0) Then
  If (b = 1) Or (c = 1) Then
   DisplaySeq
   Choosecodon
  End If
  Form1.PrimerBox.Text = ""
  DesignMin
  DesignScore
 End If
 a = 0
 b = 0
 c = 0
End Sub
Public Sub ReadCodonDatabase()
 Dim tempdata As String
 Dim i As Integer
 
 i = 0
 
 Open "codon.dat" For Input As #1
 While Not (EOF(1))
  i = i + 1
  Input #1, tempdata
  With cd(i)
   .co = Mid(tempdata, 1, 3)
   .AA = Mid(tempdata, 5, 1)
   .use = String_to_double(Mid(tempdata, 12, 4)) / 10
  End With
 Wend
 Close #1
End Sub

Public Sub GetUserInput()
 
 Dim tempchar As String * 1
 Dim fcheck As Integer
 
 e = 0
 
 On Error GoTo Handler
  
 With Form1
   ' Read in all values from the lower right fields
  If (a = 1) Then
   Tmopt = CDbl(.Tm_opt.Text)
   Tmmax = CDbl(.Tm_max.Text)
   Tmmin = CDbl(.Tm_min.Text)
   Tmscore = CDbl(.Tm_score.Text)
   TmCri = .Tm_critical.value
   Lenopt = CDbl(.Length_opt.Text)
   Lenmax = CDbl(.Length_max.Text)
   Lenmin = CDbl(.Length_min.Text)
   Lenscore = CDbl(.Length_score.Text)
   LenCri = .Length_critical.value
   GCopt = CDbl(.GC_opt.Text)
   GCmax = CDbl(.GC_max.Text)
   GCmin = CDbl(.GC_min.Text)
   GCscore = CDbl(.GC_score.Text)
   GCCri = .GC_critical.value
   FFopt = CDbl(.FF_opt.Text)
   FFmax = CDbl(.FF_max.Text)
   FFmin = CDbl(.FF_min.Text)
   FFscore = CDbl(.FF_score.Text)
   FFCri = .FF_critical.value
   RFopt = CDbl(.RF_opt.Text)
   RFmax = CDbl(.RF_max.Text)
   RFmin = CDbl(.RF_min.Text)
   RFscore = CDbl(.RF_score.Text)
   RFCri = .RF_critical.value
   GCEndValue = .GCEnd.value
   Endscore = CDbl(.GCEnd_score.Text)
   EndCri = .GCEnd_critical.value
  End If
  ' Read in mutation infos
  If (b = 1) Then
   Mut_aa = UCase(.Mutaa.Text)
   Force_codon = UCase(.Forcecodon.Text)
   Res_num = .Resnum.Text
   DNA_num = Res_num * 3 - 2
  End If
  ' Get DNA seq
  If (c = 1) Then
   DNA_seq = FixDNASeq(.DNASeqBox.Text)
   AA_seq = Translate(DNA_seq)
  End If
 ' Check force codon is properly written using A T C G
  For i = 1 To 3
   tempchar = Mid(Force_codon, i, 1)
   If ((tempchar <> "A") And (tempchar <> "T") And (tempchar <> "C") And (tempchar <> "G")) Then fcheck = 1
  Next
 ' Check errors in user input to prevent from unnecessary starting
 If ((DNA_seq = "") Or (Res_num = 0) Or ((LTrim(Mut_aa) = "")) And (fcheck = 1)) Then e = 1
 ' Check user values are properly set
 If (Tmmax < Tmmin) Or (((Tmopt > Tmmax) Or (Tmopt < Tmmin)) And (Tmopt <> 0)) Then
   .Tmlabel.ForeColor = &HFF&
   e = 1
  Else
    .Tmlabel.ForeColor = &H80000012
  End If
 If (GCmax < GCmin) Or (((GCopt > GCmax) Or (GCopt < GCmin)) And (GCopt <> 0)) Then
   .GClabel.ForeColor = &HFF&
   e = 1
  Else
    .GClabel.ForeColor = &H80000012
  End If
 If (Lenmax < Lenmin) Or (((Lenopt > Lenmax) Or (Lenopt < Lenmin)) And (Lenopt <> 0)) Then
   .Lengthlabel.ForeColor = &HFF&
   e = 1
  Else
    .Lengthlabel.ForeColor = &H80000012
  End If
 If (FFmax < FFmin) Or (((FFopt > FFmax) Or (FFopt < FFmin)) And (FFopt <> 0)) Then
   .FFlabel.ForeColor = &HFF&
   e = 1
  Else
    .FFlabel.ForeColor = &H80000012
  End If
 If (RFmax < RFmin) Or (((RFopt > RFmax) Or (RFopt < RFmin)) And (RFopt <> 0)) Then
   .RFlabel.ForeColor = &HFF&
   e = 1
  Else
    .RFlabel.ForeColor = &H80000012
  End If
 
 
 End With
 GoTo Normal
 
 
Handler:
 e = 1
Normal:

End Sub
 Public Function Translate(seq As String) As String
  ' Translate DNA sequence inputted to amino acid sequence (output)
  ' using codon database provided
  Dim aaseq As String
  Dim cnum As Integer
  Dim codon As String * 3
  
  aaseq = ""
  For i = 1 To Len(seq) - 2 Step 3
   codon = Mid(seq, i, 3)
   For j = 1 To 65
    If (cd(j).co = codon) Then aaseq = aaseq + cd(j).AA
   Next
  Next
  Translate = aaseq
 End Function

Public Function FixDNASeq(seq As String) As String
 ' Fix DNA sequence inputted to remove FASTA heading and remove linefeed characters
 Dim fixed As String
 Dim header As Integer
 ' Temporary character holder
 Dim tc As String * 1
 
 fixed = ""
 header = 0
 For i = 1 To Len(seq)
  tc = Mid(seq, i, 1)
  tc = UCase(tc)
  If (tc = ">") Then header = 1
  If (header = 0) Then
   If ((tc = "A") Or (tc = "T") Or (tc = "C") Or (tc = "G")) Then fixed = fixed + tc
  End If
  If ((header = 1) And (tc = Chr(13))) Then header = 0
 Next

 FixDNASeq = fixed
End Function

Public Sub DisplaySeq()
  ' Display sequence in format form in the AASeqBox
  
  Dim format_aa As String
  Dim AABoxText As String
    Dim shape As String
  Dim i, j As Integer
  
  format_aa = ""
 
  ' Format amino acid sequence and mark the mutation site
  For i = 1 To Len(AA_seq)
   If ((i <> Res_num) And (i <> Res_num - 1)) Then
    format_aa = format_aa + Mid(AA_seq, i, 1) + "  "
   Else
    If (i = Res_num) Then
     shape = "<-"
    Else
     shape = "->"
    End If
    format_aa = format_aa + Mid(AA_seq, i, 1) + shape
   End If
  Next
  
  ' Print the DNA and formatted amino acid sequence into AASeqBox
  i = 1
  AABoxText = ""
  While (i < Len(AA_seq))
    ' Format left margin
    For j = 1 To (4 - Int(Log(i * 3 - 2) / Log(10)))
     AABoxText = AABoxText + " "
    Next
    AABoxText = AABoxText + LTrim(str(i * 3 - 2)) + " - " + Mid(DNA_seq, i * 3 - 2, 15) + " "
    ' Put 4, 15 DNA sequence in the line
    For j = 1 To 3
     AABoxText = AABoxText + Mid(DNA_seq, (i * 3 - 2 + j * 15), 15) + " "
    Next
    ' Finish the DNA output line with mark, number, and linefeed
    AABoxText = AABoxText + "- " + LTrim(str(i * 3 + 57)) + Chr(13) + Chr(10)
    
    ' Put the formatted amino acid sequence on the next line using same method
    ' Format left margin
    For j = 1 To (4 - Int(Log(i) / Log(10)))
     AABoxText = AABoxText + " "
    Next
    ' Put heading number, margin mark, and first 15 DNA sequence in the line
    AABoxText = AABoxText + LTrim(str(i)) + " - " + Mid(format_aa, i * 3 - 2, 15) + " "
    ' Put 3 other 15 DNA sequence in the line
    For j = 1 To 3
     AABoxText = AABoxText + Mid(format_aa, (i * 3 - 2 + j * 15), 15) + " "
    Next
    ' Finish the DNA output line with mark, number, and linefeed
    AABoxText = AABoxText + "- " + LTrim(str(i + 19)) + Chr(13) + Chr(10)
    
    ' Add a space between
    AABoxText = AABoxText + Chr(13) + Chr(10)
    
    i = i + 20
   Wend
   Form1.AASeqBox.Text = AABoxText

   ' Display mutation site information
   Form1.Mutation_info.Caption = "Mutation site : " + Mid(AA_seq, Res_num, 1) + " " + LTrim(str(Res_num)) + " (" + Mid(DNA_seq, DNA_num, 3) + " " + LTrim(str(DNA_num)) + ")"
End Sub
Public Sub Choosecodon()
  '  Scan through codon database to find the available codons
  Dim codon_found As Integer
  Dim codon_match(1 To 20) As Integer
  Dim mismatches(1 To 20) As Integer
  Dim i, j, lowest_mismatch As Integer
  Dim aacode As String * 1
  Dim highest_usage As Double
  
  codon_found = 0
 
  For i = 1 To 65
   If (cd(i).AA = Mut_aa) Then
    codon_found = codon_found + 1
    codon_match(codon_found) = i
   End If
  Next
  
 '  Match the codon and try to find the mismatch number, start, and end
 Form1.CodonBoxAA.Caption = Mut_aa + " :"
 Form1.CodonBox.Text = ""
  For i = 1 To codon_found
  mismatches(i) = 0
  For j = 0 To 2
   If (Mid(DNA_seq, DNA_num + j, 1) <> Mid(cd(codon_match(i)).co, j + 1, 1)) Then mismatches(i) = mismatches(i) + 1
  Next
  Form1.CodonBox.Text = Form1.CodonBox.Text + cd(codon_match(i)).co + " (" + LTrim(str(mismatches(i))) + " mismatches) " + LTrim(str(cd(codon_match(i)).use)) + "%" + Chr(13) + Chr(10)
 Next
 
' If force codon is not activated
If (Force_codon = "   ") Then
 ' Choose the codon based on minimum number of mismatches
 lowest_mismatch = 4
 highest_usage = 0
 For i = 1 To codon_found
  If (mismatches(i) < lowest_mismatch) Then
   lowest_mismatch = mismatches(i)
   Codon_chosen = cd(codon_match(i)).co
   mismat = lowest_mismatch
   highest_usage = cd(codon_match(i)).use
  End If
  ' If mismatches are same than higher codon usage wins
  If ((mismatches(i) = lowest_mismatch) And (cd(codon_match(i)).use > highest_usage)) Then
   lowest_mismatch = mismatches(i)
   Codon_chosen = cd(codon_match(i)).co
   mismat = lowest_mismatch
   highest_usage = cd(codon_match(i)).use
  End If
 Next

 ' Display information about codon chosen
 Form1.Codon_info.Caption = "Codon chosen : " + Codon_chosen + " (" + LTrim(str(mismat)) + " mismatches)"
Else
 'If activated override
 mismat = 0
 For j = 0 To 2
  If (Mid(DNA_seq, DNA_num + j, 1) <> Mid(Force_codon, j + 1, 1)) Then mismat = mismat + 1
 Next
 Codon_chosen = Force_codon
 For i = 1 To 65
  If (cd(i).co = Force_codon) Then aacode = cd(i).AA
 Next
 Form1.Codon_info.Caption = "Forced : " + Codon_chosen + "  " + aacode + "  (" + LTrim(str(mismat)) + " mismatches)"
End If
End Sub


Public Sub DesignMin()
 ' Makes primer to satisfy minimum or optimum tm starting from 7 nucleotides
 ' and extending both side on same time
  Dim extr, opt, short As Integer
  Dim primer As String
  Dim cond As Double
  Dim output As String
  
  If Tmopt = 0 Then
   cond = Tmmin
   opt = 0
  Else
   cond = Tmopt
   opt = 1
  End If
  extr = 1
  short = 0
  primer = Codon_chosen
  Do
   extr = extr + 1
   If (((DNA_num - extr) <= 0) Or ((DNA_num + extr + 1) >= Len(DNA_seq))) Then
    short = 1
   Else
    primer = design_primer(DNA_seq, Codon_chosen, Int(extr), Int(extr))
   End If
  Loop While ((calctm(primer, mismat) <= cond) And (short = 0))
  
  ' Make the output in proper format
  If (short = 0) Then
   output = "Primer satisfying "
   If opt = 1 Then
    output = output + "optimum "
   Else
    output = output + "minimum "
   End If
   output = output + "Tm" + Chr(13) + Chr(10)
   output = output + "----------------------------" + Chr(13) + Chr(10)
  Else
   output = "Not enough DNA sequence to make a primer satisfying Tm" + Chr(13) + Chr(10)
   output = output + "------------------------------------------------------" + Chr(13) + Chr(10)
   If (primer = Codon_chosen) Then
    extr = 0
   Else
    extr = extr - 1
   End If
  End If
  output = output + primeroutput(primer, mismat, Int(extr), Int(extr))
  Form1.PrimerBox.Text = Form1.PrimerBox.Text + output + Chr(13) + Chr(10)
End Sub

Public Sub DesignScore()
 '  Minimum length primer that satisfies most criterias as possible
 '  Scanning through variations that gives highest score
 Dim cur_sco, Totpt As Double
 Dim bscore(1 To 3) As Double
 Dim bprimer(1 To 3) As String
 Dim front, back, i, j, k, winner As Integer
 Dim front_back_diff(1 To 3) As Integer
 Dim FFl(1 To 3) As Integer
 Dim RFl(1 To 3) As Integer
 Dim primer As String
 Dim output As String

 For i = 1 To 3
  bscore(i) = 0
  bprimer(i) = ""
  front_back_diff(i) = 0
  FFl(i) = 0
  RFl(i) = 0
 Next
 
 For front = 0 To FFmax + 20
  If ((DNA_num - front) > 0) Then
   For back = 0 To RFmax + 20
    If (DNA_num + back + 1) < Len(DNA_seq) Then
     cur_sco = 0
     primer = design_primer(DNA_seq, Codon_chosen, Int(front), Int(back))
     cur_sco = cur_sco + sco(CDbl(Len(primer)), CDbl(Lenopt), CDbl(Lenmax), CDbl(Lenmin), CDbl(Lenscore))
     cur_sco = cur_sco + sco(calctm(primer, mismat), CDbl(Tmopt), CDbl(Tmmax), CDbl(Tmmin), CDbl(Tmscore))
     cur_sco = cur_sco + sco(GC_calc(primer), CDbl(GCopt), CDbl(GCmax), CDbl(GCmin), CDbl(GCscore))
     cur_sco = cur_sco + sco(CDbl(front), CDbl(FFopt), CDbl(FFmax), CDbl(FFmin), CDbl(FFscore))
     cur_sco = cur_sco + sco(CDbl(back), CDbl(RFopt), CDbl(RFmax), CDbl(RFmin), CDbl(RFscore))
     If (GCEndValue = 1) And (checkend(primer) = 1) Then cur_sco = cur_sco + Endscore
     ' Checking criticals
     If (LenCri = 1) And ((Len(primer) > Lenmax) Or (Len(primer) < Lenmin)) Then cur_sco = 0
     If (TmCri = 1) And (OK_or_BAD(CDbl(calctm(primer, mismat)), CDbl(Tmmax), CDbl(Tmmin)) = "(BAD)") Then cur_sco = 0
     If (GCCri = 1) And (OK_or_BAD(CDbl(GC_calc(primer)), CDbl(GCmax), CDbl(GCmin)) = "(BAD)") Then cur_sco = 0
     If (FFCri = 1) And (OK_or_BAD(CDbl(front), CDbl(FFmax), CDbl(FFmin)) = "(BAD)") Then cur_sco = 0
     If (RFCri = 1) And (OK_or_BAD(CDbl(back), CDbl(RFmax), CDbl(RFmin)) = "(BAD)") Then cur_sco = 0
     '    If (RFCri = 1) And ((back > RFmax) Or (back < RFmin)) Then cur_sco = 0
     ' Check score to pick highest
     winner = 0
     For j = 1 To 3
      If (((cur_sco > bscore(j)) Or ((cur_sco = bscore(j)) And (front_back_diff(j) > Abs(front - back))))) And (winner = 0) Then
       i = 4 - j
        While (i >= 2)
        front_back_diff(i) = front_back_diff(i - 1)
        bscore(i) = bscore(i - 1)
        bprimer(i) = bprimer(i - 1)
        FFl(i) = FFl(i - 1)
        RFl(i) = RFl(i - 1)
        i = i - 1
       Wend
       front_back_diff(j) = Abs(front - back)
       bscore(j) = cur_sco
       bprimer(j) = primer
       FFl(j) = front
       RFl(j) = back
       winner = 1
      End If
     Next
    Else
     back = RFmax + 21
    End If
   Next
  Else
   front = FFmax + 21
  End If
 Next

 ' Output three best primers
 Totpt = Lenscore + Tmscore + GCscore + FFscore + RFscore
 If (GCEndValue = 1) Then Totpt = Totpt + Endscore
 For i = 1 To 3
  If (bprimer(i) <> "") Then
   output = "Primer with "
   If i = 1 Then output = output + "most highest"
   If i = 2 Then output = output + "second highest"
   If i = 3 Then output = output + "third highest"
   output = output + " score (" + Twosig(bscore(i)) + " / " + Twosig(Totpt) + ")" + Chr(13) + Chr(10)
   k = Len(output)
   For j = 1 To k - 2
    output = output + "-"
   Next
   output = output + Chr(13) + Chr(10)
   output = output + primeroutput(bprimer(i), mismat, FFl(i), RFl(i)) + Chr(13) + Chr(10)
   Form1.PrimerBox.Text = Form1.PrimerBox.Text + output
  Else
   Form1.PrimerBox.Text = Form1.PrimerBox.Text + "No primer can be designed from the given criteria." + Chr(13) + Chr(10) + Chr(13) + Chr(10)
  End If
 Next
End Sub

Public Function sco(value As Double, opt As Double, max As Double, min As Double, pt As Double) As Double
 ' Calculates criteria score
 Dim pt_earned As Double
 
 pt_earned = 0
 If ((value >= min) And (value <= max)) Then
  If (opt <> 0) Then
   If (value > opt) Then pt_earned = (1 - (value - opt) / (max - opt)) * pt
   If (value < opt) Then pt_earned = (1 - (opt - value) / (opt - min)) * pt
   If (value = opt) Then pt_earned = pt
  Else
   pt_earned = pt
  End If
 End If
 
 sco = pt_earned
 
End Function

Public Function design_primer(templ As String, mutcod As String, frontl As Integer, behindl As Integer) As String
 ' Make primer given mutation code and front and behind length
  design_primer = Mid(templ, DNA_num - frontl, frontl) + mutcod + Mid(templ, DNA_num + 3, behindl)
End Function

Public Function GC_calc(seq As String) As Double
 ' Calculates the GC content of sequence
 
 Dim GC As Integer
 
 GC = 0
 For i = 1 To Len(seq)
  If ((Mid(seq, i, 1) = "G") Or (Mid(seq, i, 1) = "C")) Then GC = GC + 1
 Next

 GC_calc = GC / Len(seq) * 100
End Function

Public Function calctm(seq As String, mismatch As Integer) As Double
 calctm = 81.5 + (0.41 * GC_calc(seq)) - (675 / Len(seq)) - (mismatch / Len(seq) * 100)
End Function

Public Function primeroutput(primer As String, mismatch As Integer, FF As Integer, RF As Integer) As String
 ' Makes the formatted text for output of primer sequence and stats
 
 Dim output As String
 Dim Tm, GC, length As Double
 
 Tm = calctm(primer, mismatch)
 GC = GC_calc(primer)
 length = Len(primer)
 
 output = "Sequence : " + primer + Chr(13) + Chr(10)
 output = output + "Tm : " + Twosig(CDbl(Tm)) + " " + OK_or_BAD(CDbl(Tm), CDbl(Tmmax), CDbl(Tmmin))
 output = output + "   Length : " + LTrim(str(length)) + " " + OK_or_BAD(CDbl(length), CDbl(Lenmax), CDbl(Lenmin))
 output = output + "   % GC : " + LTrim(str(Int(GC))) + " " + OK_or_BAD(CDbl(GC), CDbl(GCmax), CDbl(GCmin)) + Chr(13) + Chr(10)
 output = output + "Front Len : " + LTrim(str(FF)) + " " + OK_or_BAD(CDbl(FF), CDbl(FFmax), CDbl(FFmin))
 output = output + "   Rear Len : " + LTrim(str(RF)) + " " + OK_or_BAD(CDbl(RF), CDbl(RFmax), CDbl(RFmin))
 output = output + "   GC End : "
 If (checkend(primer) = 1) Then
  output = output + "Yes"
 Else
  output = output + "No"
 End If
 primeroutput = output + Chr(13) + Chr(10)
End Function

Public Function checkend(primer As String) As Integer
 ' Check primer whether or not it ends in GC
 GCTrue = 0
 If ((Mid(primer, Len(primer), 1) = "G") Or (Mid(primer, Len(primer), 1) = "C")) Then GCTrue = 1
 checkend = GCTrue
End Function

Public Function OK_or_BAD(val, max, min As Double) As String
  If ((val <= max) And (val >= min)) Then
   OK_or_BAD = "(OK)"
  Else
   OK_or_BAD = "(BAD)"
  End If
 End Function


Public Function Twosig(num As Double) As String
 ' Give two significant figure number
 Dim intnum As Long
 Dim decpt As Integer
 Dim number As String
 
 number = num * 100
 intnum = Int(number)
 number = LTrim(str(intnum))
 decpt = Len(number) - 2
 
 If (decpt > 0) Then
  Twosig = Mid(number, 1, decpt) + "." + Mid(number, decpt + 1, 2)
 Else
  Twosig = LTrim(str(num))
 End If
End Function

Public Function String_to_double(str As String) As Double
 ' Converts double in string format to number double format
 Dim output As Double
 Dim i, j, decpt As Integer
 
 output = 0
 decpt = 0
 ' Converts the string into double
 For i = 1 To Len(str)
  For j = 1 To 9
   If Mid(str, i, 1) = Chr(j + 48) Then
    If decpt = 0 Then
     output = output * 10 + j
    Else
     output = output + (j / (10 ^ decpt))
     decpt = decpt + 1
    End If
   End If
   If Mid(str, i, 1) = "." Then decpt = 1
  Next
 Next
 
 String_to_double = output
End Function
