#! /usr/bin/perl

# Released under the terms of the BiO Licence.
# http://biolicence.org/

use strict;

#my $SCOP_VERSION	= "1.63";
#my $SCOP_VERSION	= "1.65";
#my $SCOP_VERSION	= "1.69";
my $SCOP_VERSION	= "1.71";
#my $DALI_VERSION	= "3.1beta";

my $DATA_DIR		= "./Data";

my $WGET_LOG		= "$DATA_DIR/$0.log";	

my %FILES = (
  "http://scop.mrc-lmb.cam.ac.uk/scop/parse" => [	
    "dir.des.scop.txt_$SCOP_VERSION",
  ],
#  "http://www.ebi.ac.uk/dali/domain/$DALI_VERSION" => [
#    "DaliDomainDefinitions",
#  ],
);

my $OPTIONS = 	
  " --tries=3".
  " --verbose".
  " --timestamping". 
  " --append-output=$WGET_LOG".
  " --directory-prefix=$DATA_DIR";

print "Logging to $WGET_LOG\n";

foreach my $url ( keys %FILES ) {
  foreach my $file ( @{$FILES{$url}} ) {
  
    print "Doing $url/$file -> $DATA_DIR\n";
    
    system("wget $OPTIONS $url/$file") && die "Killed by $?\n";
    
    
    # Check log file for updated download...
  
    open ( LOG, "<$WGET_LOG" );
  
    my $last_line = (<LOG>)[-2];

    print "$last_line\n";
  
    # NEED SOME PARSING!
  }
}

print "OK\n";

__END__

References

SCOP DATA
Lo Conte L, Brenner SE, Hubbard TJP, Chothia C, Murzin A. (2002).
SCOP database in 2002: refinements accommodate structural genomics.
Nucl. Acid Res. 30, 264-267
http://scop.mrc-lmb.cam.ac.uk/scop/ref/nar2002.pdf

DALI DATA
http://www.ebi.ac.uk/dali/

