/*
 * Decompiled with CFR 0.152.
 */
package DndScan;

import DndScan.DndScanApplet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.math.BigDecimal;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;

public class DndScan
extends JPanel {
    private JFrame frame = null;
    private DndScanApplet applet = null;
    private String path = null;
    private static final int XLEFT = 40;
    private static final int LINELENGTH = 400;
    private static final int WIDTHLINE = 1;
    Vector s = null;
    Vector ns = null;
    Vector pos = null;
    int windows = 0;
    BigDecimal max = new BigDecimal("0");
    int dotSize = 3;

    public DndScan(DndScanApplet applet, Vector pos, Vector s, Vector ns, BigDecimal max) {
        this(applet, null, pos, s, ns, max);
    }

    public DndScan(DndScanApplet applet, GraphicsConfiguration gc, Vector pos, Vector s, Vector ns, BigDecimal max) {
        this.applet = applet;
        this.pos = pos;
        this.s = s;
        this.ns = ns;
        this.windows = s.size();
        this.max = max;
        if (!this.isApplet()) {
            JFrame frame = new JFrame(gc);
            frame.getContentPane().add((Component)this, "Center");
            frame.setTitle("DnDscan");
            frame.setVisible(true);
            frame.setSize(500, 500);
            frame.setDefaultCloseOperation(3);
        }
    }

    public void paintComponent(Graphics g) {
        if (g == null) {
            return;
        }
        VectorGraphics vg = VectorGraphics.create(g);
        this.drawGraph(vg);
    }

    private void drawGraph(VectorGraphics vg) {
        int j;
        vg.setFont(new Font("Courier New", 1, 12));
        vg.drawLine(40, 440, 440, 440);
        vg.drawString("Position", 450, 450);
        for (j = 0; j < this.windows; j += 20) {
            int xxx = j * 400 / this.windows;
            String str = String.valueOf(this.pos.elementAt(j));
            vg.drawLine(40 + xxx, 440, 40 + xxx, 443);
            vg.drawString(str, 40 + xxx, 455);
        }
        vg.drawLine(40, 40, 40, 440);
        vg.setColor(Color.red);
        vg.drawString("S-rf1", 10, 30);
        vg.setColor(Color.black);
        vg.drawString("/", 45, 30);
        vg.setColor(Color.blue);
        vg.drawString("NS-rf1", 55, 30);
        vg.setColor(Color.black);
        for (j = 0; j < this.windows; j += 10) {
            int yyy = new BigDecimal(String.valueOf(j * 400)).divide(this.max, 1).intValue();
            vg.drawString(String.valueOf(j), 25, 440 - yyy);
        }
        int sx = -1;
        int sy = -1;
        int nsx = -1;
        int nsy = -1;
        for (int i = 0; i < this.windows; ++i) {
            int x = i * 400 / this.windows;
            int ys = 0;
            int yns = 0;
            BigDecimal sb = (BigDecimal)this.s.elementAt(i);
            sb = sb.multiply(new BigDecimal(String.valueOf(400)));
            sb = sb.divide(this.max, 1);
            BigDecimal nsb = (BigDecimal)this.ns.elementAt(i);
            nsb = nsb.multiply(new BigDecimal(String.valueOf(400)));
            nsb = nsb.divide(this.max, 1);
            ys = sb.intValue();
            yns = nsb.intValue();
            vg.setColor(Color.red);
            vg.fillRect(40 + x, 440 - ys - this.dotSize, this.dotSize, this.dotSize);
            if (sx != -1) {
                vg.drawLine(sx, sy, 40 + x, 440 - ys);
            }
            vg.setColor(Color.blue);
            vg.fillRect(40 + x, 440 - yns - this.dotSize, this.dotSize, this.dotSize);
            if (nsx != -1) {
                vg.drawLine(nsx, nsy, 40 + x, 440 - yns);
            }
            sx = 40 + x;
            sy = 440 - ys;
            nsx = 40 + x;
            nsy = 440 - yns;
        }
    }

    public static void main(String[] args) {
    }

    public boolean isApplet() {
        return this.applet != null;
    }
}

