/*
 * Decompiled with CFR 0.152.
 */
package DndScan;

import DndScan.DndScanApplet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.freehep.graphics2d.VectorGraphics;

public class Zipf
extends JPanel
implements MouseListener {
    private JFrame frame = null;
    private JPopupMenu pop = new JPopupMenu("Popup");
    JMenuItem item = new JMenuItem("Item");
    private DndScanApplet applet = null;
    private String path = null;
    private static final int XLEFT = 30;
    private static final int LINELENGTH = 400;
    private static final int WIDTHLINE = 1;
    Vector s = null;
    Vector ns = null;
    Vector classes = null;
    int windows = 0;
    BigDecimal max = new BigDecimal("0");
    int dotSize = 3;

    public Zipf(DndScanApplet applet, Vector classes, Vector s, Vector ns, BigDecimal max) {
        this(applet, null, classes, s, ns, max);
    }

    public Zipf(DndScanApplet applet, GraphicsConfiguration gc, Vector classes, Vector s, Vector ns, BigDecimal max) {
        this.applet = applet;
        this.s = s;
        this.ns = ns;
        this.classes = classes;
        this.windows = s.size();
        this.max = max;
        this.pop.add(this.item);
        this.addMouseListener(this);
        if (!this.isApplet()) {
            JFrame frame = new JFrame(gc);
            frame.getContentPane().add((Component)this, "Center");
            frame.setTitle("DnDscan Zipfs");
            frame.setVisible(true);
            frame.setSize(500, 500);
            frame.setDefaultCloseOperation(3);
        }
    }

    public void paintComponent(Graphics g) {
        if (g == null) {
            return;
        }
        VectorGraphics vg = VectorGraphics.create(g);
        this.drawGraph(vg);
    }

    private void drawGraph(VectorGraphics vg) {
        int xxx;
        int j;
        vg.setFont(new Font("Courier New", 1, 12));
        vg.drawLine(30, 430, 430, 430);
        for (j = 0; j < this.windows; j += 10) {
            xxx = j * 400 / this.windows;
            vg.drawString(String.valueOf(j), 30 + xxx, 440);
        }
        vg.drawLine(30, 30, 30, 430);
        for (j = 0; j < this.windows; j += 10) {
            xxx = new BigDecimal(String.valueOf(j * 400)).divide(this.max, 1).intValue();
            vg.drawString(String.valueOf(j), 15, 430 - xxx);
        }
        int sx = -1;
        int sy = -1;
        int nsx = -1;
        int nsy = -1;
        for (int i = 0; i < this.windows; ++i) {
            int x = 0;
            int ys = 0;
            int yns = 0;
            BigDecimal classesb = (BigDecimal)this.classes.elementAt(i);
            classesb = classesb.multiply(new BigDecimal(String.valueOf(400)));
            classesb = classesb.divide(this.max, 1);
            BigDecimal sb = (BigDecimal)this.s.elementAt(i);
            sb = sb.multiply(new BigDecimal(String.valueOf(400)));
            sb = sb.divide(this.max, 1);
            BigDecimal nsb = (BigDecimal)this.ns.elementAt(i);
            nsb = nsb.multiply(new BigDecimal(String.valueOf(400)));
            nsb = nsb.divide(this.max, 1);
            ys = sb.intValue();
            yns = nsb.intValue();
            x = classesb.intValue();
            vg.setColor(Color.red);
            vg.fillRect(30 + x, 430 - ys - this.dotSize, this.dotSize, this.dotSize);
            vg.drawString("Synonymous", 10, 10);
            if (sx != -1) {
                vg.drawLine(sx, sy, 30 + x, 430 - ys);
            }
            vg.setColor(Color.blue);
            vg.fillRect(30 + x, 430 - yns - this.dotSize, this.dotSize, this.dotSize);
            vg.drawString("Non-synonymous", 10, 20);
            if (nsx != -1) {
                vg.drawLine(nsx, nsy, 30 + x, 430 - yns);
            }
            sx = 30 + x;
            sy = 430 - ys;
            nsx = 30 + x;
            nsy = 430 - yns;
        }
    }

    public static void main(String[] args) {
    }

    public boolean isApplet() {
        return this.applet != null;
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.pop.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

