/*
 * Decompiled with CFR 0.152.
 */
package Patristic;

import Patristic.Matrix;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.DefaultTableModel;

public class FrameMatrix
extends JFrame {
    public JScrollPane scroll;
    private JTextPane textPane = new JTextPane();
    String[][] data;
    String[] columnNames;
    JTable table;
    int rowFrom;
    int rowTo;
    int columnFrom;
    int columnTo;
    Matrix localList;

    public FrameMatrix(Matrix list) {
        this.localList = list;
        this.setSize(600, 400);
        this.setResizable(true);
        this.setTitle("Patristic distances: " + list.getFileName() + " (SBL:" + list.getSBL() + ")");
        Container pane = this.getContentPane();
        this.columnNames = new String[list.getNames().length + 1];
        this.columnNames[0] = "";
        for (int i = 0; i < list.getNames().length; ++i) {
            this.columnNames[i + 1] = list.getNames()[i];
        }
        this.table = new JTable(list.toArray(), this.columnNames);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setModel(new DefaultTableModel(list.toArray(), this.columnNames));
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                FrameMatrix.this.tableMouseReleased(evt);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                FrameMatrix.this.tableMousePressed(evt);
            }
        });
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.setAutoResizeMode(0);
        this.scroll = new JScrollPane(this.table);
        pane.add((Component)this.scroll, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FrameMatrix.this.changeMatrix();
            }
        });
    }

    private void changeMatrix() {
        this.localList.setMatrix(this.toSimpleMatrix());
    }

    private void tableMousePressed(MouseEvent evt) {
        this.rowFrom = this.table.rowAtPoint(evt.getPoint());
    }

    private void tableMouseReleased(MouseEvent evt) {
        this.rowTo = this.table.rowAtPoint(evt.getPoint());
        this.columnTo = this.table.columnAtPoint(evt.getPoint());
        if (this.rowTo != this.rowFrom && this.rowTo > -1 && this.rowTo < this.table.getRowCount()) {
            ((DefaultTableModel)this.table.getModel()).moveRow(this.rowFrom, this.rowFrom, this.rowTo);
            this.table.moveColumn(this.rowFrom + 1, this.rowTo + 1);
            this.rowFrom = this.rowTo;
        }
    }

    private BigDecimal[][] toSimpleMatrix() {
        int j;
        BigDecimal[][] temp = new BigDecimal[this.columnNames.length - 1][this.columnNames.length - 1];
        BigDecimal[][] temp2 = new BigDecimal[this.columnNames.length - 1][this.columnNames.length - 1];
        String[] newOrderName = new String[this.columnNames.length - 1];
        String[] tempDate = new String[this.columnNames.length - 1];
        for (j = 0; j < this.columnNames.length - 1; ++j) {
            newOrderName[j] = ((DefaultTableModel)this.table.getModel()).getValueAt(j, 0).toString();
        }
        for (int i = 0; i < this.columnNames.length - 1; ++i) {
            for (int j2 = 1; j2 < this.columnNames.length; ++j2) {
                temp[i][j2 - 1] = new BigDecimal(((DefaultTableModel)this.table.getModel()).getValueAt(i, j2).toString());
            }
        }
        block3: for (j = 0; j < newOrderName.length; ++j) {
            for (int x = 0; x < this.localList.getNames().length; ++x) {
                if (!newOrderName[j].equals(this.localList.getNames()[x])) continue;
                for (int i = 0; i < this.localList.getNames().length; ++i) {
                    temp2[i][j] = temp[i][x];
                }
                continue block3;
            }
        }
        for (j = 0; j < newOrderName.length; ++j) {
            if (newOrderName[j].equals(this.localList.getNames()[j])) {
                tempDate[j] = this.localList.getDate()[j];
            } else {
                for (int u = 0; u < newOrderName.length; ++u) {
                    if (!newOrderName[j].equals(this.localList.getNames()[u])) continue;
                    tempDate[j] = this.localList.getDate()[u];
                    break;
                }
            }
            System.out.println(tempDate[j]);
        }
        this.localList.setDate(tempDate);
        this.localList.setNames(newOrderName);
        return temp2;
    }
}

