/*
 * Decompiled with CFR 0.152.
 */
package Patristic;

import Patristic.OptionListener;
import Patristic.PlotCoord;
import Patristic.PlotList;
import Patristic.PlotModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.math.BigDecimal;
import java.util.EventObject;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;

public class PlotPanel
extends JPanel
implements OptionListener,
Printable {
    private PlotModel plotModel;
    private static final int XLEFT = 100;
    private static final int LINELENGTH = 400;
    private static final int WIDTHLINE = 1;
    int valueX;
    int valueY;
    String infoEvent;
    String infoEvent1;
    String infoEvent2;
    String ft = "";
    String sd = "";
    boolean isRegress = false;
    boolean isDiffRatioChecked = false;
    boolean isDiffChecked = false;
    boolean isCaption = false;
    boolean isStat = false;
    boolean swap = false;
    int dotSize = 3;
    private MouseMotionHandler mouseMotionHandler = new MouseMotionHandler();

    public PlotPanel(PlotModel optionObject) {
        this.plotModel = optionObject;
        this.infoEvent = "";
        this.infoEvent1 = "";
        this.infoEvent2 = "";
        this.addMouseListener(new mouseHandler(this));
        this.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }
        });
    }

    public void highLight(String first, String second) {
        this.ft = first;
        this.sd = second;
        this.repaint();
    }

    private void drawGraph(VectorGraphics vg) {
        BigDecimal length;
        Dimension dim = this.getSize();
        Insets insets = this.getInsets();
        vg.setColor(Color.white);
        vg.fillRect(insets.left, insets.top, dim.width - insets.left - insets.right, dim.height - insets.top - insets.bottom);
        this.setBackground(Color.WHITE);
        vg.setColor(Color.black);
        vg.setFont(new Font("Courier New", 1, 12));
        vg.drawLine(100, 100, 100, 500);
        vg.drawLine(100, 500, 500, 500);
        if (this.isCaption) {
            vg.drawString("Tips: " + this.infoEvent, 10, 30);
            if (this.swap) {
                vg.drawString(this.plotModel.getList1().getFileName() + ": " + this.infoEvent2, 10, 50);
                vg.drawString(this.plotModel.getList2().getFileName() + ": " + this.infoEvent1, 10, 70);
            } else {
                vg.drawString(this.plotModel.getList1().getFileName() + ": " + this.infoEvent1, 10, 50);
                vg.drawString(this.plotModel.getList2().getFileName() + ": " + this.infoEvent2, 10, 70);
            }
        }
        if (this.swap) {
            vg.drawString(this.plotModel.getList1().getFileName(), 97, 96);
            vg.drawString(this.plotModel.getList2().getFileName(), 504, 500);
        } else {
            vg.drawString(this.plotModel.getList2().getFileName(), 97, 96);
            vg.drawString(this.plotModel.getList1().getFileName(), 504, 500);
        }
        BigDecimal yAbscissa = new BigDecimal("0");
        BigDecimal yAbscissaReal = this.plotModel.getMinYGraph();
        if (this.plotModel.getYUnit().compareTo(new BigDecimal("0")) != 0) {
            while (true) {
                yAbscissa = yAbscissa.add(this.plotModel.getYUnit());
                yAbscissaReal = yAbscissaReal.add(this.plotModel.getYUnit());
                if (yAbscissa.compareTo(this.plotModel.getMaxYGraph().subtract(this.plotModel.getMinYGraph())) == 0 || yAbscissa.compareTo(this.plotModel.getMaxYGraph().subtract(this.plotModel.getMinYGraph())) == 1) break;
                BigDecimal length2 = new BigDecimal(String.valueOf(400));
                BigDecimal y = yAbscissa.multiply(length2);
                y = y.divide(this.plotModel.getMaxYGraph().subtract(this.plotModel.getMinYGraph()), 1);
                vg.drawLine(97, 500 - y.intValue(), 100, 500 - y.intValue() + this.plotModel.getMinYGraph().intValue());
                vg.drawString(yAbscissaReal.toString(), 60, 500 - y.intValue() + this.plotModel.getMinYGraph().intValue());
            }
            vg.drawLine(97, 100, 100, 100);
            vg.drawString(this.plotModel.getMaxYGraph().setScale(2, 0).toString(), 60, 103);
        } else {
            vg.drawString(this.plotModel.getTheMaxReal().setScale(2, 0).toString(), 60, 103);
            vg.drawString(this.plotModel.getTheMaxReal().divide(new BigDecimal("2"), 2, 0).toString(), 60, 303);
            vg.drawLine(97, 100, 100, 100);
            vg.drawLine(97, 300, 100, 300);
        }
        BigDecimal xAbscissa = new BigDecimal("0");
        BigDecimal xAbscissaReal = this.plotModel.getMinXGraph();
        if (this.plotModel.getXUnit().compareTo(new BigDecimal(0)) != 0) {
            while (true) {
                xAbscissa = xAbscissa.add(this.plotModel.getXUnit());
                xAbscissaReal = xAbscissaReal.add(this.plotModel.getXUnit());
                if (xAbscissa.compareTo(this.plotModel.getMaxXGraph().subtract(this.plotModel.getMinXGraph())) == 0 || xAbscissa.compareTo(this.plotModel.getMaxXGraph().subtract(this.plotModel.getMinXGraph())) == 1) break;
                length = new BigDecimal(String.valueOf(400));
                BigDecimal y = xAbscissa.multiply(length);
                y = y.divide(this.plotModel.getMaxXGraph().subtract(this.plotModel.getMinXGraph()), 1);
                vg.drawLine(100 + y.intValue(), 500, 100 + y.intValue(), 505);
                vg.drawString(xAbscissaReal.toString(), 100 + y.intValue() - 20, 515);
            }
            vg.drawString(this.plotModel.getMaxXGraph().subtract(this.plotModel.getMinXGraph()).setScale(2, 0).toString(), 480, 515);
            vg.drawLine(500, 500, 500, 505);
        } else {
            vg.drawString(this.plotModel.getTheMaxReal().divide(new BigDecimal("2"), 2, 0).toString(), 280, 515);
            vg.drawString(this.plotModel.getTheMaxReal().setScale(2, 0).toString(), 480, 515);
            vg.drawLine(500, 500, 500, 505);
            vg.drawLine(300, 500, 300, 505);
        }
        vg.drawString("0", 95, 515);
        this.drawDots(vg);
        if (this.isRegress) {
            BigDecimal one;
            length = new BigDecimal(String.valueOf(400));
            vg.setColor(Color.red);
            if (this.swap) {
                one = this.plotModel.getIntercept()[1].subtract(this.plotModel.getMinXGraph());
                one = one.multiply(length);
                BigDecimal maxMinX = this.plotModel.getMaxXGraph().subtract(this.plotModel.getMinXGraph());
                one = one.divide(maxMinX, 1);
                if (this.plotModel.getMaxXGraph().equals(this.plotModel.getTheMaxReal()) && this.plotModel.getMaxYGraph().equals(this.plotModel.getTheMaxReal()) && this.plotModel.getMinXReal().equals(this.plotModel.getMinXGraph()) && this.plotModel.getMinYReal().equals(this.plotModel.getMinYGraph())) {
                    vg.drawLine(100, 500 - one.intValue(), 500, 500 - this.plotModel.getSlope()[1].multiply(new BigDecimal(400)).add(one).intValue());
                }
            } else {
                one = this.plotModel.getIntercept()[0].subtract(this.plotModel.getMinXGraph());
                one = one.multiply(length);
                BigDecimal maxMinX = this.plotModel.getMaxXGraph().subtract(this.plotModel.getMinXGraph());
                one = one.divide(maxMinX, 1);
                if (this.plotModel.getMaxXGraph().equals(this.plotModel.getTheMaxReal()) && this.plotModel.getMaxYGraph().equals(this.plotModel.getTheMaxReal()) && this.plotModel.getMinXReal().equals(this.plotModel.getMinXGraph()) && this.plotModel.getMinYReal().equals(this.plotModel.getMinYGraph())) {
                    vg.drawLine(100, 500 - one.intValue(), 500, 500 - this.plotModel.getSlope()[0].multiply(new BigDecimal(400)).add(one).intValue());
                }
            }
        }
    }

    public void paintComponent(Graphics g) {
        if (g == null) {
            return;
        }
        this.dotSize = Integer.valueOf(this.plotModel.getDotSize());
        VectorGraphics vg = VectorGraphics.create(g);
        this.drawGraph(vg);
    }

    private void drawDots(VectorGraphics vg) {
        int twoI = 0;
        int oneI = 0;
        int highLightx = -1;
        int highLighty = -1;
        PlotList plotList = this.plotModel.getPlotList();
        for (int i = 0; i < plotList.getNbPosition(); ++i) {
            if (this.swap) {
                twoI = ((PlotCoord)plotList.getList().elementAt(i)).getX();
                oneI = ((PlotCoord)plotList.getList().elementAt(i)).getY();
            } else {
                oneI = ((PlotCoord)plotList.getList().elementAt(i)).getX();
                twoI = ((PlotCoord)plotList.getList().elementAt(i)).getY();
            }
            if (oneI == -1 || twoI == -1) continue;
            if (((PlotCoord)plotList.getList().elementAt(i)).getName1().compareTo(this.ft) == 0 && ((PlotCoord)plotList.getList().elementAt(i)).getName2().compareTo(this.sd) == 0 || ((PlotCoord)plotList.getList().elementAt(i)).getName1().compareTo(this.sd) == 0 && ((PlotCoord)plotList.getList().elementAt(i)).getName2().compareTo(this.ft) == 0) {
                highLightx = oneI;
                highLighty = twoI;
                continue;
            }
            if (this.isStat) {
                boolean bool = false;
                BigDecimal xstd = this.plotModel.getXStd();
                BigDecimal mean = this.plotModel.getMean();
                BigDecimal plusStd = mean.add(xstd);
                BigDecimal minusStd = mean.subtract(xstd);
                BigDecimal value = ((PlotCoord)plotList.getList().elementAt(i)).getStatValue();
                if (value.compareTo(plusStd) == 1 || value.compareTo(minusStd) == -1) {
                    vg.setColor(Color.GREEN);
                    vg.fillRect(100 + oneI, 500 - twoI, this.dotSize, this.dotSize);
                    bool = true;
                }
                if (bool) continue;
            }
            vg.setColor(Color.BLACK);
            vg.fillRect(100 + oneI, 500 - twoI, this.dotSize, this.dotSize);
        }
        if (highLightx >= 0) {
            vg.setColor(Color.RED);
            vg.fillRect(100 + highLightx, 500 - highLighty, this.dotSize, this.dotSize);
        }
    }

    public void setRegress(boolean isRegress) {
        this.isRegress = isRegress;
        this.repaint();
    }

    public void setDiffRatio(boolean isDiffRatio) {
        this.isDiffRatioChecked = isDiffRatio;
        this.repaint();
    }

    public void setDiff(boolean isDiff) {
        this.isDiffChecked = isDiff;
        this.repaint();
    }

    public void setCaption(boolean isCaption) {
        this.isCaption = isCaption;
        if (isCaption) {
            this.addMouseMotionListener(this.mouseMotionHandler);
        } else {
            this.removeMouseMotionListener(this.mouseMotionHandler);
        }
        this.repaint();
    }

    public void swap() {
        this.swap = !this.swap;
        this.repaint();
    }

    public void setStat(boolean stat) {
        this.isStat = stat;
        this.repaint();
    }

    public void plotChanged(EventObject e) {
        this.repaint();
    }

    public int print(Graphics g, PageFormat pageFormat, int pi) throws PrinterException {
        if (pi >= 1) {
            return 1;
        }
        VectorGraphics vg = VectorGraphics.create(g);
        this.drawGraph(vg);
        return 0;
    }

    private void debug() {
        System.out.println("----------------------------");
        System.out.println("Max X graph: " + this.plotModel.getMaxXGraph() + " Min X graph: " + this.plotModel.getMinXGraph());
        System.out.println("Max Y graph: " + this.plotModel.getMaxYGraph() + " Min Y graph: " + this.plotModel.getMinYGraph());
        System.out.println("Max X real: " + this.plotModel.getMaxXReal() + " Min X real: " + this.plotModel.getMinXReal());
        System.out.println("Max Y real: " + this.plotModel.getMaxYReal() + " Min Y real: " + this.plotModel.getMinYReal());
        System.out.println("The max real: " + this.plotModel.getTheMaxReal());
    }

    private class mouseHandler
    extends MouseAdapter {
        PlotPanel panel;

        mouseHandler(PlotPanel panel) {
            this.panel = panel;
        }

        public void mouseClicked(MouseEvent e) {
            this.panel.swap();
        }
    }

    class MouseMotionHandler
    extends MouseMotionAdapter {
        MouseMotionHandler() {
        }

        public void mouseMoved(MouseEvent e) {
            PlotList plotList = PlotPanel.this.plotModel.getPlotList();
            PlotPanel.this.valueX = e.getX();
            PlotPanel.this.valueY = e.getY();
            for (int i = 0; i < plotList.getNbPosition(); ++i) {
                int twoI;
                int oneI;
                if (PlotPanel.this.swap) {
                    oneI = ((PlotCoord)plotList.getList().elementAt(i)).getY() + 100;
                    twoI = 500 - ((PlotCoord)plotList.getList().elementAt(i)).getX();
                } else {
                    oneI = ((PlotCoord)plotList.getList().elementAt(i)).getX() + 100;
                    twoI = 500 - ((PlotCoord)plotList.getList().elementAt(i)).getY();
                }
                if (PlotPanel.this.valueX > oneI && PlotPanel.this.valueX <= oneI + PlotPanel.this.dotSize && PlotPanel.this.valueY <= twoI + PlotPanel.this.dotSize && PlotPanel.this.valueY > twoI) {
                    PlotPanel.this.infoEvent = ((PlotCoord)plotList.getList().elementAt(i)).getName1() + " & " + ((PlotCoord)plotList.getList().elementAt(i)).getName2();
                    PlotPanel.this.infoEvent1 = ((PlotCoord)plotList.getList().elementAt(i)).getXx().toString();
                    PlotPanel.this.infoEvent2 = ((PlotCoord)plotList.getList().elementAt(i)).getYy().toString();
                    PlotPanel.this.repaint();
                    break;
                }
                PlotPanel.this.infoEvent = "";
                PlotPanel.this.infoEvent1 = "";
                PlotPanel.this.infoEvent2 = "";
            }
        }
    }
}

