/*
 * Decompiled with CFR 0.152.
 */
package Patristic;

import Patristic.Matrix;
import Patristic.OptionListener;
import Patristic.PlotCoord;
import Patristic.PlotList;
import Patristic.PlotModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.math.BigDecimal;
import java.util.EventObject;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;

public class PlotTime
extends JPanel
implements OptionListener,
Printable {
    private PlotModel plotModel;
    private Matrix list;
    String infoEvent;
    String infoEvent1;
    String infoEvent2;
    boolean swap = false;
    int dotSize = 3;
    private static final int XLEFT = 100;
    private static final int LINELENGTH = 400;
    private static final int WIDTHLINE = 1;
    int valueX;
    int valueY;
    BigDecimal length;
    String ft = "";
    String sd = "";
    boolean isRegress = false;
    boolean isDiffRatio = false;
    boolean isCaption = true;
    String correlation = "";

    public PlotTime(PlotModel plotModel) {
        this.plotModel = plotModel;
        this.infoEvent = "";
        this.infoEvent1 = "";
        this.infoEvent2 = "";
        this.addMouseMotionListener(new mouseMotionHandler());
        this.addMouseListener(new mouseHandler(this));
        this.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }
        });
    }

    public void highLight(String first, String second) {
        this.ft = first;
        this.sd = second;
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        if (g == null) {
            return;
        }
        this.dotSize = Integer.valueOf(this.plotModel.getDotSize());
        VectorGraphics vg = VectorGraphics.create(g);
        this.drawGraph(vg);
    }

    public void drawGraph(VectorGraphics vg) {
        Dimension dim = this.getSize();
        Insets insets = this.getInsets();
        vg.setColor(Color.white);
        vg.fillRect(insets.left, insets.top, dim.width - insets.left - insets.right, dim.height - insets.top - insets.bottom);
        this.setBackground(Color.WHITE);
        vg.setColor(Color.BLACK);
        vg.setFont(new Font("Courier New", 1, 12));
        vg.drawLine(100, 100, 100, 500);
        vg.drawLine(100, 500, 500, 500);
        vg.drawString("Tips: " + this.infoEvent, 10, 30);
        if (this.isCaption) {
            vg.drawString("Tips: " + this.infoEvent, 10, 30);
            vg.drawString("Distance: " + this.infoEvent1, 10, 50);
            vg.drawString("Time Difference: " + this.infoEvent2, 10, 70);
        }
        vg.drawString("Time Difference", 97, 96);
        vg.drawString("Patristic distance", 504, 500);
        BigDecimal yAbscissa = new BigDecimal("0");
        BigDecimal yAbscissaReal = this.plotModel.getMinYGraph();
        if (this.plotModel.getYUnit().compareTo(new BigDecimal("0")) != 0) {
            while (true) {
                yAbscissa = yAbscissa.add(this.plotModel.getYUnit());
                yAbscissaReal = yAbscissaReal.add(this.plotModel.getYUnit());
                if (yAbscissa.compareTo(this.plotModel.getMaxYGraph().subtract(this.plotModel.getMinYGraph())) == 0 || yAbscissa.compareTo(this.plotModel.getMaxYGraph().subtract(this.plotModel.getMinYGraph())) == 1) break;
                BigDecimal length = new BigDecimal(String.valueOf(400));
                BigDecimal y = yAbscissa.multiply(length);
                y = y.divide(this.plotModel.getMaxYGraph().subtract(this.plotModel.getMinYGraph()), 1);
                vg.drawLine(97, 500 - y.intValue(), 100, 500 - y.intValue() + this.plotModel.getMinYGraph().intValue());
                vg.drawString(yAbscissaReal.toString(), 60, 500 - y.intValue() + this.plotModel.getMinYGraph().intValue());
            }
            vg.drawLine(97, 100, 100, 100);
            vg.drawString(this.plotModel.getMaxYGraph().setScale(2, 0).toString(), 60, 103);
        } else {
            vg.drawString(this.plotModel.getMaxYReal().setScale(2, 0).toString(), 60, 103);
            vg.drawString(this.plotModel.getMaxYReal().divide(new BigDecimal("2"), 2, 0).toString(), 60, 303);
            vg.drawLine(97, 100, 100, 100);
            vg.drawLine(97, 300, 100, 300);
        }
        BigDecimal xAbscissa = new BigDecimal("0");
        BigDecimal xAbscissaReal = this.plotModel.getMinXGraph();
        if (this.plotModel.getXUnit().compareTo(new BigDecimal("0")) != 0) {
            while (true) {
                xAbscissa = xAbscissa.add(this.plotModel.getXUnit());
                xAbscissaReal = xAbscissaReal.add(this.plotModel.getXUnit());
                if (xAbscissa.compareTo(this.plotModel.getMaxXGraph().subtract(this.plotModel.getMinXGraph())) == 0 || xAbscissa.compareTo(this.plotModel.getMaxXGraph().subtract(this.plotModel.getMinXGraph())) == 1) break;
                BigDecimal length = new BigDecimal(String.valueOf(400));
                BigDecimal y = xAbscissa.multiply(length);
                y = y.divide(this.plotModel.getMaxXGraph().subtract(this.plotModel.getMinXGraph()), 1);
                vg.drawLine(100 + y.intValue(), 500, 100 + y.intValue(), 505);
                vg.drawString(xAbscissaReal.toString(), 100 + y.intValue() - 20, 515);
            }
            vg.drawString(this.plotModel.getMaxXGraph().subtract(this.plotModel.getMinXGraph()).setScale(2, 0).toString(), 480, 515);
            vg.drawLine(500, 500, 500, 505);
        } else {
            vg.drawString(this.plotModel.getMaxXReal().divide(new BigDecimal("2"), 2, 0).toString(), 280, 515);
            vg.drawString(this.plotModel.getMaxXReal().setScale(2, 0).toString(), 480, 515);
            vg.drawLine(500, 500, 500, 505);
            vg.drawLine(300, 500, 300, 505);
        }
        vg.drawString("0", 100, 515);
        this.drawDots(vg);
    }

    private void drawDots(VectorGraphics vg) {
        int twoI = 0;
        int oneI = 0;
        int highLightx = -1;
        int highLighty = -1;
        PlotList plotList = this.plotModel.getPlotList();
        for (int i = 0; i < plotList.getNbPosition(); ++i) {
            if (this.swap) {
                twoI = ((PlotCoord)plotList.getList().elementAt(i)).getX();
                oneI = ((PlotCoord)plotList.getList().elementAt(i)).getY();
            } else {
                oneI = ((PlotCoord)plotList.getList().elementAt(i)).getX();
                twoI = ((PlotCoord)plotList.getList().elementAt(i)).getY();
            }
            if (oneI == -1 || twoI == -1 || ((PlotCoord)plotList.getList().elementAt(i)).getXx().compareTo(this.plotModel.getMaxXGraph()) == 1 || ((PlotCoord)plotList.getList().elementAt(i)).getYy().compareTo(this.plotModel.getMaxYGraph()) == 1) continue;
            if (((PlotCoord)plotList.getList().elementAt(i)).getName1().compareTo(this.ft) == 0 && ((PlotCoord)plotList.getList().elementAt(i)).getName2().compareTo(this.sd) == 0 || ((PlotCoord)plotList.getList().elementAt(i)).getName1().compareTo(this.sd) == 0 && ((PlotCoord)plotList.getList().elementAt(i)).getName2().compareTo(this.ft) == 0) {
                vg.setColor(Color.RED);
            } else {
                vg.setColor(Color.BLACK);
            }
            vg.fillRect(100 + oneI, 500 - twoI, this.dotSize, this.dotSize);
        }
    }

    public void plotChanged(EventObject e) {
        this.repaint();
    }

    public void swap() {
        this.swap = !this.swap;
        this.repaint();
    }

    public int print(Graphics g, PageFormat pageFormat, int pi) throws PrinterException {
        if (pi >= 1) {
            return 1;
        }
        VectorGraphics vg = VectorGraphics.create(g);
        this.drawGraph(vg);
        return 0;
    }

    private class mouseHandler
    extends MouseAdapter {
        PlotTime panel;

        mouseHandler(PlotTime panel) {
            this.panel = panel;
        }

        public void mouseClicked(MouseEvent e) {
            this.panel.swap();
        }
    }

    class mouseMotionHandler
    extends MouseMotionAdapter {
        mouseMotionHandler() {
        }

        public void mouseMoved(MouseEvent e) {
            PlotList plotList = PlotTime.this.plotModel.getPlotList();
            PlotTime.this.valueX = e.getX();
            PlotTime.this.valueY = e.getY();
            for (int i = 0; i < plotList.getNbPosition(); ++i) {
                int oneI;
                int twoI;
                if (PlotTime.this.swap) {
                    twoI = 500 - ((PlotCoord)plotList.getList().elementAt(i)).getX();
                    oneI = ((PlotCoord)plotList.getList().elementAt(i)).getY() + 100;
                } else {
                    twoI = 500 - ((PlotCoord)plotList.getList().elementAt(i)).getY();
                    oneI = ((PlotCoord)plotList.getList().elementAt(i)).getX() + 100;
                }
                if (PlotTime.this.valueX > oneI && PlotTime.this.valueX <= oneI + PlotTime.this.dotSize && PlotTime.this.valueY <= twoI + PlotTime.this.dotSize && PlotTime.this.valueY > twoI) {
                    PlotTime.this.infoEvent = ((PlotCoord)plotList.getList().elementAt(i)).getName1() + " & " + ((PlotCoord)plotList.getList().elementAt(i)).getName2();
                    PlotTime.this.infoEvent1 = ((PlotCoord)plotList.getList().elementAt(i)).getXx().toString();
                    PlotTime.this.infoEvent2 = String.valueOf(((PlotCoord)plotList.getList().elementAt(i)).getYy());
                    PlotTime.this.repaint();
                    break;
                }
                PlotTime.this.infoEvent = "";
                PlotTime.this.infoEvent1 = "";
                PlotTime.this.infoEvent2 = "";
            }
        }
    }
}

