/*
 * Decompiled with CFR 0.152.
 */
package Patristic;

import Patristic.Matrix;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class Polytomy
extends JFrame {
    private boolean DEBUG = false;
    MyTableModel myModel;
    TextField text = new TextField(50);

    public Polytomy(Matrix list) {
        super("Polytomy tool");
        this.myModel = new MyTableModel(list);
        JTable table = new JTable(this.myModel);
        table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        Panel top = new Panel();
        Button button = new Button("Get Tree");
        top.add((Component)button, "Center");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Polytomy.this.save();
            }
        });
        top.add(this.text);
        this.getContentPane().add((Component)top, "North");
        JScrollPane scrollPane = new JScrollPane(table);
        this.getContentPane().add((Component)scrollPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
            }
        });
    }

    private void save() {
        String result = "(";
        String poly1 = "(";
        String poly2 = "";
        for (int i = 0; i < this.myModel.getRowCount(); ++i) {
            if (this.myModel.getValueAt(i, 0).toString().compareTo("true") == 0) {
                poly1 = poly1 + String.valueOf(i + 1) + ",";
                continue;
            }
            poly2 = poly2 + String.valueOf(i + 1) + ",";
        }
        poly1 = poly1.substring(0, poly1.length() - 1);
        poly1 = poly1 + ")";
        result = result + poly2 + poly1 + ")";
        this.text.setText(result);
    }

    public static void main(String[] args) {
    }

    class MyTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{"", "taxon"};
        final Object[][] data;

        public MyTableModel(Matrix list) {
            this.data = new Object[list.getNames().length][2];
            for (int i = 0; i < list.getNames().length; ++i) {
                this.data[i][0] = new Boolean(false);
                this.data[i][1] = list.getNames()[i];
            }
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col <= 0;
        }

        public void setValueAt(Object value, int row, int col) {
            if (Polytomy.this.DEBUG) {
                System.out.println("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
            }
            if (this.data[0][col] instanceof Integer && !(value instanceof Integer)) {
                try {
                    this.data[row][col] = new Integer(value.toString());
                    this.fireTableCellUpdated(row, col);
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(Polytomy.this, "The \"" + this.getColumnName(col) + "\" column accepts only integer values.");
                }
            } else {
                this.data[row][col] = value;
                this.fireTableCellUpdated(row, col);
            }
            if (Polytomy.this.DEBUG) {
                System.out.println("New value of data:");
                this.printDebugData();
            }
        }

        private void printDebugData() {
            int numRows = this.getRowCount();
            int numCols = this.getColumnCount();
            for (int i = 0; i < numRows; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < numCols; ++j) {
                    System.out.print("  " + this.data[i][j]);
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }
}

