/*
 * Decompiled with CFR 0.152.
 */
package Patristic;

import Patristic.Matrix;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Loader {
    public static int UPPERMATRIX = 0;
    public static int LOWERMATRIX = 1;
    public static int COLUMN = 2;
    public static int MEGA = 3;
    public static int PHYLIP = 4;
    public static int DIPLOMO = 5;
    private int prog;
    private String fileName;
    private Matrix list;
    private int nbTaxa = 0;
    String[] ColNames;
    BigDecimal sbl = new BigDecimal("0");

    public Loader(String path, int prog) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(path));
            String fileSeparator = System.getProperty("file.separator");
            this.fileName = path.substring(path.lastIndexOf(fileSeparator) + 1);
            switch (prog) {
                case 0: {
                    this.upperMatrix(this.toArray(in));
                    break;
                }
                case 1: {
                    this.lowerMatrix(this.toArray(in));
                    break;
                }
                case 2: {
                    this.column(in);
                    break;
                }
                case 3: {
                    this.mega(in);
                    break;
                }
                case 4: {
                    this.phylip(in);
                    break;
                }
                case 5: {
                    this.diplomo(in);
                    break;
                }
            }
            in.close();
        }
        catch (IOException err) {
            System.out.println("IO " + err.getMessage());
        }
        catch (NullPointerException err) {
            err.printStackTrace();
        }
    }

    public Matrix getList() {
        return this.list;
    }

    private void lowerMatrix(String[][] array) {
        int nb = 1;
        this.list = new Matrix(this.ColNames, this.fileName);
        BigDecimal[][] matrix = new BigDecimal[this.nbTaxa][this.nbTaxa];
        for (int i = 0; i < this.nbTaxa; ++i) {
            for (int j = 0; j < this.nbTaxa; ++j) {
                matrix[i][j] = new BigDecimal("0");
            }
        }
        for (int j = 1; j <= this.nbTaxa; ++j) {
            for (int i = nb; i <= this.nbTaxa; ++i) {
                this.sbl = this.sbl.add(new BigDecimal(array[j][i]));
                matrix[j - 1][i - 1] = new BigDecimal(array[j][i]);
                matrix[i - 1][j - 1] = new BigDecimal(array[j][i]);
                if (nb > this.nbTaxa) break;
            }
            ++nb;
        }
        this.list.setSbl(this.sbl);
        this.list.setMatrix(matrix);
    }

    private void upperMatrix(String[][] array) {
        int j;
        int i;
        int nb = 1;
        this.list = new Matrix(this.ColNames, this.fileName);
        BigDecimal[][] matrix = new BigDecimal[this.nbTaxa][this.nbTaxa];
        for (i = 0; i < this.nbTaxa; ++i) {
            for (j = 0; j < this.nbTaxa; ++j) {
                matrix[i][j] = new BigDecimal("0");
            }
        }
        for (i = 1; i <= this.nbTaxa; ++i) {
            for (j = 1; j <= this.nbTaxa; ++j) {
                this.sbl = this.sbl.add(new BigDecimal(array[j][i]));
                matrix[j - 1][i - 1] = new BigDecimal(array[j][i]);
                matrix[i - 1][j - 1] = new BigDecimal(array[j][i]);
                if (nb > this.nbTaxa) break;
            }
            ++nb;
        }
        this.list.setSbl(this.sbl);
        this.list.setMatrix(matrix);
    }

    private String[][] toArray(BufferedReader in) throws IOException {
        boolean eof = false;
        boolean isBegin = true;
        int posj = 0;
        this.nbTaxa = Integer.parseInt(in.readLine());
        String[][] array = new String[this.nbTaxa + 1][this.nbTaxa + 1];
        this.ColNames = new String[this.nbTaxa];
        int posi = 0;
        int margin = 0;
        String[] names = null;
        while (!eof) {
            String line = in.readLine();
            if (line == null) {
                eof = true;
                continue;
            }
            if (isBegin) {
                names = line.split("\\s+");
                array[0][0] = "";
                for (int i = 1; i < names.length; ++i) {
                    array[i + posi][0] = names[i];
                    this.ColNames[i + posi - 1] = names[i];
                }
                isBegin = false;
                while (line.substring(margin, margin + 1).compareTo(" ") == 0) {
                    ++margin;
                }
                continue;
            }
            if (line.compareTo("") == 0) {
                isBegin = true;
                posj = 0;
                posi += names.length - 1;
                continue;
            }
            String tempp = line.substring(margin - 2);
            String[] temp = tempp.split("\\s+");
            array[0][++posj] = line.substring(0, margin - 1);
            for (int i = 1; i < temp.length; ++i) {
                if (temp[i].compareTo("-") == 0) {
                    temp[i] = "0";
                }
                array[i + posi][posj] = temp[i];
            }
        }
        return array;
    }

    private void column(BufferedReader in) throws IOException {
        int i;
        int nbPair = 0;
        Vector<String> vec = new Vector<String>();
        Vector<String> vecName = new Vector<String>();
        boolean eof = false;
        while (!eof) {
            String line = in.readLine();
            if (line == null) {
                eof = true;
                continue;
            }
            String[] temp = line.split("\\t+");
            vec.add(temp[2]);
            if (nbPair == 0) {
                vecName.add(temp[1]);
            }
            if (!vecName.contains(temp[0])) {
                vecName.add(temp[0]);
            }
            ++nbPair;
        }
        nbPair = 0;
        int nbTip = 1;
        BigDecimal[][] matrix = new BigDecimal[vecName.size()][vecName.size()];
        this.ColNames = new String[vecName.size()];
        for (i = 0; i < vecName.size(); ++i) {
            this.ColNames[i] = vecName.elementAt(i).toString();
        }
        this.list = new Matrix(this.ColNames, this.fileName);
        for (i = 0; i < vecName.size(); ++i) {
            for (int j = 0; j < vecName.size(); ++j) {
                matrix[i][j] = new BigDecimal("0");
            }
        }
        while (vec.size() > nbPair) {
            for (int k = 0; k < nbTip; ++k) {
                this.sbl = this.sbl.add(new BigDecimal(vec.elementAt(nbPair).toString()));
                matrix[nbTip][k] = new BigDecimal(vec.elementAt(nbPair).toString());
                matrix[k][nbTip] = new BigDecimal(vec.elementAt(nbPair).toString());
                ++nbPair;
            }
            ++nbTip;
        }
        this.list.setMatrix(matrix);
        this.list.setSbl(this.sbl);
    }

    private void mega(BufferedReader in) throws IOException {
        boolean eof = false;
        boolean isBegin = false;
        boolean header = false;
        boolean saut = false;
        String[] names = null;
        Vector<String> colNames = new Vector<String>();
        int nbColNames = 0;
        BigDecimal[][] matrix = null;
        int lineNb = 0;
        Pattern pattern = Pattern.compile("#");
        Matcher matcher = pattern.matcher("");
        while (!eof) {
            int i;
            String line = in.readLine();
            matcher.reset(line);
            if (line == null) {
                eof = true;
                continue;
            }
            if (isBegin) {
                names = line.substring(line.indexOf("]") + 1).split("\\s+");
                if (names[names.length - 1].compareTo("") == 0) break;
                for (int i2 = 1; i2 < names.length; ++i2) {
                    this.sbl = this.sbl.add(new BigDecimal(names[i2]));
                    matrix[lineNb][lineNb + i2] = new BigDecimal(names[i2]);
                    matrix[lineNb + i2][lineNb] = new BigDecimal(names[i2]);
                }
                ++lineNb;
                continue;
            }
            if (matcher.find() && line.compareTo("#mega") != 0) {
                colNames.add(line.substring(line.indexOf("#") + 1));
                ++nbColNames;
                header = true;
                continue;
            }
            if (header && line.compareTo("") == 0) {
                saut = true;
                continue;
            }
            if (!saut) continue;
            isBegin = true;
            saut = false;
            String[] columnNames = new String[nbColNames];
            for (i = 0; i < nbColNames; ++i) {
                columnNames[i] = (String)colNames.elementAt(i);
            }
            this.list = new Matrix(columnNames, this.fileName);
            matrix = new BigDecimal[nbColNames][nbColNames];
            for (i = 0; i < nbColNames; ++i) {
                for (int j = 0; j < nbColNames; ++j) {
                    matrix[i][j] = new BigDecimal("0");
                }
            }
        }
        this.list.setMatrix(matrix);
        this.list.setSbl(this.sbl);
    }

    private void phylip(BufferedReader in) throws IOException {
        String line;
        boolean eof = false;
        Vector colNames = new Vector();
        int lineNb = 0;
        int nb = 0;
        boolean lineFinished = true;
        int nbTip = Integer.valueOf(in.readLine().replaceAll(" ", ""));
        BigDecimal[][] matrix = new BigDecimal[nbTip][nbTip];
        String[] columnNames = new String[nbTip];
        while (!eof && (line = in.readLine()) != null && lineNb <= nbTip) {
            int i;
            String[] lineArray = line.split("\\s{2}");
            if (lineFinished) {
                for (i = 1; i < lineArray.length; ++i) {
                    columnNames[lineNb] = lineArray[0];
                    matrix[lineNb][i - 1] = new BigDecimal(lineArray[i]);
                    this.sbl = this.sbl.add(new BigDecimal(lineArray[i]));
                }
                if ((nb += lineArray.length - 1) < nbTip) {
                    lineFinished = false;
                    continue;
                }
                ++lineNb;
                lineFinished = true;
                continue;
            }
            for (i = 1; i < lineArray.length; ++i) {
                System.out.println(lineArray[0]);
                matrix[lineNb][i - 1 + nb] = new BigDecimal(lineArray[i]);
                this.sbl = this.sbl.add(new BigDecimal(lineArray[i]));
            }
            if ((nb += lineArray.length) < nbTip) {
                lineFinished = false;
                continue;
            }
            ++lineNb;
            lineFinished = true;
            nb = 0;
        }
        this.list = new Matrix(columnNames, this.fileName);
        this.list.setMatrix(matrix);
        this.list.setSbl(this.sbl);
    }

    private void diplomo(BufferedReader in) throws IOException {
        boolean eof = false;
        boolean isBegin = false;
        boolean header = false;
        boolean saut = false;
        boolean space = false;
        String[] distances = null;
        Vector<String> colNames = new Vector<String>();
        int nbColNames = 0;
        Pattern pattern = Pattern.compile("#");
        Matcher matcher = pattern.matcher("");
        boolean first = false;
        boolean second = false;
        int lineNb = 0;
        BigDecimal[][] matrix = null;
        while (!eof) {
            int i;
            String line = in.readLine();
            matcher.reset(line);
            if (line == null) {
                eof = true;
                continue;
            }
            if (isBegin) {
                distances = line.split("\t+");
                for (int i2 = 1; i2 < distances.length; ++i2) {
                    this.sbl = this.sbl.add(new BigDecimal(distances[i2]));
                    matrix[lineNb][lineNb + i2] = new BigDecimal(distances[i2]);
                    matrix[lineNb + i2][lineNb] = new BigDecimal(distances[i2]);
                }
                ++lineNb;
                continue;
            }
            if (!saut && line.compareTo("") != 0) {
                colNames.add(line);
                ++nbColNames;
                header = true;
                continue;
            }
            if (header && line.compareTo("") == 0) {
                saut = true;
                continue;
            }
            if (!saut) continue;
            isBegin = true;
            saut = false;
            String[] columnNames = new String[nbColNames];
            for (i = 0; i < nbColNames; ++i) {
                columnNames[i] = (String)colNames.elementAt(i);
            }
            this.list = new Matrix(columnNames, this.fileName);
            matrix = new BigDecimal[nbColNames][nbColNames];
            for (i = 0; i < nbColNames; ++i) {
                for (int j = 0; j < nbColNames; ++j) {
                    matrix[i][j] = new BigDecimal("0");
                }
            }
        }
        this.list.setMatrix(matrix);
        this.list.setSbl(this.sbl);
    }
}

