/*
 * Decompiled with CFR 0.152.
 */
package Patristic;

import Patristic.Matrix;
import Patristic.PlotCoord;
import Patristic.PlotList;
import java.math.BigDecimal;

public class MathStat {
    public static void main(String[] args) {
        String[] list11 = new String[]{"71", "68", "66", "67", "70", "71", "70", "73", "72", "65", "66"};
        String[] list22 = new String[]{"69", "64", "65", "63", "65", "62", "65", "64", "66", "59", "62"};
        BigDecimal mean11 = MathStat.mean(list11);
        System.out.println(mean11);
        BigDecimal mean22 = MathStat.mean(list22);
        System.out.println(mean22);
        BigDecimal co = MathStat.correlation(list11, list22, mean11, mean22);
        System.out.println(co);
    }

    private static BigDecimal mean(String[] list) {
        BigDecimal result = new BigDecimal("0");
        for (int i = 0; i < list.length; ++i) {
            result = result.add(new BigDecimal(list[i]));
        }
        return result.divide(new BigDecimal(String.valueOf(list.length)), 3);
    }

    private static BigDecimal correlation(String[] list1, String[] list2, BigDecimal mean1, BigDecimal mean2) {
        BigDecimal result = new BigDecimal("0");
        BigDecimal variance1 = new BigDecimal("0");
        BigDecimal variance2 = new BigDecimal("0");
        BigDecimal covariance = new BigDecimal("0");
        for (int i = 0; i < list1.length; ++i) {
            BigDecimal value1 = new BigDecimal(list1[i]).subtract(mean1);
            BigDecimal value2 = new BigDecimal(list2[i]).subtract(mean2);
            variance1 = variance1.add(value1.multiply(value1));
            variance2 = variance2.add(value2.multiply(value2));
            covariance = covariance.add(value1.multiply(value2));
        }
        System.out.println("v1 " + variance1);
        System.out.println("v2 " + variance2);
        System.out.println("covar " + covariance);
        BigDecimal sqrt = MathStat.sqrt(variance1.multiply(variance2));
        System.out.println("sqrt " + sqrt);
        result = covariance.divide(sqrt, 3, 3);
        return result;
    }

    public static BigDecimal correlation(Matrix list1, Matrix list2, BigDecimal mean1, BigDecimal mean2) {
        BigDecimal result = new BigDecimal("0");
        BigDecimal variance1 = new BigDecimal("0");
        BigDecimal variance2 = new BigDecimal("0");
        BigDecimal covariance = new BigDecimal("0");
        for (int i = 0; i < list1.getNames().length; ++i) {
            for (int j = i + 1; j < list1.getNames().length; ++j) {
                BigDecimal value1 = list1.getMatrix()[i][j].subtract(mean1);
                BigDecimal value2 = list2.getMatrix()[i][j].subtract(mean2);
                variance1 = variance1.add(value1.multiply(value1));
                variance2 = variance2.add(value2.multiply(value2));
                covariance = covariance.add(value1.multiply(value2));
            }
        }
        BigDecimal sqrt = MathStat.sqrt(variance1.multiply(variance2));
        result = covariance.divide(sqrt, 3, 3);
        return result;
    }

    public static BigDecimal correlation(PlotList list, BigDecimal mean1, BigDecimal mean2) {
        BigDecimal result = new BigDecimal("0");
        BigDecimal variance1 = new BigDecimal("0");
        BigDecimal variance2 = new BigDecimal("0");
        BigDecimal covariance = new BigDecimal("0");
        for (int i = 0; i < list.getNbPosition(); ++i) {
            BigDecimal value1 = ((PlotCoord)list.getList().elementAt(i)).getXx().subtract(mean1);
            BigDecimal value2 = ((PlotCoord)list.getList().elementAt(i)).getYy().subtract(mean2);
            variance1 = variance1.add(value1.multiply(value1));
            variance2 = variance2.add(value2.multiply(value2));
            covariance = covariance.add(value1.multiply(value2));
        }
        result = covariance.divide(MathStat.sqrt(variance1.multiply(variance2)), 3, 3);
        return result;
    }

    public static BigDecimal stdDev(PlotList list, BigDecimal mean) {
        BigDecimal variance = MathStat.variance(list, mean);
        double result = Math.sqrt(variance.doubleValue());
        return new BigDecimal(result);
    }

    public static BigDecimal variance(PlotList list, BigDecimal mean) {
        BigDecimal sum = new BigDecimal("0");
        for (int i = 0; i < list.getNbPosition(); ++i) {
            BigDecimal nb = ((PlotCoord)list.getList().elementAt(i)).getStatValue().subtract(mean);
            sum = sum.add(nb.multiply(nb));
        }
        return sum.divide(new BigDecimal(String.valueOf(list.getNbPosition())), 3);
    }

    public static BigDecimal mean(BigDecimal sum, int population) {
        BigDecimal mean = new BigDecimal("0");
        mean = sum.divide(new BigDecimal(String.valueOf(population)), 3);
        return mean;
    }

    public static BigDecimal[] slope(PlotList list) {
        BigDecimal sumX = new BigDecimal("0");
        BigDecimal sumY = new BigDecimal("0");
        BigDecimal xx = new BigDecimal("0");
        BigDecimal yy = new BigDecimal("0");
        BigDecimal xy = new BigDecimal("0");
        BigDecimal slope1 = new BigDecimal("0");
        BigDecimal slope2 = new BigDecimal("0");
        for (int i = 0; i < list.getNbPosition(); ++i) {
            sumX = sumX.add(((PlotCoord)list.getList().elementAt(i)).getXx());
            sumY = sumY.add(((PlotCoord)list.getList().elementAt(i)).getYy());
            xx = xx.add(((PlotCoord)list.getList().elementAt(i)).getXx().multiply(((PlotCoord)list.getList().elementAt(i)).getXx()));
            yy = yy.add(((PlotCoord)list.getList().elementAt(i)).getYy().multiply(((PlotCoord)list.getList().elementAt(i)).getYy()));
            xy = xy.add(((PlotCoord)list.getList().elementAt(i)).getXx().multiply(((PlotCoord)list.getList().elementAt(i)).getYy()));
        }
        BigDecimal num = sumX.multiply(sumY);
        num = num.divide(new BigDecimal(String.valueOf(list.getNbPosition())), 3);
        num = xy.subtract(num);
        BigDecimal denom1 = sumX.multiply(sumX);
        denom1 = denom1.divide(new BigDecimal(String.valueOf(list.getNbPosition())), 3);
        denom1 = xx.subtract(denom1);
        slope1 = num.divide(denom1, 3);
        BigDecimal denom2 = sumY.multiply(sumY);
        denom2 = denom2.divide(new BigDecimal(String.valueOf(list.getNbPosition())), 3);
        denom2 = yy.subtract(denom2);
        slope2 = num.divide(denom2, 3);
        BigDecimal[] array = new BigDecimal[]{slope1, slope2};
        return array;
    }

    public static BigDecimal[] intercept(PlotList list, BigDecimal[] slope) {
        BigDecimal sumX = new BigDecimal("0");
        BigDecimal sumY = new BigDecimal("0");
        BigDecimal intercept1 = new BigDecimal("0");
        BigDecimal intercept2 = new BigDecimal("0");
        for (int i = 0; i < list.getNbPosition(); ++i) {
            sumX = sumX.add(((PlotCoord)list.getList().elementAt(i)).getXx());
            sumY = sumY.add(((PlotCoord)list.getList().elementAt(i)).getYy());
        }
        intercept1 = sumX.multiply(slope[0]);
        intercept1 = sumY.subtract(intercept1);
        intercept1 = intercept1.divide(new BigDecimal(String.valueOf(list.getNbPosition())), 3);
        intercept2 = sumY.multiply(slope[1]);
        intercept2 = sumX.subtract(intercept2);
        intercept2 = intercept2.divide(new BigDecimal(String.valueOf(list.getNbPosition())), 3);
        BigDecimal[] array = new BigDecimal[]{intercept1, intercept2};
        return array;
    }

    public static BigDecimal slope(PlotList list, BigDecimal mean1, BigDecimal mean2) {
        BigDecimal sdx = MathStat.stdDev(list, 1, mean1);
        BigDecimal sdy = MathStat.stdDev(list, 2, mean2);
        BigDecimal slope = sdx.divide(sdy, 3);
        return slope;
    }

    public static BigDecimal idntercept(PlotList list, BigDecimal slope) {
        BigDecimal xx = MathStat.mean(list, 1);
        BigDecimal yy = MathStat.mean(list, 2);
        BigDecimal intercept = yy.divide(xx.multiply(slope), 3);
        return intercept;
    }

    public static BigDecimal variance(PlotList list, int axe, BigDecimal mean) {
        BigDecimal sum = new BigDecimal("0");
        if (axe == 1) {
            for (int i = 0; i < list.getNbPosition(); ++i) {
                BigDecimal nb = ((PlotCoord)list.getList().elementAt(i)).getXx().subtract(mean);
                sum = sum.add(nb.multiply(nb));
            }
        } else {
            for (int i = 0; i < list.getNbPosition(); ++i) {
                BigDecimal nb = ((PlotCoord)list.getList().elementAt(i)).getYy().subtract(mean);
                sum = sum.add(nb.multiply(nb));
            }
        }
        return sum.divide(new BigDecimal(String.valueOf(list.getNbPosition())), 3);
    }

    public static BigDecimal stdDev(PlotList list, int axe, BigDecimal mean) {
        BigDecimal variance = MathStat.variance(list, axe, mean);
        double result = Math.sqrt(variance.doubleValue());
        return new BigDecimal(result);
    }

    public static BigDecimal mean(PlotList list, int axe) {
        BigDecimal mean = new BigDecimal("0");
        if (axe == 1) {
            for (int i = 0; i < list.getNbPosition(); ++i) {
                mean = mean.add(((PlotCoord)list.getList().elementAt(i)).getXx());
            }
        } else {
            for (int i = 0; i < list.getNbPosition(); ++i) {
                mean = mean.add(((PlotCoord)list.getList().elementAt(i)).getYy());
            }
        }
        return mean.divide(new BigDecimal(String.valueOf(list.getNbPosition())), 3);
    }

    public static BigDecimal sqrt(BigDecimal value) {
        double result = Math.sqrt(value.doubleValue());
        return new BigDecimal(result);
    }
}

