/*
 * Decompiled with CFR 0.152.
 */
package Patristic;

import Patristic.Matrix;
import Patristic.Option;
import Patristic.OptionListener;
import Patristic.PlotCoord;
import Patristic.PlotList;
import Patristic.PlotModel;
import Patristic.PlotPanel;
import Patristic.PlotTime;
import Patristic.TableSorter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PrinterJob;
import java.util.EventObject;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import org.freehep.util.export.ExportDialog;

public class PlotFrame
extends JFrame
implements OptionListener,
ItemListener {
    public JSplitPane splitPane;
    public JSplitPane splitPane2;
    private DefaultTableModel model = new DefaultTableModel();
    TableSorter sorter = new TableSorter(this.model);
    private JTable table = new JTable(this.sorter);
    private PlotPanel panel;
    private PlotTime panelTime;
    private JScrollPane scrollPanel;
    private JScrollPane scrollTable = new JScrollPane(this.table);
    private JMenuBar bar = new JMenuBar();
    private JMenu option = new JMenu("Option");
    private JCheckBoxMenuItem stat = new JCheckBoxMenuItem("Stats");
    private JMenuItem optionStat = new JMenuItem("Options");
    private JMenuItem print = new JMenuItem("Print");
    private JCheckBoxMenuItem regress = new JCheckBoxMenuItem("Regression");
    private JCheckBoxMenuItem caption = new JCheckBoxMenuItem("Caption");
    private JMenuItem save = new JMenuItem("Save As");
    private Option optionFrame;
    private boolean isDiffRatio = false;
    private boolean isDiff = false;
    private boolean isCaption = false;
    PlotList list = null;
    private PlotModel plotObject;
    int h;
    int w;
    String[] columnIdentifiers = new String[5];
    boolean plotTime = false;
    JTabbedPane tabbedPane = new JTabbedPane();
    JTextArea info = new JTextArea();

    public PlotFrame(Matrix list1) {
        this.plotTime = true;
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        this.table.addMouseListener(new MyMouseListener());
        Dimension tailleEcran = Toolkit.getDefaultToolkit().getScreenSize();
        this.h = (int)tailleEcran.getHeight();
        this.w = (int)tailleEcran.getWidth();
        this.setSize(this.w, this.h - 30);
        this.setTitle("Time against distance: " + list1.getFileName());
        this.plotObject = new PlotModel(list1);
        this.panelTime = new PlotTime(this.plotObject);
        this.plotObject.addOptionListener(this.panelTime);
        this.plotObject.addOptionListener(this);
        this.list = this.plotObject.getPlotList();
        this.columnIdentifiers[0] = "Name 1";
        this.columnIdentifiers[1] = "Name 2";
        this.columnIdentifiers[2] = "Distance";
        this.columnIdentifiers[3] = "Data difference";
        this.columnIdentifiers[4] = this.plotObject.getFormula();
        this.model.setColumnIdentifiers(this.columnIdentifiers);
        for (int i = 0; i < this.list.getNbPosition(); ++i) {
            String oneI = String.valueOf(((PlotCoord)this.list.getList().elementAt(i)).getXx());
            String twoI = String.valueOf(((PlotCoord)this.list.getList().elementAt(i)).getYy());
            String stat = String.valueOf(((PlotCoord)this.list.getList().elementAt(i)).getStatValue());
            Object[] data = new Object[]{((PlotCoord)this.list.getList().elementAt(i)).getName1(), ((PlotCoord)this.list.getList().elementAt(i)).getName2(), oneI, twoI, stat};
            this.model.insertRow(this.model.getRowCount(), data);
        }
        this.scrollPanel = new JScrollPane(this.panelTime);
        this.table.setAutoResizeMode(0);
        this.layoutMiddle();
    }

    public PlotFrame(Matrix list1, Matrix list2) {
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        this.table.addMouseListener(new MyMouseListener());
        Dimension tailleEcran = Toolkit.getDefaultToolkit().getScreenSize();
        this.h = (int)tailleEcran.getHeight();
        this.w = (int)tailleEcran.getWidth();
        this.setSize(this.w, this.h - 30);
        this.setTitle("Plot " + list1.getFileName() + " against " + list2.getFileName());
        this.plotObject = new PlotModel(list1, list2);
        try {
            this.panel = new PlotPanel(this.plotObject);
        }
        catch (ClassFormatError q) {
            // empty catch block
        }
        this.plotObject.addOptionListener(this.panel);
        this.plotObject.addOptionListener(this);
        this.list = this.plotObject.getPlotList();
        this.columnIdentifiers[0] = "Name 1";
        this.columnIdentifiers[1] = "Name 2";
        this.columnIdentifiers[2] = this.plotObject.getList2().getFileName();
        this.columnIdentifiers[3] = this.plotObject.getList1().getFileName();
        this.columnIdentifiers[4] = this.plotObject.getFormula();
        this.model.setColumnIdentifiers(this.columnIdentifiers);
        for (int i = 0; i < this.list.getNbPosition(); ++i) {
            String twoI = String.valueOf(((PlotCoord)this.list.getList().elementAt(i)).getXx());
            String oneI = String.valueOf(((PlotCoord)this.list.getList().elementAt(i)).getYy());
            String stat = String.valueOf(((PlotCoord)this.list.getList().elementAt(i)).getStatValue());
            Object[] data = new Object[]{((PlotCoord)this.list.getList().elementAt(i)).getName1(), ((PlotCoord)this.list.getList().elementAt(i)).getName2(), oneI, twoI, stat};
            this.model.insertRow(this.model.getRowCount(), data);
        }
        this.scrollPanel = new JScrollPane(this.panel);
        this.table.setAutoResizeMode(0);
        this.layoutMiddle();
    }

    public void clickStat(MouseEvent e) {
        this.optionFrame = new Option(this.plotObject);
        this.optionFrame.setVisible(true);
    }

    private void layoutMiddle() {
        Container pane = this.getContentPane();
        this.bar.add(this.option);
        this.option.add(this.stat);
        this.stat.addItemListener(this);
        this.option.add(this.save);
        this.option.add(this.optionStat);
        this.option.add(this.print);
        this.optionStat.addMouseListener(new MyMouseAdapter(this));
        this.option.add(this.regress);
        this.regress.addItemListener(this);
        this.option.add(this.caption);
        this.caption.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PlotFrame.this.isCaption) {
                    PlotFrame.this.isCaption = false;
                    PlotFrame.this.panel.setCaption(false);
                    PlotFrame.this.caption.setSelected(false);
                } else {
                    PlotFrame.this.isCaption = true;
                    PlotFrame.this.panel.setCaption(true);
                    PlotFrame.this.caption.setSelected(true);
                }
            }
        });
        this.save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExportDialog export = new ExportDialog();
                if (PlotFrame.this.panel != null) {
                    export.showExportDialog(PlotFrame.this.panel, "Save as ...", PlotFrame.this.panel, "export");
                } else {
                    export.showExportDialog(PlotFrame.this.panel, "Save as ...", PlotFrame.this.panelTime, "export");
                }
            }
        });
        this.print.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrinterJob printJob = PrinterJob.getPrinterJob();
                printJob.setPrintable(PlotFrame.this.panel);
                if (printJob.printDialog()) {
                    try {
                        printJob.print();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        pane.add((Component)this.bar, "North");
        JTextArea stat = new JTextArea();
        pane.add((Component)stat, "South");
        this.tabbedPane.add("Distances", this.scrollTable);
        this.tabbedPane.add("Info", this.info);
        this.info.append("Correlation r=" + this.plotObject.getCorrelation() + "\n");
        this.info.append("Slope =" + this.plotObject.getSlope()[0] + "(" + this.plotObject.getSlope()[1] + ")\n");
        this.info.append("Intercept =" + this.plotObject.getIntercept()[0] + "(" + this.plotObject.getIntercept()[1] + ")\n");
        this.info.append("SBL #1= " + this.plotObject.getList1().getSBL().toString() + "\n");
        if (!this.plotTime) {
            this.info.append("SBL #2= " + this.plotObject.getList2().getSBL().toString() + "\n");
            this.info.append("SBL ratio #1/#2 (#2/#1)= " + this.plotObject.getRateMutation().toString() + " (" + this.plotObject.getInvRate().toString() + ")\n");
        }
        this.splitPane = new JSplitPane(1, this.scrollPanel, this.tabbedPane);
        this.splitPane.setDividerLocation(600);
        this.splitPane.setFont(new Font("Courier New", 0, 12));
        this.splitPane.setOneTouchExpandable(true);
        Dimension minimumSize = new Dimension(100, 50);
        this.scrollPanel.setMinimumSize(minimumSize);
        this.scrollTable.setMinimumSize(minimumSize);
        pane.add((Component)this.splitPane, "Center");
    }

    public void itemStateChanged(ItemEvent e) {
        ItemSelectable obj = e.getItemSelectable();
        JCheckBoxMenuItem check = (JCheckBoxMenuItem)obj;
        if (obj == this.stat) {
            if (!check.isSelected()) {
                this.panel.setStat(false);
            } else {
                this.panel.setStat(true);
            }
        } else if (obj == this.regress) {
            if (!check.isSelected()) {
                this.panel.setRegress(false);
            } else {
                this.panel.setRegress(true);
            }
        }
    }

    public PlotList getPlotList() {
        return this.list;
    }

    public void plotChanged(EventObject e) {
        this.columnIdentifiers[4] = this.plotObject.getFormula();
        this.model.setColumnIdentifiers(this.columnIdentifiers);
        for (int i = 0; i < this.list.getNbPosition(); ++i) {
            this.model.setValueAt(((PlotCoord)this.list.getList().elementAt(i)).getStatValue(), i, 4);
            this.model.fireTableCellUpdated(i, 4);
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        PlotFrame adaptee;

        MyMouseAdapter(PlotFrame adaptee) {
            this.adaptee = adaptee;
        }

        public void mousePressed(MouseEvent e) {
            this.adaptee.clickStat(e);
        }
    }

    class MyMouseListener
    implements MouseListener {
        MyMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            JTable target = (JTable)e.getSource();
            int row = target.getSelectedRow();
            String first = (String)PlotFrame.this.table.getValueAt(row, 0);
            String second = (String)PlotFrame.this.table.getValueAt(row, 1);
            if (!PlotFrame.this.plotTime) {
                PlotFrame.this.panel.highLight(first, second);
            } else {
                PlotFrame.this.panelTime.highLight(first, second);
            }
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }
    }
}

