/*
 * Decompiled with CFR 0.152.
 */
package Patristic;

import Patristic.MathStat;
import Patristic.Matrix;
import Patristic.OptionListener;
import Patristic.PlotCoord;
import Patristic.PlotList;
import java.math.BigDecimal;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Stack;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;

public class PlotModel {
    private BigDecimal maxXGraph;
    private BigDecimal maxXReal;
    private BigDecimal maxYGraph;
    private BigDecimal maxYReal;
    private BigDecimal theMax;
    private BigDecimal minXGraph;
    private BigDecimal minXReal;
    private BigDecimal minYGraph;
    private BigDecimal minYReal;
    private BigDecimal unitX;
    private BigDecimal unitY;
    private BigDecimal minNotZeroX;
    private BigDecimal minNotZeroY;
    private BigDecimal rateMutation;
    private BigDecimal invRate;
    private BigDecimal correlation;
    private String formula;
    private String std;
    private String dotSize;
    private Matrix list1;
    private Matrix list2;
    private PlotList plotList;
    private static final int LINELENGTH = 400;
    private static final BigDecimal LINELENGTH_BIG = new BigDecimal(String.valueOf(400));
    private boolean isRegress = false;
    private boolean isCaption = false;
    private EventListenerList listenerList = new EventListenerList();
    BigDecimal maxTime = new BigDecimal("0");
    BigDecimal minTime = new BigDecimal("22222220");
    BigDecimal timeRange = new BigDecimal("0");
    BigDecimal[] slope;
    BigDecimal[] intercept;
    BigDecimal meanStat;
    BigDecimal xStd;

    public PlotModel(Matrix list1, Matrix list2) {
        this.list1 = list1;
        this.list2 = list2;
        this.init();
    }

    public PlotModel(Matrix list1) {
        this.list1 = list1;
        this.list2 = null;
        this.initTime();
    }

    public PlotList getPlotList() {
        return this.plotList;
    }

    public Matrix getList1() {
        return this.list1;
    }

    public Matrix getList2() {
        return this.list2;
    }

    public BigDecimal getCorrelation() {
        return this.correlation;
    }

    public BigDecimal getMaxXReal() {
        return this.maxXReal;
    }

    public BigDecimal getMaxYReal() {
        return this.maxYReal;
    }

    public BigDecimal getMaxTime() {
        return this.maxTime;
    }

    public BigDecimal getTimeRange() {
        return this.timeRange;
    }

    public BigDecimal getMaxXGraph() {
        return this.maxXGraph;
    }

    public BigDecimal getMaxYGraph() {
        return this.maxYGraph;
    }

    public BigDecimal getMinXReal() {
        return this.minXReal;
    }

    public BigDecimal getMinYReal() {
        return this.minYReal;
    }

    public BigDecimal getTheMaxReal() {
        return this.theMax;
    }

    public BigDecimal getMinXGraph() {
        return this.minXGraph;
    }

    public BigDecimal getMinYGraph() {
        return this.minYGraph;
    }

    public BigDecimal getXUnit() {
        return this.unitX;
    }

    public BigDecimal getYUnit() {
        return this.unitY;
    }

    public String getFormula() {
        return this.formula;
    }

    public String getStd() {
        return this.std;
    }

    public String getDotSize() {
        return this.dotSize;
    }

    public BigDecimal getRateMutation() {
        return this.rateMutation;
    }

    public BigDecimal getInvRate() {
        return this.invRate;
    }

    public BigDecimal[] getIntercept() {
        return this.intercept;
    }

    public BigDecimal[] getSlope() {
        return this.slope;
    }

    public BigDecimal getMean() {
        return this.meanStat;
    }

    public BigDecimal getXStd() {
        return this.xStd;
    }

    private void initTime() {
        int i;
        this.plotList = new PlotList();
        BigDecimal sum1 = new BigDecimal("0");
        BigDecimal sum2 = new BigDecimal("0");
        this.theMax = new BigDecimal("0");
        this.maxXReal = new BigDecimal("0");
        this.maxYReal = new BigDecimal("0");
        this.minXReal = new BigDecimal("0");
        this.minYReal = new BigDecimal("0");
        this.minNotZeroX = new BigDecimal("1000");
        this.minNotZeroY = new BigDecimal("1000");
        int population = 0;
        boolean timey = false;
        for (i = 0; i < this.list1.getNames().length; ++i) {
            for (int j = i + 1; j < this.list1.getNames().length; ++j) {
                BigDecimal distance = this.list1.getMatrix()[i][j];
                if (distance.compareTo(this.maxXReal) == 1) {
                    this.maxXReal = distance;
                }
                if (distance.compareTo(this.minXReal) != -1 || distance.compareTo(new BigDecimal("0")) == 0) continue;
                this.minNotZeroX = distance;
            }
        }
        for (i = 0; i < this.list1.getDate().length; ++i) {
            if (new BigDecimal(this.list1.getDate()[i]).compareTo(this.maxTime) == 1) {
                this.maxTime = new BigDecimal(this.list1.getDate()[i]);
            }
            if (new BigDecimal(this.list1.getDate()[i]).compareTo(this.minTime) != -1) continue;
            this.minTime = new BigDecimal(this.list1.getDate()[i]);
        }
        this.timeRange = this.maxTime.subtract(this.minTime);
        this.maxXGraph = this.maxXReal;
        this.minXGraph = this.minXReal;
        this.unitX = new BigDecimal("0");
        this.unitY = new BigDecimal("0");
        this.formula = "(x-y)";
        this.std = "3";
        this.dotSize = "3";
        BigDecimal sumStat = new BigDecimal("0");
        int pos = 0;
        for (int i2 = 0; i2 < this.list1.getNames().length; ++i2) {
            for (int j = i2 + 1; j < this.list1.getNames().length; ++j) {
                BigDecimal date2;
                BigDecimal distance = this.list1.getMatrix()[i2][j];
                ++population;
                sum1 = sum1.add(distance);
                String name1 = this.list1.getNames()[i2];
                String name2 = this.list1.getNames()[j];
                int one = 0;
                int two = 0;
                for (int k = 0; k < this.list1.getNames().length; ++k) {
                    if (name1.compareTo(this.list1.getNames()[k]) == 0) {
                        one = k;
                    }
                    if (name2.compareTo(this.list1.getNames()[k]) != 0) continue;
                    two = k;
                }
                BigDecimal date1 = new BigDecimal(this.list1.getDate()[one]);
                BigDecimal dateDiff = date1.subtract(date2 = new BigDecimal(this.list1.getDate()[two]));
                if (dateDiff.compareTo(new BigDecimal("0")) == -1) {
                    dateDiff = new BigDecimal("-1").multiply(dateDiff);
                }
                if (dateDiff.compareTo(this.minYReal) == -1 && dateDiff.compareTo(new BigDecimal("0")) != 0) {
                    this.minNotZeroY = dateDiff;
                }
                if (dateDiff.compareTo(this.maxYReal) == 1) {
                    this.maxYReal = dateDiff;
                }
                sum2 = sum2.add(dateDiff);
                BigDecimal dateDiffPlot = dateDiff.multiply(LINELENGTH_BIG);
                dateDiffPlot = dateDiffPlot.divide(this.timeRange, 1);
                int dateDiffPlotInt = dateDiffPlot.intValue();
                BigDecimal distancePlot = distance.multiply(LINELENGTH_BIG);
                distancePlot = distancePlot.divide(this.maxXReal, 1);
                int distancePlotInt = distancePlot.intValue();
                this.plotList.add(name1, name2, distancePlotInt, dateDiffPlotInt, distance, dateDiff);
                BigDecimal stat = new BigDecimal(this.computeEach(this.formula, distance, dateDiff));
                sumStat = sumStat.add(stat);
                ((PlotCoord)this.plotList.getList().elementAt(pos)).setStatValue(stat);
                ++pos;
            }
        }
        this.maxYGraph = this.maxYReal;
        this.minYGraph = this.minYReal;
        BigDecimal mean1 = MathStat.mean(sum1, population);
        BigDecimal mean2 = MathStat.mean(sum2, population);
        this.correlation = MathStat.correlation(this.plotList, mean1, mean2);
        this.meanStat = MathStat.mean(sumStat, this.plotList.getNbPosition());
        this.xStd = MathStat.stdDev(this.plotList, this.meanStat).multiply(new BigDecimal(this.std));
        this.slope = MathStat.slope(this.plotList);
        this.intercept = MathStat.intercept(this.plotList, this.slope);
    }

    private void init() {
        this.plotList = new PlotList();
        BigDecimal[][] matrix1 = this.list1.getMatrix();
        BigDecimal[][] matrix2 = this.list2.getMatrix();
        this.reorder();
        matrix2 = this.list2.getMatrix();
        int population = 0;
        this.theMax = new BigDecimal("0");
        this.maxXReal = new BigDecimal("0");
        this.maxYReal = new BigDecimal("0");
        this.minXReal = new BigDecimal("0");
        this.minYReal = new BigDecimal("0");
        this.minNotZeroX = new BigDecimal("1000");
        this.minNotZeroY = new BigDecimal("1000");
        BigDecimal sum1 = new BigDecimal("0");
        BigDecimal sum2 = new BigDecimal("0");
        for (int i = 0; i < this.list1.getNames().length; ++i) {
            for (int j = i + 1; j < this.list1.getNames().length; ++j) {
                BigDecimal one = matrix1[i][j];
                BigDecimal two = matrix2[i][j];
                ++population;
                if (one.compareTo(this.maxXReal) == 1) {
                    this.maxXReal = one;
                }
                if (two.compareTo(this.maxYReal) == 1) {
                    this.maxYReal = two;
                }
                if (one.compareTo(this.minNotZeroX) == -1 && one.compareTo(new BigDecimal("0")) != 0) {
                    this.minNotZeroX = one;
                }
                if (two.compareTo(this.minNotZeroY) == -1 && two.compareTo(new BigDecimal("0")) != 0) {
                    this.minNotZeroY = two;
                }
                sum1 = sum1.add(one);
                sum2 = sum2.add(two);
            }
        }
        this.minXGraph = this.minXReal;
        this.minYGraph = this.minYReal;
        this.theMax = this.maxXReal.compareTo(this.maxYReal) == 1 ? this.maxXReal : this.maxYReal;
        this.maxXGraph = this.theMax;
        this.maxYGraph = this.theMax;
        this.unitX = new BigDecimal("0");
        this.unitY = new BigDecimal("0");
        this.formula = "(x-y)";
        this.std = "3";
        this.dotSize = "3";
        BigDecimal mean1 = MathStat.mean(sum1, population);
        BigDecimal mean2 = MathStat.mean(sum2, population);
        this.correlation = MathStat.correlation(this.list1, this.list2, mean1, mean2);
        BigDecimal sbl1 = this.list1.getSBL();
        BigDecimal sbl2 = this.list2.getSBL();
        this.rateMutation = sbl1.divide(sbl2, 3, 3);
        this.invRate = new BigDecimal(1.0).divide(sbl1.divide(sbl2, 3), 3, 3);
        int pos = 0;
        BigDecimal sumStat = new BigDecimal("0");
        for (int i = 0; i < this.list1.getNames().length; ++i) {
            for (int j = i + 1; j < this.list1.getNames().length; ++j) {
                BigDecimal oneBig = matrix1[i][j];
                BigDecimal twoBig = matrix2[i][j];
                String name1 = this.list1.getNames()[i];
                String name2 = this.list1.getNames()[j];
                BigDecimal stat = new BigDecimal(this.computeEach(this.formula, oneBig, twoBig));
                sumStat = sumStat.add(stat);
                BigDecimal two = twoBig.multiply(LINELENGTH_BIG);
                two = two.divide(this.theMax, 1);
                BigDecimal one = oneBig.multiply(LINELENGTH_BIG);
                one = one.divide(this.theMax, 1);
                int oneI = one.intValue();
                int twoI = two.intValue();
                this.plotList.add(name1, name2, oneI, twoI, oneBig, twoBig);
                ((PlotCoord)this.plotList.getList().elementAt(pos)).setStatValue(stat);
                ++pos;
            }
        }
        this.meanStat = MathStat.mean(sumStat, this.plotList.getNbPosition());
        this.xStd = MathStat.stdDev(this.plotList, this.meanStat).multiply(new BigDecimal(this.std));
        this.slope = MathStat.slope(this.plotList);
        this.intercept = MathStat.intercept(this.plotList, this.slope);
    }

    private void alterCoordinates() {
        int pos = 0;
        if (this.list2 == null) {
            for (int i = 0; i < this.list1.getNames().length; ++i) {
                for (int j = i + 1; j < this.list1.getNames().length; ++j) {
                    BigDecimal date2;
                    String name1 = this.list1.getNames()[i];
                    String name2 = this.list1.getNames()[j];
                    int one = 0;
                    int two = 0;
                    for (int k = 0; k < this.list1.getNames().length; ++k) {
                        if (name1.compareTo(this.list1.getNames()[k]) == 0) {
                            one = k;
                        }
                        if (name2.compareTo(this.list1.getNames()[k]) != 0) continue;
                        two = k;
                    }
                    BigDecimal distance = this.list1.getMatrix()[i][j];
                    BigDecimal date1 = new BigDecimal(this.list1.getDate()[one]);
                    BigDecimal dateDiff = date1.subtract(date2 = new BigDecimal(this.list1.getDate()[two]));
                    if (dateDiff.compareTo(new BigDecimal("0")) == -1) {
                        dateDiff = new BigDecimal("-1").multiply(dateDiff);
                    }
                    if (distance.compareTo(this.maxXGraph) == 1 || distance.compareTo(this.minXGraph) == -1 || dateDiff.compareTo(this.maxYGraph) == 1 || dateDiff.compareTo(this.minYGraph) == -1) {
                        ((PlotCoord)this.plotList.getList().elementAt(pos)).setX(-1);
                        ((PlotCoord)this.plotList.getList().elementAt(pos)).setY(-1);
                    } else {
                        distance = distance.subtract(this.minXGraph);
                        BigDecimal distancePlot = distance.multiply(LINELENGTH_BIG);
                        BigDecimal maxminX = this.maxXGraph.subtract(this.minXGraph);
                        distancePlot = distancePlot.divide(maxminX, 1);
                        int distancePlotInt = distancePlot.intValue();
                        BigDecimal dateDiffPlot = dateDiff.subtract(this.minYGraph);
                        dateDiffPlot = dateDiffPlot.multiply(LINELENGTH_BIG);
                        BigDecimal maxminY = this.maxYGraph.subtract(this.minYGraph);
                        dateDiffPlot = dateDiffPlot.divide(maxminY, 1);
                        ((PlotCoord)this.plotList.getList().elementAt(pos)).setX(distancePlotInt);
                        ((PlotCoord)this.plotList.getList().elementAt(pos)).setY(dateDiffPlot.intValue());
                    }
                    ++pos;
                }
            }
        } else {
            for (int i = 0; i < this.list1.getNames().length; ++i) {
                for (int j = i + 1; j < this.list1.getNames().length; ++j) {
                    BigDecimal[][] matrix1 = this.list1.getMatrix();
                    BigDecimal[][] matrix2 = this.list2.getMatrix();
                    BigDecimal one = matrix1[i][j];
                    BigDecimal two = matrix2[i][j];
                    if (one.compareTo(this.maxXGraph) == 1 || one.compareTo(this.minXGraph) == -1 || two.compareTo(this.maxYGraph) == 1 || two.compareTo(this.minYGraph) == -1) {
                        ((PlotCoord)this.plotList.getList().elementAt(pos)).setX(-1);
                        ((PlotCoord)this.plotList.getList().elementAt(pos)).setY(-1);
                    } else {
                        one = one.subtract(this.minXGraph);
                        one = one.multiply(LINELENGTH_BIG);
                        BigDecimal maxMinX = this.maxXGraph.subtract(this.minXGraph);
                        one = one.divide(maxMinX, 1);
                        two = two.subtract(this.minYGraph);
                        two = two.multiply(LINELENGTH_BIG);
                        BigDecimal maxMinY = this.maxYGraph.subtract(this.minYGraph);
                        two = two.divide(maxMinY, 1);
                        int oneI = one.intValue();
                        int twoI = two.intValue();
                        ((PlotCoord)this.plotList.getList().elementAt(pos)).setX(oneI);
                        ((PlotCoord)this.plotList.getList().elementAt(pos)).setY(twoI);
                    }
                    ++pos;
                }
            }
        }
    }

    private void reorder() {
        int result;
        String[] names1 = this.list1.getNames();
        String[] names2 = this.list2.getNames();
        BigDecimal[][] temp = new BigDecimal[names1.length][names1.length];
        BigDecimal[][] temp2 = new BigDecimal[names1.length][names1.length];
        boolean diff = false;
        boolean doOrder = false;
        for (int i = 0; i < names1.length; ++i) {
            if (names1[i].equals(names2[i])) continue;
            diff = true;
            break;
        }
        if (diff && (result = JOptionPane.showConfirmDialog(null, "Do you need to reorder the data?", "", 0)) == 0) {
            doOrder = true;
        }
        if (doOrder) {
            this.list2 = this.list2.reOrder(names1);
        }
    }

    public void updateScaleX(BigDecimal maxGraph, BigDecimal minGraph, BigDecimal unit) {
        this.maxXGraph = maxGraph;
        this.minXGraph = minGraph;
        this.unitX = unit;
    }

    public void updateScaleY(BigDecimal maxGraph, BigDecimal minGraph, BigDecimal unit) {
        this.maxYGraph = maxGraph;
        this.minYGraph = minGraph;
        this.unitY = unit;
        this.alterCoordinates();
    }

    public void updateFormula(String formula) {
        this.formula = formula;
        BigDecimal sumStat = new BigDecimal("0");
        for (int i = 0; i < this.plotList.getNbPosition(); ++i) {
            BigDecimal one = ((PlotCoord)this.plotList.getList().elementAt(i)).getXx();
            BigDecimal two = ((PlotCoord)this.plotList.getList().elementAt(i)).getYy();
            if (two == null) {
                two = ((PlotCoord)this.plotList.getList().elementAt(i)).getYy();
            }
            BigDecimal stat = new BigDecimal(this.computeEach(formula, one, two));
            sumStat = sumStat.add(stat);
            ((PlotCoord)this.plotList.getList().elementAt(i)).setStatValue(stat);
        }
        this.meanStat = MathStat.mean(sumStat, this.plotList.getNbPosition());
        this.xStd = MathStat.stdDev(this.plotList, this.meanStat).multiply(new BigDecimal(this.std));
    }

    public void updateSTD(String std) {
        this.std = std;
        this.xStd = MathStat.stdDev(this.plotList, this.meanStat).multiply(new BigDecimal(std));
    }

    public void updateProperties(String dotSize) {
        this.dotSize = dotSize;
    }

    private String computeEach(String str, BigDecimal one, BigDecimal two) {
        Stack<String> stack = new Stack<String>();
        for (int j = 0; j < str.length(); ++j) {
            String car = str.substring(j, j + 1);
            BigDecimal ft = new BigDecimal("-1");
            BigDecimal sd = new BigDecimal("-1");
            String op = "";
            String top = "";
            if (!car.equals(")")) {
                stack.push(car);
                continue;
            }
            while (!(top = (String)stack.pop()).equals("(")) {
                if (top.equals("+") || top.equals("-") || top.equals("*") || top.equals("/")) {
                    op = top;
                    continue;
                }
                if (top.equals("x")) {
                    if (ft.equals(new BigDecimal("-1"))) {
                        ft = one;
                        continue;
                    }
                    sd = one;
                    continue;
                }
                if (top.equals("y")) {
                    if (ft.equals(new BigDecimal("-1"))) {
                        ft = two;
                        continue;
                    }
                    sd = two;
                    continue;
                }
                if (ft.equals(new BigDecimal("-1"))) {
                    ft = new BigDecimal(top);
                    continue;
                }
                sd = new BigDecimal(top);
            }
            if (op.equals("+")) {
                stack.push(ft.add(sd).toString());
                continue;
            }
            if (op.equals("-")) {
                stack.push(ft.subtract(sd).toString());
                continue;
            }
            if (op.equals("*")) {
                stack.push(ft.multiply(sd).toString());
                continue;
            }
            if (!op.equals("/")) continue;
            if (sd.compareTo(new BigDecimal("0")) == 0) {
                sd = new BigDecimal("0.000001");
            }
            System.out.println(sd);
            stack.push(ft.divide(sd, 3).toString());
        }
        String result = stack.pop().toString();
        return result;
    }

    public void addOptionListener(OptionListener l) {
        this.listenerList.add(OptionListener.class, l);
    }

    public void fireUpdated() {
        this.fireChanged(new EventObject(this));
    }

    public void fireChanged(EventObject e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$Patristic$OptionListener == null ? PlotModel.class$("Patristic.OptionListener") : class$Patristic$OptionListener)) continue;
            ((OptionListener)listeners[i + 1]).plotChanged(e);
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    private void debug() {
        System.out.println("---------------------------------------------------");
        System.out.println("GRAPH MAX X: " + this.maxXGraph + " MAX Y: " + this.maxYGraph);
        System.out.println("GRAPH MIN X: " + this.minXGraph + " MIN Y: " + this.minYGraph);
        System.out.println("REAL MAX X: " + this.maxXReal + " MAX Y: " + this.maxYReal);
        System.out.println("REAL MIN X: " + this.minXReal + " MIN Y: " + this.minYReal);
        System.out.println("THE MAX: " + this.theMax);
    }
}

