/*
 * Decompiled with CFR 0.152.
 */
package Patristic;

public class Tree {
    private Node root = null;
    private Node currentNode = null;
    private Node newRoot = null;

    public static void main(String[] args) {
        new Tree();
    }

    public Tree() {
        String tree = "(1,(2,(((3,5),(6,7)),4)))";
        int nbNode = 0;
        Node dad = null;
        for (int i = 0; i < tree.length(); ++i) {
            String str = tree.substring(i, i + 1);
            if (str.equals("(")) {
                dad = this.currentNode;
                Node newNode = new Node(this.currentNode);
                if (this.root != null) {
                    this.currentNode.setKid(newNode);
                    System.out.println("kids pointet " + this.currentNode.getKid()[0] + " " + this.currentNode.getKid()[1]);
                } else {
                    this.root = newNode;
                }
                this.currentNode = newNode;
                ++nbNode;
                continue;
            }
            if (str.equals(":")) continue;
            if (str.equals(")")) {
                this.currentNode = this.currentNode.getDaddy();
                continue;
            }
            if (str.equals(",")) continue;
            if (str.equals("2")) {
                this.newRoot = this.currentNode;
            }
            this.currentNode.setTaxon(str);
            System.out.println("TAXON " + str + " REFERENCE " + this.currentNode + " DADDY " + dad);
        }
        System.out.println("number node " + nbNode);
        System.out.println("ROOT REFERENCE " + this.root);
        this.preOrder();
        this.reroot();
        System.out.println("NEW ROOT REFERENCE " + this.root);
        this.preOrder();
    }

    public void reroot() {
        Node dads = this.newRoot.getDaddy();
        System.out.println();
        System.out.println("new root " + this.newRoot);
        System.out.println("daddy " + dads);
        dads.resetKid();
        this.newRoot.setKid();
        this.root = this.newRoot;
    }

    private void preOrder() {
        this.preOrder(this.root);
    }

    private void preOrder(Node nody) {
        if (nody != null) {
            System.out.print("(");
            String[] listTaxon = nody.getTaxon();
            System.out.print(nody.getTaxon()[0] + "," + nody.getTaxon()[1] + " ");
            this.preOrder(nody.right);
            System.out.print(",");
            this.preOrder(nody.left);
            System.out.print(")");
        }
    }

    public boolean lookup(int data) {
        return this.lookup(this.root, data);
    }

    private boolean lookup(Node node, int data) {
        if (node == null) {
            return false;
        }
        if (data == node.data) {
            return true;
        }
        if (data < node.data) {
            return this.lookup(node.left, data);
        }
        return this.lookup(node.right, data);
    }

    public void insert(int data) {
        this.root = this.insert(this.root, data);
    }

    private Node insert(Node node, int data) {
        if (node == null) {
            node = new Node(data);
        } else if (data <= node.data) {
            node.left = this.insert(node.left, data);
        } else {
            node.right = this.insert(node.right, data);
        }
        return node;
    }

    private static class Node
    implements Cloneable {
        Node left;
        Node right;
        Node nodeParent;
        int data;
        String taxon1 = "";
        String taxon2 = "";
        String branchLength = "";
        String branchLength2 = "";

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        Node(int newData) {
            this.left = null;
            this.right = null;
            this.data = newData;
        }

        Node(Node parent) {
            this("", "", null, null, parent);
        }

        Node(String taxon, String branchLength) {
            this(taxon, branchLength, null, null, null);
        }

        Node(String taxon, String branchLength, Node node1, Node node2, Node nodeParent) {
            this.left = node1;
            this.right = node2;
            this.nodeParent = nodeParent;
            this.taxon1 = taxon;
            this.branchLength = branchLength;
        }

        public void addTaxon(String taxon) {
            this.taxon1 = taxon;
        }

        public String[] getTaxon() {
            String[] list = new String[]{this.taxon1, this.taxon2};
            return list;
        }

        public Node[] getKid() {
            Node[] list = new Node[]{this.left, this.right};
            return list;
        }

        public void setKid(Node kidNode) {
            if (this.left == null && this.right == null) {
                this.left = kidNode;
            } else if (this.right == null) {
                this.right = kidNode;
            } else {
                System.out.println("left and right already full");
            }
        }

        public void setTaxon(String tax) {
            if (this.taxon1.equals("")) {
                this.taxon1 = tax;
            } else if (this.taxon2.equals("")) {
                this.taxon2 = tax;
            } else {
                System.out.println("left and right already full");
            }
        }

        public Node getDaddy() {
            return this.nodeParent;
        }

        public void setDaddy(Node daddy) {
            this.nodeParent = daddy;
        }

        public void resetParentReference(Node daddy) {
            if (this.left.equals(daddy)) {
                System.out.println("daddy left " + this.left);
                this.left = null;
            }
            if (this.right.equals(daddy)) {
                System.out.println("daddy right " + this.right);
                this.right = null;
                System.out.println("daddy right " + this.right);
            }
        }

        public void resetKid() {
            this.left = null;
            this.right = null;
        }

        public void setKid() {
            this.right = this.nodeParent;
            System.out.println("SETKID " + this.right);
        }
    }
}

