/*
 *   Patristic is a Java program that uses as input different tree files
 *   and computes their patristic distances.
 *   Copyright (C) 2005 M Fourment
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package Patristic;

import java.io.*;
import java.util.Calendar;
import javax.swing.JFileChooser;
import Time.TimeManager;
import Process.Process;

/**
 *
 * @author  formmat
 */
public class CutterFrame extends javax.swing.JFrame implements java.awt.event.ActionListener{
    
    /*String[] MyML={"nj;\r\n",
            "set criterion=like;\r\n",
            "lscores 1/nst=6  basefreq=est rmatrix=estimate rates=gamma  shape=est pinv=est;\r\n",
            "lset nst=6  basefreq=previous rmatrix=previous rates=gamma  shape=previous pinv=previous;\r\n",
            "lscores 1/nst=6  basefreq=est rmatrix=estimate rates=gamma  shape=est pinv=est;\r\n",
            "lset nst=6  basefreq=previous rmatrix=previous rates=gamma  shape=previous pinv=previous;\r\n"};*/
    String[] MyML={"nj;\r\n",
                "set criterion=like;\r\n",
                "lscores 1/nst=6  basefreq=est rmatrix=estimate rates=gamma  shape=est pinv=est;\r\n",
                "lset nst=6  basefreq=previous rmatrix=previous rates=gamma  shape=previous pinv=previous;\r\n",
                "hs swap=nni;\r\n"};
            
            String NJ="nj;\r\n";
            Process p;
            int pid;
            
            /** Creates new form CutterFrame */
            public CutterFrame() {
                initComponents();
                commandCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "MyML", "NJ" }));
                commandCombo.addActionListener(this);
                setSize(300, 400);
                setTitle("Cutter");
            }
            
            /** This method is called from within the constructor to
             * initialize the form.
             * WARNING: Do NOT modify this code. The content of this method is
             * always regenerated by the Form Editor.
             */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jPanel2 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        winLabel = new javax.swing.JLabel();
        winField = new javax.swing.JTextField();
        stepLabel = new javax.swing.JLabel();
        stepField = new javax.swing.JTextField();
        openButton = new javax.swing.JButton();
        openField = new javax.swing.JTextField();
        commandLabel = new javax.swing.JLabel();
        commandCombo = new javax.swing.JComboBox();
        cmdText = new javax.swing.JTextArea();
        jPanel1 = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        jPanel2.setLayout(new java.awt.BorderLayout());

        jPanel4.setLayout(new java.awt.GridLayout(4, 2));

        winLabel.setText("Window size");
        jPanel4.add(winLabel);

        winField.setText("100");
        jPanel4.add(winField);

        stepLabel.setText("Step size");
        jPanel4.add(stepLabel);

        stepField.setText("50");
        jPanel4.add(stepField);

        openButton.setText("Open");
        openButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                openButtonActionPerformed(evt);
            }
        });

        jPanel4.add(openButton);

        jPanel4.add(openField);

        commandLabel.setText("Command");
        jPanel4.add(commandLabel);

        jPanel4.add(commandCombo);

        jPanel2.add(jPanel4, java.awt.BorderLayout.NORTH);

        jPanel2.add(cmdText, java.awt.BorderLayout.CENTER);

        getContentPane().add(jPanel2, java.awt.BorderLayout.CENTER);

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        jPanel1.add(okButton);

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        jPanel1.add(cancelButton);

        getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);

        pack();
    }
    // </editor-fold>//GEN-END:initComponents
    
    private void openButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_openButtonActionPerformed
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File("."));
        int returnVal =  chooser.showSaveDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            openField.setText(chooser.getSelectedFile().toString());
        }
    }//GEN-LAST:event_openButtonActionPerformed
    
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        if(p.isAlive(pid)==1)p.kill(pid);
        System.exit(0);
    }//GEN-LAST:event_cancelButtonActionPerformed
    
    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        int win=Integer.valueOf(winField.getText()).intValue();
        int step=Integer.valueOf(stepField.getText()).intValue();
        String open=openField.getText();
        String cmd=cmdText.getText();
        new Cutter(open,win,step,cmd).createCmd();
//        short month=04;
//        short day=05;
//        int year=1999;
//        Calendar rightNow = Calendar.getInstance();
//        int yearNow=rightNow.get(Calendar.YEAR);
//        short monthNow=(short)(rightNow.get(Calendar.MONTH)+1);
//        short dayNow=(short)rightNow.get(Calendar.DATE);
//        TimeManager manager=new TimeManager();
//        manager.changeTime(1999,month,day);
//        
//        String fileSeparator = System.getProperty("file.separator");
//        String  fileName=open.substring(open.lastIndexOf(fileSeparator)+1);
//        final String f="C:\\Documents and Settings\\formmat\\Desktop\\Patristic\\PAUP4B2A.exe nexus.cmd";
//        p=new Process();
//        pid=p.exec(f);
//        System.out.println("PID:"+pid);
//        try{
//            Thread.sleep(2000);
//        } catch(InterruptedException e){}
//        System.out.println("IsAlive: "+p.isAlive(pid));
//        manager.changeTime(yearNow,monthNow,dayNow);
//        new File("nexus.cmd").delete();
    }//GEN-LAST:event_okButtonActionPerformed
    
    public void actionPerformed(java.awt.event.ActionEvent e) {
        Object source = e.getSource();
        if (source == commandCombo) {
            String what = (String)commandCombo.getSelectedItem();
            if(what.equals("MyML")){
                cmdText.setText("");
                for(int i=0;i<MyML.length;i++)
                    cmdText.append(MyML[i]);
            } else if(what.equals("NJ")){
                cmdText.setText(NJ);
            }
        }
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                CutterFrame cutter=new CutterFrame();
                cutter.setVisible(true);
                
            }
        });
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JTextArea cmdText;
    private javax.swing.JComboBox commandCombo;
    private javax.swing.JLabel commandLabel;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JButton okButton;
    private javax.swing.JButton openButton;
    private javax.swing.JTextField openField;
    private javax.swing.JTextField stepField;
    private javax.swing.JLabel stepLabel;
    private javax.swing.JTextField winField;
    private javax.swing.JLabel winLabel;
    // End of variables declaration//GEN-END:variables
    
}
