/*
 *   Patristic is a Java program that uses as input different tree files
 *   and computes their patristic distances.
 *   Copyright (C) 2005 M Fourment
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *
 * @author  Fourment Mathieu
 */
package Patristic;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;
import javax.swing.text.*;
import javax.swing.table.TableColumn;
import javax.swing.table.*;
import java.math.BigDecimal;

/**
 * GUI used for the graphic display of the results
 */

public class FrameMatrix extends JFrame {
    public JScrollPane scroll;
    private JTextPane textPane =new JTextPane();
    String[][] data;
    String[] columnNames;
    JTable table;
    int rowFrom;
    int rowTo;
    int columnFrom;
    int columnTo;
    Matrix localList;
    
    /** Creates a new instance of Diagram */
    public FrameMatrix(Matrix list){
        localList=list;
        setSize(600,400);
        this.setResizable(true);
        setTitle("Patristic distances: "+list.getFileName()+" (SBL:"+list.getSBL()+")");
        Container pane = this.getContentPane();
        columnNames=new String[list.getNames().length+1];
        columnNames[0]="";
        for(int i=0;i<list.getNames().length;i++){
            columnNames[i+1]=list.getNames()[i];
        }
        
        table = new JTable(list.toArray(), columnNames);
        table.getTableHeader().setReorderingAllowed(false);
        table.setModel(new DefaultTableModel(list.toArray(), columnNames));
        table.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(MouseEvent evt) {
                tableMouseReleased(evt);
            }
        });
        table.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(MouseEvent evt) {
                tableMousePressed(evt);
            }
        });
        table.getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        
        table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        scroll = new JScrollPane(table);
        pane.add(scroll,"Center");
        
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                changeMatrix();
            }
        });
    }
    private void changeMatrix(){
        localList.setMatrix(toSimpleMatrix());
    }
    private void tableMousePressed(MouseEvent evt) {
        rowFrom = table.rowAtPoint(evt.getPoint());
    }
    
    private void tableMouseReleased(MouseEvent evt) {
        rowTo = table.rowAtPoint(evt.getPoint());
        columnTo = table.columnAtPoint(evt.getPoint());
        if(rowTo!=rowFrom && rowTo>-1 && rowTo<table.getRowCount()){
            ((DefaultTableModel)table.getModel()).moveRow(rowFrom, rowFrom, rowTo);
            table.moveColumn(rowFrom+1, rowTo+1);            
            rowFrom=rowTo;
        }
    }
    
    private BigDecimal[][] toSimpleMatrix(){
        BigDecimal [][] temp = new BigDecimal[columnNames.length-1][columnNames.length-1];
        BigDecimal [][] temp2 = new BigDecimal[columnNames.length-1][columnNames.length-1];
        String[] newOrderName=new String[columnNames.length-1];
        String[] tempDate=new String[columnNames.length-1];
        
        
        for(int j=0;j<columnNames.length-1;j++){
            newOrderName[j]=((DefaultTableModel)table.getModel()).getValueAt(j,0).toString();
        }
        
        for(int i=0;i<columnNames.length-1;i++){
            for(int j=1;j<columnNames.length;j++){
                temp[i][j-1]= new BigDecimal(((DefaultTableModel)table.getModel()).getValueAt(i,j).toString());
            }
        }
        
        for(int j=0;j<newOrderName.length;j++){
            for(int x=0;x<localList.getNames().length;x++){
                if(newOrderName[j].equals(localList.getNames()[x])){
                    for(int i=0;i<localList.getNames().length;i++) temp2[i][j]=temp[i][x];
                    break;
                }
            }
        }
        
        // Reorder time
        for(int j=0;j<newOrderName.length;j++){
            if(newOrderName[j].equals(localList.getNames()[j])) tempDate[j]=localList.getDate()[j];
            else{
                for(int u=0;u<newOrderName.length;u++){
                    if(newOrderName[j].equals(localList.getNames()[u])){
                        tempDate[j]=localList.getDate()[u];
                        break;
                    }
                }
            }
            System.out.println(tempDate[j]);
        }
        localList.setDate(tempDate);
        
        localList.setNames(newOrderName);
        return temp2;
    }
}

