/*
 *   Patristic is a Java program that uses as input different tree files
 *   and computes their patristic distances.
 *   Copyright (C) 2005 M Fourment
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *
 * @author  Fourment Mathieu
 */
package Patristic;
import java.io.*;
import javax.swing.*;
import java.util.*;
import java.util.regex.*;

/**
 * Open a file and create an header and keep only the sequence
 */
public class Opener{
    private String path;
    private String text="";
    private String line;
    private int nbTip=0;
    private int length;
    private Vector array;
    private String[] name;
    private Vector treeList=new Vector();
    
    boolean nexus=false;
    final String SPACE = "[ \t\f\n\r]+";
    //final String SPACES = "[ \t\f\n\r]*";
    
    //    Pattern pattern = Pattern.compile("^tree");
    //    Matcher matcher = pattern.matcher("");
    
    Pattern pattern = Pattern.compile("tree");
    Matcher matcher = pattern.matcher("");
    //    Pattern pBracket = Pattern.compile("^[");
    //    Matcher mBracket = pBracket.matcher("");
    
    Pattern pattern1 = Pattern.compile("=");
    Matcher matcher1 = pattern1.matcher("");
    
    /** Creates a new instance of Opener */
    public Opener(String path) {
        this.path=path;
    }
    
    public boolean isNexus(){
        return nexus;
    }
    // Carry on the action
    public String getText(){
        try{
            BufferedReader in = new BufferedReader(new FileReader(path));
            line=in.readLine();
            if(line.compareTo("(")==0){
                loadPh(in);
            }
            else if(line.substring(0,1).compareTo("[")==0){
                line=line.substring(line.indexOf("]")+1,line.length());
                loadPh(in);
            }
            else
                if(line.startsWith("#NEXUS")){
                    nexus=true;
                    loadNexus(in);
                }
                else{
                    loadPh(in);
                }
            in.close();
        }
        catch (IOException err) {System.out.println("IO "+err.getMessage());}
        catch (NullPointerException err) {err.printStackTrace();}
        
        return text;
    }
    
    private void loadPh(BufferedReader in) throws IOException{
        boolean eof=false;
        text+=line;
        while(!eof){
            line=in.readLine();
            if(line==null)eof=true;
            else text+=line;
        }
    }
    
    // Load a Nexus
    private void loadNexus(BufferedReader in) throws IOException{
        boolean eof=false;
        boolean translateFlag=false;
        boolean treeFlag=false;
        array=new Vector();
        length=0;
        //System.out.println("sasasasas");
        //        final String TREE = "tree PAUP_1 = [&U]";
        //        final String TRANS = "\\t\\tTranslate";
        //        final String ENDNAMES = "\\t*;";
        //final String SPACE = "[ \t\f\n\r]+";
        
        while(!eof){
            String line = in.readLine();
            String lline=line.toLowerCase();
            matcher.reset(lline);
            matcher1.reset(lline);
            if(lline.matches("^end;")) break;
            if (matcher.find() && matcher1.find() && treeFlag) {
                int pos=0;
                String charr="z";
                while(charr.compareTo("(")!=0){
                    charr=line.substring(pos,pos+1);
                    pos++;
                }
                pos--;
                text = line.substring(pos,line.length());
                treeList.add(text);
                //eof=true;
            }
            else if(lline.matches("\ttranslate")){
                translateFlag=true;
            }
            else if(line.matches("\t*;") && translateFlag==true){
                translateFlag=false;
                treeFlag=true;
            }
            else if(translateFlag){
                length++;
                String str;
                str=line.split(SPACE)[2];
                if(str.substring(str.length()-1).equals(","))
                    array.add(str.substring(0,str.length()-1));
                else array.add(str);
            }
        }
    }
    
    public String[] getName(int length){
        if(nexus){
            name=new String[length];
            for(int i=0;i<length;i++) name[i]= (String)array.elementAt(i);
        }
        else{
            name=new String[length];
            for(int i=0;i<length;i++) name[i]= String.valueOf(i+1);
        }
        return name;
    }
    
    public Vector getTreeList(){
        return treeList;
    }
    
}
