/*
 *   Patristic is a Java program that uses as input different tree files
 *   and computes their patristic distances.
 *   Copyright (C) 2005 M Fourment
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *
 * @author  Fourment Mathieu
 */
 
 package Patristic;
 
   import java.awt.*;
   import java.awt.event.*;
   import javax.swing.*;
   import javax.swing.event.*;
   import java.util.*;
   import java.lang.*;
   import java.math.BigDecimal;
/**
 * Graphic representation of the results
 */
public class Distribution extends JPanel {
    
    private static final int XLEFT=10;
    private static final int LINELENGTH=280;
    private static final int WIDTHLINE=2;    
    private PlotList list;
    int valueX;
    int valueY;
    String infoEvent;
    BigDecimal max;
    BigDecimal min;
    int maxBeam=0;
    int mean;
    int std;
    int length;
    int size=0;
    
    /** Creates a new instance of DiagramPanel */
    //public DiagramPanel(PositionList matchList, PositionList mismatchList,String motif,int length) {
    public Distribution(PlotList list, int size) {
        this.list=list;
        this.size=size;        
    }
    
    
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        setBackground(Color.WHITE);
        g.setColor(Color.BLACK);
        g.setFont(new Font("Courier New",Font.BOLD,12));        
        g.fillRect(XLEFT,XLEFT,WIDTHLINE,LINELENGTH);//y axis
        g.fillRect(XLEFT,XLEFT+LINELENGTH,LINELENGTH,WIDTHLINE);//x axis
        g.drawString("nb",XLEFT-3,XLEFT-4);
        g.drawString("beam",XLEFT+LINELENGTH+4,XLEFT+LINELENGTH);
        drawOneGraph(list,g);
    }
    
    // Draw one line: match line or mismatch line with their positions
    private void drawOneGraph(PlotList list, Graphics g){
        max = new BigDecimal("0"); // then equal to 400
        min = new BigDecimal("0");
        for(int i=0;i<list.getNbPosition();i++){
            BigDecimal val = ((PlotCoord)list.getList().elementAt(i)).getStatValue();
            if(val.compareTo(max)==1) max=val;
            if(val.compareTo(min)==-1) min=val;
        }
        String[][] array=toBeam();
        int width=LINELENGTH/length;
        for(int j=1;j<length;j++){
            BigDecimal val = new BigDecimal(array[j][1]);
            BigDecimal lengthl=new BigDecimal(String.valueOf(LINELENGTH));
            val=val.multiply(lengthl);
            val=val.divide(new BigDecimal(String.valueOf(maxBeam+5)),1);  
            int valI=val.intValue();
            g.fillRect(XLEFT+((j-1)*width),400-valI,width,valI);
        }
    }
    
    
private String[][] toBeam(){
        String str="";
        BigDecimal i = new BigDecimal("0");
        BigDecimal step = new BigDecimal("0.01");
        int goaltemp = max.add(step).movePointRight(2).intValue();
        BigDecimal goal=new BigDecimal(String.valueOf(goaltemp)).movePointLeft(2);
        length=goal.multiply(new BigDecimal("100")).intValue();
        int l=0;
        String[][] array=new String[length+3][2];
        for(int j=0;j<length+2;j++){
            array[j][0]=String.valueOf(i);
            array[j][1]="0";
            i=i.add(step);
        }
       
      for(int j=0;j<list.getNbPosition();j++){
          int pos=0;
          String strs=((PlotCoord)list.getList().elementAt(j)).getStatValue().toString();
          BigDecimal dataDecAbs= new BigDecimal(strs).abs();
          while(dataDecAbs.compareTo(new BigDecimal(array[pos][0]))==1 || dataDecAbs.compareTo(new BigDecimal(array[pos][0]))==0){pos++;}
          array[pos][1]=String.valueOf(Integer.valueOf(array[pos][1]).intValue()+1);
          if(Integer.valueOf(array[pos][1]).intValue()>maxBeam)maxBeam=Integer.valueOf(array[pos][1]).intValue();
        }
        return array;
    }
    
    
}
