#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Database API Library
#
#     Copyright (C) 2005 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: G.pm,v 1.4 2002/07/30 17:40:56 gaou Exp $
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, 
# write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#
# written by Kazuharu Arakawa <gaou@sfc.keio.ac.jp> at
# G-language Project, Institute for Advanced Biosciences, Keio University.
#

package G::DB::GDBAPI;

use strict;

use vars qw($VERSION @ISA @INC $AUTOLOAD);

@ISA = qw();

$VERSION = '1.0';

#::::::::::::::::::::::::::::::
#    Let the code begin...
#::::::::::::::::::::::::::::::


sub rows_old{
    my $this = shift;
    my $all = shift;
    my $i = 0;
    my @rows;

    while(defined(%{$this->{$i}})){
	if($all ne 'all'){
	    if ($this->{$i}->{on} eq "0"){
		$i ++;
		next;
	    }
	}
        push (@rows, "$i");
        $i ++;
    }

    return @rows;
}

sub rows{
    my $this = shift;
    my $all = shift;
    my @rows;

    foreach my $key (sort {$a <=> $b} keys %{$this}){
	next if ($key eq 'COLS' || $key eq 'SQL' || $key eq 'QUERY');
	if($all ne 'all'){
	    next if ($this->{$key}->{on} eq "0");
	}
        push (@rows, $key);
    }

    return @rows;
}

sub cols{
    my $this = shift;
    $this->set_cols() unless(length $this->{COLS});

    return(split(/\t:\t/, $this->{COLS}));
}


sub select{
    my $this = shift;

    my $arg = shift;
    my ($arg1, $arg2, $arg3) = split(/\s+/, $arg, 3);

    my @res = ();

    if ($arg2 eq 'eq'){
	foreach my $row ($this->rows()){
	    if ($this->{$row}->{$arg1} eq $arg3){
		push(@res, $row);
	    }
	}
    }else{
	foreach my $row ($this->rows()){
	    if ($this->{$row}->{$arg1} =~ /$arg3/){
		push(@res, $row);
	    }
	}
    }
}



my $reservedwords = "add all alter analyze and as asc asensitive auto_increment bdb before berkeleydb between bigint binary blob both by call cascade case change char character check collate column columns condition connection constraint continue create cross current_date current_time current_timestamp cursor database databases day_hour day_microsecond day_minute day_second dec decimal declare default delayed delete desc describe deterministic distinct distinctrow div double drop else elseif enclosed escaped exists exit explain false fetch fields float for force foreign found frac_second from fulltext grant group having high_priority hour_microsecond hour_minute hour_second if ignore in index infile inner innodb inout insensitive insert int integer interval into io_thread is iterate join key keys kill leading leave left like limit lines load localtime localtimestamp lock long longblob longtext loop low_priority master_server_id match mediumblob mediumint mediumtext middleint minute_microsecond minute_second mod natural not no_write_to_binlog null numeric on optimize option optionally or order out outer outfile precision primary privileges procedure purge read real references regexp rename repeat replace require restrict return revoke right rlike second_microsecond select sensitive separator set show smallint some soname spatial specific sql sqlexception sqlstate sqlwarning sql_big_result sql_calc_found_rows sql_small_result sql_tsi_day sql_tsi_frac_second sql_tsi_hour sql_tsi_minute sql_tsi_month sql_tsi_quarter sql_tsi_second sql_tsi_week sql_tsi_year ssl starting straight_join striped table tables terminated then timestampadd timestampdiff tinyblob tinyint tinytext to trailing true undo union unique unlock unsigned update usage use user_resources using utc_date utc_time utc_timestamp values varbinary varchar varcharacter varying when where while with write xor year_month zerofill action bit date enum no text time timestamp";

sub set_cols{
    my $this = shift;
    my %hash;

    foreach my $row ($this->rows("all")){
	foreach my $col (keys %{$this->{$row}}){
	    next if ($col eq "on");
	    $hash{$col} ++;
	}
    }

    foreach my $key (keys %hash){
	my $lckey = lc($key);

	if($reservedwords =~ /\s$lckey\s/){
	    die("  Error: $key is a reserved word in SQL.\n");
	}
    }

    $this->{COLS} = join("\t:\t", keys %hash);
}



#::::::::::::::::::::::::::::::
#          Perldoc
#::::::::::::::::::::::::::::::

1;

__END__

=head1 NAME

G::DB::GDBAPI

=head1 SYNOPSIS

 use G::DB::GDBAPI;
 @ISA = (G::DB::GDBAPI);
   
=head1 DESCRIPTION

 Intended for internal use only. Super class for the core. Provides 
 the native methods.

=back

=head1 AUTHOR

Kazuharu Arakawa, gaou@sfc.keio.ac.jp

=head1 SEE ALSO

perl(1).

=cut



