#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2007 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#
# written by Koya Mori <mory@g-language.org> at
# G-language Project, Institute for Advanced Biosciences, Keio University.
#

package G::System::FuncD;

use SubOpt;
use G::Messenger;
use G::System::BAS;
use G::System::CHI;
use G::System::COMGA;
use G::System::GEMS;
use G::System::ReL8;
use G::System::STeP;

use strict("vars");
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

use SelfLoader;

require Exporter;

@ISA = qw(Exporter AutoLoader);
@EXPORT = qw(
	     funcD
);

__DATA__


#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::
 
sub funcD{
    &opt_default();
    my @args=opt_get(@_);

    my $gcffile=shift @args;
    my $cf;
    my $Sysname;
    my @fname;
    my %data;
    my %instance;
    my $new;
    my $tmp;
    my $tmp2;
    my $i;

    open(FILE, "$gcffile");
    while(<FILE>){
	if(/\>Engine\:/){
	    @fname=split(/:/);
	    $fname[1]=~tr/ \n//d;
	    last;
	}
    }
    close(FILE);
    $Sysname=$fname[1];

    $cf=&{$Sysname.'_parser'}($gcffile);

    %instance=(@args);
    foreach(keys(%{$cf})){
	if($_ =~ /^G(\d+)/){
	    unless(defined($instance{$cf->{$_}->{instance}})){
		$instance{$cf->{$_}->{instance}}=$cf->{$_}->{data};
	    }
	}
    }
	    
    foreach(keys(%instance)){
	$i++;
	$cf->{G.$i}->{instance}="$_";
	$cf->{G.$i}->{data}="$instance{$_}";
    }

    foreach $tmp (keys(%{$cf})){
	next if($tmp eq "Order");
	foreach $tmp2 (keys(%{$cf->{$tmp}})){
	    %data=(@{opt_val("$tmp")});
	    foreach(keys(%data)){
		if($tmp2 eq $_){
		    $cf->{$tmp}->{$tmp2}=$data{$_};
		}
		elsif($cf->{$tmp}->{$tmp2}->{key} eq $_){
		    $cf->{$tmp}->{$tmp2}->{value}=$data{$_};
		}
	    }
			
	}
    }

    $new=&{$Sysname.'_scripter'}($cf);
    open(TMP,">$gcffile");
    print TMP $new;
    close(TMP);

    eval{
	&{$Sysname.'_engine'}($gcffile);
    }

}


sub DESTROY {
    my $self = shift;
}

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::System::Sysrun - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::System::Sysrun;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::System::Sysrun was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

A. U. Thor, a.u.thor@a.galaxy.far.far.away

=head1 SEE ALSO

perl(1).

=cut
