#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2007 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Cap3.pm,v 1.4 2002/08/19 17:22:45 tero Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::Tools::KEGG_API3;

require Exporter;
use strict;
use G::Messenger;
use SOAP::Lite;
use vars qw(@ISA @EXPORT);

@ISA = qw(Exporter AutoLoader);
@EXPORT = qw(
	     load_kegg_api3
	     );

sub new{
    my $pkg = shift;
    my $self = {};
    return bless ($self,$pkg);
}

sub load_kegg_api3{
    return G::Tools::KEGG_API3->new();
}

my $url = 'http://soap.genome.jp/KEGG.wsdl';

sub list_databases{
 shift @_;
 my $response = SOAP::Lite->service("$url")->list_databases(@_);
 return $response;
}
sub list_organisms{
 shift @_;
 my $response = SOAP::Lite->service("$url")->list_organisms(@_);
 return $response;
}
sub list_pathways{
 shift @_;
 my $response = SOAP::Lite->service("$url")->list_pathways(@_);
 return $response;
}
sub binfo{
 shift @_;
 my $response = SOAP::Lite->service("$url")->binfo(@_);
 return $response;
}
sub bfind{
 shift @_;
 my $response = SOAP::Lite->service("$url")->bfind(@_);
 return $response;
}
sub bget{
 shift @_;
 my $response = SOAP::Lite->service("$url")->bget(@_);
 return $response;
}
sub btit{
 shift @_;
 my $response = SOAP::Lite->service("$url")->btit(@_);
 return $response;
}
sub get_linkdb_by_entry{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_linkdb_by_entry(@_);
 return $response;
}
sub get_neighbors_by_gene{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_neighbors_by_gene(@_);
 return $response;
}
sub get_best_best_neighbors_by_gene{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_best_best_neighbors_by_gene(@_);
 return $response;
}
sub get_best_neighbors_by_gene{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_best_neighbors_by_gene(@_);
 return $response;
}
sub get_reverse_best_neighbors_by_gene{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_reverse_best_neighbors_by_gene(@_);
 return $response;
}
sub get_paralogs_by_gene{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_paralogs_by_gene(@_);
 return $response;
}
sub get_similarity_between_genes{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_similarity_between_genes(@_);
 return $response;
}
sub get_motifs_by_gene{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_motifs_by_gene(@_);
 return $response;
}
sub get_genes_by_motifs{
 shift @_;
 my $max = pop(@_);
 my $start = pop(@_);
 my $data_a = SOAP::Data->type(array=>[@_]);
 my $response = SOAP::Lite->service("$url")->get_genes_by_motifs($data_a,$start,$max);
 return $response;
}
sub get_ko_by_gene{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_ko_by_gene(@_);
 return $response;
}
sub get_ko_members{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_ko_members(@_);
 return $response;
}
sub get_oc_members_by_gene{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_oc_members_by_gene(@_);
 return $response;
}
sub get_pc_members_by_gene{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_pc_members_by_gene(@_);
 return $response;
}
sub mark_pathway_by_objects{
 shift @_;
 my $pathway = shift(@_);
 my $in = shift(@_);
 my $data_a = SOAP::Data->type(array=>[@{$in}]);
 my $response = SOAP::Lite->service("$url")->mark_pathway_by_objects($pathway,$data_a);
 system("wget -q $response");
 my @array = split(/:/,$pathway);
 system("display  $array[1].gif");
 return $response;
}
sub color_pathway_by_objects{
    my @input;
    my @cpd;
    my @enz;
    my @genes;
    my @filename;
    shift @_;
    my $pathway = shift(@_);
    my $obj = shift(@_);
    my $fg = shift(@_);
    my $bg = shift(@_);
    my $spi = shift(@_); 
    my $show = shift(@_);

    $spi =~ s/-//g;
    foreach my $list (@{$obj}){
	if($list =~ /^C[0-9]+/){
	    push(@cpd,"cpd:$list");
	    push(@input,"cpd:$list");
	}
	elsif($list =~ /^[0-9]+\.[0-9]+\./){
	    push(@enz,"ec:$list");
	    push(@input,"ec:$list");
	}
	else{
	    push(@genes,"$spi:$list");
	    push(@input,"$spi:$list");
	}
    }

    my $data_genes = SOAP::Data->type(array=>[@genes]);
    my $data_enz = SOAP::Data->type(array=>[@enz]);
    my $data_cpd = SOAP::Data->type(array=>[@cpd]);
    my $data_a = SOAP::Data->type(array=>[@input]);
    my $data_b = SOAP::Data->type(array=>[@{$fg}]);
    my $data_c = SOAP::Data->type(array=>[@{$bg}]);

    my %res;
    my $num;
    if(length $pathway){
	%res = ($pathway, 1);
    }else{
	my $response_genes = SOAP::Lite->service("$url")->get_pathways_by_genes($data_genes);
	my $response_enz = SOAP::Lite->service("$url")->get_pathways_by_enzymes($data_enz);
	my $response_cpd = SOAP::Lite->service("$url")->get_pathways_by_compounds($data_cpd);
	my $count = 0;
	my $num = 0;
	foreach my $gene_res (@{$response_genes}){
	    $res{$gene_res}++;
	    if($gene_res){
		$count = 1;
	    }
	}
	if($count == 1){$num++}
	foreach my $enz_res (@{$response_enz}){
	    $res{$enz_res}++;
	    if($enz_res){
		$count = 2;
	    }
	}
	if($count == 2){$num++}
	foreach my $cpd_res (@{$response_cpd}){
	    $cpd_res =~ s/PATH: /path:/g;
	    $res{$cpd_res}++;
	    if($cpd_res){
		$count = 3;
	    }
	}
	if($count == 3){$num++}
    }

    mkdir("graph", 0777);
    chdir("graph");
    foreach my $pathway_in (keys(%res)){
	msg_error "searching object in pathway->$pathway_in\n";
	if($res{$pathway_in} >= $num){
	    my $response = SOAP::Lite->service("$url")->color_pathway_by_objects($pathway_in,$data_a,$data_b,$data_c);
	    system("wget $response");
	    my @array = split(/:/,$pathway_in);
	    push(@filename,"$array[1].gif");
	}
    }
    unless($show){
	foreach my $name (@filename){
	    msg_gimv($name);
	}
    }
    chdir("../");

    return @filename;
}

sub get_genes_by_pathway{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_genes_by_pathway(@_);
    return $response;
}
sub get_enzymes_by_pathway{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_enzymes_by_pathway(@_);
 return $response;
}
sub get_compounds_by_pathway{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_compounds_by_pathway(@_);
 return $response;
}
sub get_reactions_by_pathway{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_reactions_by_pathway(@_);
 return $response;
}
sub get_pathways_by_genes{
 shift @_;
 my $in = shift(@_);
 my $data_a = SOAP::Data->type(array=>[@{$in}]);
 my $response = SOAP::Lite->service("$url")->get_pathways_by_genes($data_a);
 return $response;
}
sub get_pathways_by_enzymes{
 shift @_;
 my $in = shift(@_);
 my $data_a = SOAP::Data->type(array=>[@{$in}]); 
 my $response = SOAP::Lite->service("$url")->get_pathways_by_enzymes($data_a);
 return $response;
}
sub get_pathways_by_compounds{
 shift @_;
 my $in = shift(@_);
 my $data_a = SOAP::Data->type(array=>[@{$in}]); 
 my $response = SOAP::Lite->service("$url")->get_pathways_by_compounds($data_a);
 return $response;
}
sub get_pathways_by_reactions{
 shift @_;
 my $in = shift(@_);
 my $data_a = SOAP::Data->type(array=>[@{$in}]); 
 my $response = SOAP::Lite->service("$url")->get_pathways_by_reactions($data_a);
 return $response;
}
sub get_linked_pathways{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_linked_pathways(@_);
 return $response;
}
sub get_genes_by_enzyme{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_genes_by_enzyme(@_);
 return $response;
}
sub get_enzymes_by_gene{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_enzymes_by_gene(@_);
 return $response;
}
sub get_enzymes_by_compound{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_enzymes_by_compound(@_);
 return $response;
}
sub get_enzymes_by_reaction{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_enzymes_by_reaction(@_);
 return $response;
}
sub get_compounds_by_enzyme{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_compounds_by_enzyme(@_);
 return $response;
}
sub get_compounds_by_reaction{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_compounds_by_reaction(@_);
 return $response;
}
sub get_reactions_by_enzyme{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_reactions_by_enzyme(@_);
 return $response;
}
sub get_reactions_by_compound{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_reactions_by_compound(@_);
 return $response;
}
sub get_genes_by_organism{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_genes_by_organism(@_);
 return $response;
}
sub get_number_of_genes_by_organism{
 shift @_;
 my $response = SOAP::Lite->service("$url")->get_number_of_genes_by_organism(@_);
 return $response;
}
1;


__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::Tools::KEGG_API3 - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::Tools::KEGG_API3;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Tools::KEGG_API3 was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

A. U. Thor, a.u.thor@a.galaxy.far.far.away

=head1 SEE ALSO

perl(1).

=cut
