#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2007 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: PBS.pm,v 1.1.1.1 2002/04/02 20:25:45 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::Tools::PBS;

use SubOpt;
use G::Messenger;

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

use SelfLoader;

require Exporter;

@ISA = qw(Exporter AutoLoader);
@EXPORT = qw(
	     qsub
	     qstat
);


__DATA__

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::


sub qsub{
    my $option;
    my @args;
    foreach(@_){
	if($_ eq "-V"){	
	    $option.="-V ";
	}else{
	    push(@args,$_);
	}
    }
    
    &opt_default(A=>"",a=>"",c=>"",e=>"",j=>"",k=>"",l=>"",N=>"",o=>"",p=>"",q=>"",r=>"",S=>"",u=>"",v=>"");
    @args=opt_get(@args);

    my @command=@args;
    my @param;
    my %opt;
    my @tmp;
    my $id;
    $opt{A}=opt_val("A");
    $opt{a}=opt_val("a");
    $opt{c}=opt_val("c");
    $opt{e}=opt_val("e");
    $opt{j}=opt_val("j");
    $opt{k}=opt_val("k");
    $opt{l}=opt_val("l");
    $opt{N}=opt_val("N");
    $opt{o}=opt_val("o");
    $opt{p}=opt_val("p");
    $opt{q}=opt_val("q");
    $opt{r}=opt_val("r");
    $opt{S}=opt_val("S");
    $opt{u}=opt_val("u");
    $opt{v}=opt_val("v");
    my $who=qx!whoami!;
    my $time=time;
    $who=~tr/\n//d;
    
    mkdir("/tmp/$who",0777);
    opendir(DIR,"/tmp/$who");
    @tmp=readdir(DIR);
    $time+=$#tmp;

    foreach(sort keys(%opt)){
        next if($opt{$_} eq '');
        push(@param,'-'.$_);
        push(@param,$opt{$_});
    }
    $option.=join(' ',@param);

    open(OUT,">/tmp/$who/$time.sh");
    print OUT "\#\!\/bin\/sh\n\n";
    foreach(@command){
	print OUT $_,"\n";
    }
    close(OUT);
    system('qsub '.$option.' /tmp/'.$who.'/'.$time.'.sh > '.'/tmp/'.$who.'/'.$time.'.log');
    
    open(LOG,"/tmp/$who/$time.log");
    $id=<LOG>;

    return $id;
}


sub qstat{
    my @param;
    my @tmp;
    foreach(@_){
        if($_ eq '-a' || $_ eq '-B' || $_ eq '-Bf' || $_ eq '-Qf' || $_ eq '-f' ||
           $_ eq '-u' || $_ eq '-r' || $_ eq '-i' || $_ eq '-G' || $_ eq '-M' ||
           $_ eq '-n' || $_ eq '-R' || $_ eq '-s' || $_ eq '-q'){
            push(@param,$_);
        }
        else{
            push(@tmp,$_);
        }
    }
    my @args=opt_get(@tmp);

    my $id=shift @args;
    my $option=join(' ',@param);
    my $qstat;
    my $time=time;
    opendir(DIR,"./");
    @tmp=readdir(DIR);
    $time+=$#tmp;

    $id=~tr/\n//d;
    $option=~tr/\n//d;
    system("qstat $option $id > ".$time.'.stat');
    open(STAT,"$time.stat");
    $qstat=join('',<STAT>);
    unlink("$time.stat");

    return $qstat;
}


sub DESTROY {
    my $self = shift;
}

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::Tools::PBS - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::Tools::PBS;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Tools::PBS was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

A. U. Thor, a.u.thor@a.galaxy.far.far.away

=head1 SEE ALSO

perl(1).

=cut

