/*
 * MainWindow.java
 *
 * Created on August 12, 2007, 8:39 PM
 */

package similarityValue.gui;


import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileNameExtensionFilter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import similarityValue.Molecule;
import similarityValue.MoleculePairValue;

/**
 *
 * @author  greg
 */
public class MainWindow extends javax.swing.JFrame {
	
	public static final long serialVersionUID = 0;
	
	private File Mol1PotFile;
	private File Mol2PotFile;
	JFileChooser chooser = new JFileChooser();
    
    /** Creates new form MainWindow */
    public MainWindow() {
        initComponents();
        
        setTitle("Similarity value");
        
        // Previously we typically attached a window listener to our main JFrame
        // and on windowClosing() event notification callback, we would
        // explicitly call System.exit(stat) or some other such nastiness.
        // The following is the new (clean) way of defining default close behavior
        // for a JFrame.  The following will merely dispose the JFrame but it will not
        // stop the application unless *all* Windows are disposed.

        setDefaultCloseOperation (JFrame.DISPOSE_ON_CLOSE);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        Mol1Frame = new javax.swing.JPanel();
        OpenMol1Pot = new javax.swing.JButton();
        Mol1PotFileLabel = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        Calculate = new javax.swing.JButton();
        Mol2Frame = new javax.swing.JPanel();
        OpenMol2Pot = new javax.swing.JButton();
        Mol2PotFileLabel = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        SimilarityValue = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        Mol1Frame.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        OpenMol1Pot.setText("Open");
        OpenMol1Pot.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                OpenPot1(evt);
            }
        });

        Mol1PotFileLabel.setEnabled(false);

        jLabel1.setText("Potentials file (pot.greg)");

        javax.swing.GroupLayout Mol1FrameLayout = new javax.swing.GroupLayout(Mol1Frame);
        Mol1Frame.setLayout(Mol1FrameLayout);
        Mol1FrameLayout.setHorizontalGroup(
            Mol1FrameLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(Mol1FrameLayout.createSequentialGroup()
                .addGroup(Mol1FrameLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, Mol1FrameLayout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addComponent(Mol1PotFileLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 418, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(OpenMol1Pot))
                    .addGroup(Mol1FrameLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel1)))
                .addContainerGap())
        );
        Mol1FrameLayout.setVerticalGroup(
            Mol1FrameLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(Mol1FrameLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(Mol1FrameLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(OpenMol1Pot)
                    .addComponent(Mol1PotFileLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        Calculate.setText("Calculate similarity");
        Calculate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                CalculateClicked(evt);
            }
        });

        Mol2Frame.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        OpenMol2Pot.setText("Open");
        OpenMol2Pot.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Open2Pot(evt);
            }
        });

        Mol2PotFileLabel.setEnabled(false);

        jLabel3.setText("Potentials file (pot.greg)");

        javax.swing.GroupLayout Mol2FrameLayout = new javax.swing.GroupLayout(Mol2Frame);
        Mol2Frame.setLayout(Mol2FrameLayout);
        Mol2FrameLayout.setHorizontalGroup(
            Mol2FrameLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(Mol2FrameLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(Mol2FrameLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel3)
                    .addGroup(Mol2FrameLayout.createSequentialGroup()
                        .addComponent(Mol2PotFileLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 420, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(OpenMol2Pot)))
                .addContainerGap())
        );
        Mol2FrameLayout.setVerticalGroup(
            Mol2FrameLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(Mol2FrameLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel3)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(Mol2FrameLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(Mol2PotFileLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(OpenMol2Pot))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jLabel5.setText("Molecule 1");

        jLabel6.setText("Molecule 2");

        jLabel7.setText("Similarity:");

        SimilarityValue.setText("N/A");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(Mol1Frame, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabel5)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(Calculate)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel7)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(SimilarityValue))
                    .addComponent(jLabel6)
                    .addComponent(Mol2Frame, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel5)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(Mol1Frame, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel6)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(Mol2Frame, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(Calculate)
                    .addComponent(jLabel7)
                    .addComponent(SimilarityValue))
                .addContainerGap())
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void Open2Pot(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Open2Pot
    	FileNameExtensionFilter filter = new FileNameExtensionFilter(
            "OpenDX", "dx");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this);
        if(returnVal == JFileChooser.APPROVE_OPTION) {
        	Mol2PotFileLabel.setText(chooser.getSelectedFile().getAbsolutePath());
        	Mol2PotFile = chooser.getSelectedFile();
        }
    }//GEN-LAST:event_Open2Pot

    private void OpenPot1(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_OpenPot1
    	FileNameExtensionFilter filter = new FileNameExtensionFilter(
            "OpenDX", "dx");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this);
        if(returnVal == JFileChooser.APPROVE_OPTION) {
        	Mol1PotFileLabel.setText(chooser.getSelectedFile().getAbsolutePath());
        	Mol1PotFile = chooser.getSelectedFile();
        }
    }//GEN-LAST:event_OpenPot1

    private void CalculateClicked(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_CalculateClicked
		try {
		    // Get current time
		    long start = System.currentTimeMillis();
		    long startLoading = start;
			
			Molecule mol1 = new Molecule(Mol1PotFile);
			Molecule mol2 = new Molecule(Mol2PotFile);
			
		    long startCalculating = System.currentTimeMillis();
		    System.out.println("# Time spent loading molecules from disk: " + ((startCalculating-startLoading)/1000.0) + " sec");
			
			SimilarityValue.setText(String.valueOf(MoleculePairValue.similarityValue(mol1, mol2)));
			
		    System.out.println("# Time spent calculating: " + ((System.currentTimeMillis()-startCalculating)/1000.0) + " sec");
		    System.out.println("# Total time spent: " + ((System.currentTimeMillis()-start)/1000.0) + " sec");
		    
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
    }//GEN-LAST:event_CalculateClicked
        
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton Calculate;
    private javax.swing.JPanel Mol1Frame;
    private javax.swing.JTextField Mol1PotFileLabel;
    private javax.swing.JPanel Mol2Frame;
    private javax.swing.JTextField Mol2PotFileLabel;
    private javax.swing.JButton OpenMol1Pot;
    private javax.swing.JButton OpenMol2Pot;
    private javax.swing.JLabel SimilarityValue;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    // End of variables declaration//GEN-END:variables
    
}
