/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape;

import cytoscape.Cytoscape;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.util.CytoscapeAction;
import fr.pasteur.sysbio.rdfscape.CommonMemory;
import fr.pasteur.sysbio.rdfscape.RDFScapePanel;
import fr.pasteur.sysbio.rdfscape.Utilities;
import fr.pasteur.sysbio.rdfscape.browsing.BrowserManager;
import fr.pasteur.sysbio.rdfscape.context.ContextManager;
import fr.pasteur.sysbio.rdfscape.cytomapper.CytoMapper;
import fr.pasteur.sysbio.rdfscape.cytoscape.CytoscapeDealer;
import fr.pasteur.sysbio.rdfscape.help.HelpManager;
import fr.pasteur.sysbio.rdfscape.knowledge.JenaWrapper;
import fr.pasteur.sysbio.rdfscape.knowledge.KnowledgeWrapper;
import fr.pasteur.sysbio.rdfscape.namespacemanagement.NamespaceManager;
import fr.pasteur.sysbio.rdfscape.ontologyhandling.OntologyLoaderManager;
import fr.pasteur.sysbio.rdfscape.patterns.PatternManager;
import fr.pasteur.sysbio.rdfscape.query.QueryManager;
import fr.pasteur.sysbio.rdfscape.reasoning.ReasonerManager;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.Action;

public class RDFScape
extends CytoscapePlugin {
    private static KnowledgeWrapper myKnowledgeEngine = null;
    private static CommonMemory myMemory = null;
    private static PatternManager patternManager = null;
    private static ContextManager contextManager = null;
    private static OntologyLoaderManager ontologyLoaderManager = null;
    private static NamespaceManager namespaceManager = null;
    private static ReasonerManager reasonerManager = null;
    private static BrowserManager browserManager = null;
    private static QueryManager queryManager = null;
    private static CytoMapper cytoMapper = null;
    private static CytoscapeDealer cytoscapeDealer = null;
    private static HelpManager helpManager = null;
    private static RDFScapePanel myPanel = null;

    public RDFScape() {
        System.out.println("Registering RDFScape plugin");
        RDFScapeStartAction rDFScapeStartAction = new RDFScapeStartAction(this);
        Cytoscape.getDesktop().getCyMenus().getOperationsMenu().add((Action)((Object)rDFScapeStartAction));
        this.init();
    }

    private boolean init() {
        System.out.println("Building RDFScape plugin");
        contextManager = new ContextManager();
        myMemory = new CommonMemory();
        try {
            myKnowledgeEngine = new JenaWrapper();
            namespaceManager = new NamespaceManager();
            ontologyLoaderManager = new OntologyLoaderManager();
            cytoscapeDealer = new CytoscapeDealer();
            browserManager = new BrowserManager();
            patternManager = new PatternManager();
            cytoMapper = new CytoMapper();
            reasonerManager = new ReasonerManager();
            queryManager = new QueryManager();
            helpManager = new HelpManager();
        }
        catch (Exception exception) {
            System.out.println("Something went wrong during initialization ");
            System.out.println(exception.getMessage());
        }
        System.out.println("RDFScape plugin built");
        URL uRL = Utilities.class.getResource("../../../../extras/rdfscapevizmap.props");
        System.out.println("RDFSCape vizmap file: " + uRL);
        Cytoscape.firePropertyChange((String)Cytoscape.VIZMAP_LOADED, null, (Object)uRL);
        return true;
    }

    public static void setKnowledgeEngine(KnowledgeWrapper knowledgeWrapper) {
        myKnowledgeEngine = knowledgeWrapper;
        myMemory.relink();
    }

    public static KnowledgeWrapper getKnowledgeEngine() {
        return myKnowledgeEngine;
    }

    public static OntologyLoaderManager getOntologyManager() {
        return ontologyLoaderManager;
    }

    public static NamespaceManager getNameSpaceManager() {
        return namespaceManager;
    }

    public static CytoMapper getCytoMapper() {
        return cytoMapper;
    }

    public static ReasonerManager getReasonerManager() {
        return reasonerManager;
    }

    public static PatternManager getPatternManager() {
        return patternManager;
    }

    public static CytoscapeDealer getCytoscapeDealer() {
        return cytoscapeDealer;
    }

    public static BrowserManager getBrowserManager() {
        return browserManager;
    }

    public static QueryManager getRDQLQueryManager() {
        return queryManager;
    }

    public static ContextManager getContextManager() {
        return contextManager;
    }

    public static CommonMemory getCommonMemory() {
        return myMemory;
    }

    public static HelpManager getHelpManager() {
        return helpManager;
    }

    public void baseOntologyChanged() {
    }

    public void ontologyChanged() {
        namespaceManager.touch();
        if (!namespaceManager.canOperate()) {
            RDFScape.warn("Namespaces changed and need a check.");
        }
    }

    public void contextChanged() {
    }

    private void checkNameSpaceConsistency() {
        if (!namespaceManager.canOperate()) {
            myPanel.alert("Namespaces are incosistent!!! \nplease ensure any namespace has a distinct prefix, and that no prefix is empty\n(though the latter is realy only to simplify your life) ");
        }
    }

    public static RDFScapePanel getPanel() {
        return myPanel;
    }

    public void rulesUpdated() {
    }

    public static void warn(String string) {
        if (myPanel != null) {
            myPanel.alert(string);
        } else {
            System.out.println(string);
        }
    }

    public static void resetModulesBeforeChangeOfContext() {
        myMemory.reset();
        ontologyLoaderManager.reset();
        namespaceManager.reset();
        reasonerManager.reset();
        browserManager.reset();
        cytoMapper.reset();
        patternManager.reset();
        cytoscapeDealer.reset();
    }

    public static void activeContextChanged() {
        myPanel.refreshTabs();
        browserManager.getPanel().refresh();
        reasonerManager.getReasonerManagerPanel().refresh();
    }

    public static void ontologiesLoaded() {
        RDFScape.getReasonerManager().touch();
        myPanel.refreshTabs();
    }

    public static void patternListChanged() {
        myPanel.refreshTabs();
    }

    public static void mappingActionPerformed() {
        myPanel.refreshTabs();
    }

    public final class RDFScapeStartAction
    extends CytoscapeAction {
        RDFScape myRDFScapeInstance;

        public RDFScapeStartAction(RDFScape rDFScape2) {
            super("RDFScape");
            this.myRDFScapeInstance = null;
            this.myRDFScapeInstance = rDFScape2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!RDFScape.this.init()) {
                System.out.println("Init problems... sorry");
                return;
            }
            Cytoscape.getVisualMappingManager().setVisualStyle("RDFScape");
            myPanel = new RDFScapePanel();
        }
    }
}

