/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.reasoning;

import fr.pasteur.sysbio.rdfscape.AbstractModulePanel;
import fr.pasteur.sysbio.rdfscape.Utilities;
import fr.pasteur.sysbio.rdfscape.help.HelpManager;
import fr.pasteur.sysbio.rdfscape.knowledge.InfRuleObject;
import fr.pasteur.sysbio.rdfscape.reasoning.ReasonerManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ReasonerManagerPanel
extends AbstractModulePanel
implements ListSelectionListener {
    private ReasonerManager reasonerManager = null;
    private JList rulesList = null;
    private JTextArea ruleBody = null;
    private JButton addButton = null;
    private JButton commitButton = null;
    private JButton deleteButton = null;
    private JButton reasonButton = null;
    private JComboBox enginesBox = null;
    private JPanel reasonOptionPanel = null;
    private JPanel ruleOptionPanel = null;
    private JPanel buttonPanel = null;
    private JPanel selectionPanel = null;
    private JButton saveButton = null;
    private String[][] optionsToShow;
    private String[] defaultOptions;
    private JComboBox[] optionBoxes;
    private String[][] ruleOptionsToShow;
    private String[] ruleDefaultOptions;
    private String[] ruleOptionParams;
    private JComboBox[] ruleOptionBoxes;
    ActionListener multiOptionsListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = new String[ReasonerManagerPanel.this.optionBoxes.length];
            for (int i = 0; i < ReasonerManagerPanel.this.optionBoxes.length; ++i) {
                stringArray[i] = (String)ReasonerManagerPanel.this.optionBoxes[i].getSelectedItem();
            }
            ReasonerManagerPanel.this.reasonerManager.setSelectedOptions(stringArray);
        }
    };

    public ReasonerManagerPanel(ReasonerManager reasonerManager) {
        this.redLightText = "<html>This should not happen! You are experiencing problems here... please report!</html>";
        this.yellowLightText = "<html>This should not happen! You are experiencing problems here... please report!</html>";
        this.greenLightText = "<html>You can always edit reasoning settings</html>";
        this.myTabText = "Resoner and inference rules";
        this.myTabTooltip = "<html>Configure reasoneings options and inference rules</html>";
        this.reasonerManager = reasonerManager;
        this.setLayout(new BorderLayout());
        this.rulesList = new JList(this.reasonerManager);
        this.rulesList.setCellRenderer(new RulesListCellRenderer());
        this.rulesList.addListSelectionListener(this);
        this.ruleBody = new JTextArea(80, 10);
        this.addButton = new JButton("Add");
        this.commitButton = new JButton("Commit");
        this.deleteButton = new JButton("Delete");
        this.reasonButton = new JButton("Reason");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReasonerManagerPanel.this.reasonerManager.setActiveEngine((String)ReasonerManagerPanel.this.enginesBox.getSelectedItem());
            }
        };
        this.enginesBox = new JComboBox<String>(this.reasonerManager.getEngines());
        this.enginesBox.addActionListener(actionListener);
        this.enginesBox.setSelectedItem(this.reasonerManager.getActiveEngine());
        this.enginesBox.setEnabled(true);
        this.selectionPanel = new JPanel();
        this.selectionPanel.add(this.enginesBox);
        this.selectionPanel.add(this.makeReasonOptionPanel());
        this.addButton.addActionListener(new AddButtonListener());
        this.commitButton.addActionListener(new CommitButtonListener());
        this.deleteButton.addActionListener(new DeleteButtonListener());
        this.reasonButton.addActionListener(new ReasonButtonListener());
        JPanel jPanel = new JPanel();
        jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.ruleBody, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(this.commitButton);
        this.buttonPanel.add(this.deleteButton);
        this.buttonPanel.add(this.makeRuleOptionPanel());
        jPanel.add((Component)this.buttonPanel, "South");
        JScrollPane jScrollPane = new JScrollPane(this.rulesList);
        jScrollPane.setPreferredSize(new Dimension(150, 200));
        this.add((Component)jScrollPane, "West");
        this.add((Component)jPanel, "Center");
        this.add((Component)this.reasonButton, "South");
        this.add((Component)this.selectionPanel, "North");
        this.rulesList.addMouseListener(new CheckBoxSelectionListener());
        this.checkButtonsEnabled();
    }

    private void checkButtonsEnabled() {
        if (this.reasonerManager.rulesEnabled()) {
            this.ruleBody.setEditable(true);
            this.addButton.setEnabled(true);
            this.commitButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        } else {
            this.ruleBody.setEditable(false);
            this.addButton.setEnabled(false);
            this.commitButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
    }

    private JPanel makeReasonOptionPanel() {
        this.reasonOptionPanel = new JPanel();
        if (this.reasonerManager.hasReasoningOptions()) {
            this.optionsToShow = this.reasonerManager.getOptions();
            this.defaultOptions = this.reasonerManager.getDefaultOptions();
            if (this.optionsToShow == null) {
                return this.reasonOptionPanel;
            }
            this.optionBoxes = new JComboBox[this.optionsToShow.length];
            for (int i = 0; i < this.optionBoxes.length; ++i) {
                this.optionBoxes[i] = new JComboBox<String>(this.optionsToShow[i]);
                this.optionBoxes[i].setSelectedItem(this.defaultOptions[i]);
                this.optionBoxes[i].addActionListener(this.multiOptionsListener);
                this.reasonOptionPanel.add(this.optionBoxes[i]);
            }
        }
        return this.reasonOptionPanel;
    }

    private JPanel makeRuleOptionPanel() {
        this.ruleOptionPanel = new JPanel();
        if (this.reasonerManager.rulesEnabled()) {
            this.ruleOptionsToShow = this.reasonerManager.getRuleOptions();
            this.ruleDefaultOptions = this.reasonerManager.getRuleDefaultOptions();
            this.ruleOptionParams = this.reasonerManager.getRuleOptionParams();
            this.ruleOptionBoxes = new JComboBox[this.ruleOptionsToShow.length];
            for (int i = 0; i < this.ruleOptionBoxes.length; ++i) {
                this.ruleOptionBoxes[i] = new JComboBox<String>(this.ruleOptionsToShow[i]);
                this.ruleOptionBoxes[i].setSelectedItem(this.ruleDefaultOptions[i]);
                this.ruleOptionPanel.add(this.ruleOptionBoxes[i]);
            }
        }
        return this.ruleOptionPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.rulesList.getSelectedIndex();
        if (n >= 0) {
            InfRuleObject infRuleObject = (InfRuleObject)this.reasonerManager.getElementAt(n);
            this.ruleBody.setText(infRuleObject.getRule());
            for (int i = 0; i < this.ruleOptionBoxes.length; ++i) {
                this.ruleOptionBoxes[i].setSelectedItem(infRuleObject.getParam(this.ruleOptionParams[i]));
                System.out.println(this.ruleOptionParams[i] + "<-" + infRuleObject.getParam(this.ruleOptionParams[i]));
            }
        } else {
            this.ruleBody.setText("");
            for (int i = 0; i < this.ruleOptionBoxes.length; ++i) {
                this.optionBoxes[i].setSelectedItem(this.ruleDefaultOptions[i]);
            }
        }
        this.rulesList.repaint();
    }

    public void updateAfterEngineChange() {
        this.selectionPanel.remove(this.reasonOptionPanel);
        this.selectionPanel.add(this.makeReasonOptionPanel());
        this.buttonPanel.remove(this.ruleOptionPanel);
        this.buttonPanel.add(this.makeRuleOptionPanel());
        this.enginesBox.setSelectedItem(this.reasonerManager.getActiveEngine());
        this.checkButtonsEnabled();
        this.validate();
    }

    @Override
    public String getHelpLink() {
        return "http://www.bioinformatics.org/rdfscape/wiki/Main/HowToUseInference";
    }

    @Override
    public JPanel getHelpPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel("<html>Select the \"knowledge engine\" you want to use (the only choice available at this time is Jena) and the level of reasoining that you wish to be performed.<br>Note that custom inference rules are added to this step.<br>Current options are: <ul><li><b>None</b> No entailments are computed (apart from rules, if selected)</li><li><b>RDFS-1</b> based on the Jena rule engine (see help on the web for details)</li><li><b>RDFS-2</b> as above</li><li><b>OWL-1</b> as above</li><li><b>OWL-2</li> as above</b><li><b>Pellet-fast</b> Use pellet. This attempts to compute a subset of entailments. In this case only the subsumption computation from Pellet is used, and its result (classes and properties) is added to the original model and passed to an RDFS model (toghether with custom inference rules) for transitive types resolution</li><li><b>Pellet</b> Use pellet</li><li><b>DIG</b> Connects to an external DIG reasoner</li></ul>Notes: for Jena based models, custom inference rules are computed at same time as standard inference rules.<br>For Pellet and DIG, custom rules are applied <i>on top</i> of the total knowledge entailed by the previous reasoning step.<br><font color=red> It is advisable to use Pellet model only for very small ontologies, or to use Pellet-fast</font><br>The perfomance of <b>Pellet-fast</b> is similar to that of Pellet used command line. <b>Pellet</b> is considerably slower.</html>", Utilities.getHelpIcon("reasonerAndLevel.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Reasoning (of standard enatilments and inference rules) is issued through this button. This must be selected after changes in reasoning settings in order from them to take place. <br>Note that after loading ontologies, the reasoning step is automatically computed with settings from the current analysis context.</html>", Utilities.getHelpIcon("reasonButton.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel(Utilities.getHelpIcon("rulePanel.png"), 0);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>The list of rules in the current analysis context is presented here. Each rule can be activated or not. Only activated rules are taken into consoderation in the reasoning step.The syntax of rules follows that of Jena. See <b>Help on the web</b> for more details.</html>");
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Selecting a rule and selecting <b>Delete</b> deletes the rule. To add a rule select <b>Add</b>. At this point an empty rule panel is added to the list.Go to the rule panel and enter the text ofg the rule (this includes the name, that will be parsed as a rule index).<br>In order for the rule to be recorder, select <b>Commit</b><br><font color=red>Note: <b>Add</b>  does not save the rule currently displayed. You must select <b>Commit</b> before.</html>", Utilities.getHelpIcon("addCommitDeleteRules.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Currently no alternatives are present. The only syntax supported is Jena and all the rules are tentatively evaluated after standard entailments.</html>", Utilities.getHelpIcon("ruleOptionPanel.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        return jPanel;
    }

    @Override
    public String getPanelName() {
        return "Resoner Settings";
    }

    @Override
    public int getStatusLevel() {
        return 3;
    }

    @Override
    public void refresh() {
        String[] stringArray = this.reasonerManager.getReasonerOptionNames();
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("Option: " + stringArray[i]);
            if (!stringArray[i].equalsIgnoreCase("Level")) continue;
            System.out.println("Was selected :" + this.optionBoxes[i].getSelectedItem());
            System.out.println("Going to be :" + this.reasonerManager.getReasonerActualOptions()[i]);
            this.optionBoxes[i].setSelectedItem(this.reasonerManager.getReasonerActualOptions()[i]);
        }
    }

    class ReasonButtonListener
    implements ActionListener {
        ReasonButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReasonerManagerPanel.this.reasonerManager.forwardRules();
            ReasonerManagerPanel.this.reasonerManager.reason();
        }
    }

    class CommitButtonListener
    implements ActionListener {
        CommitButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ReasonerManagerPanel.this.rulesList.getSelectedIndex();
            if (n >= 0) {
                String string = ReasonerManagerPanel.this.ruleBody.getText();
                String[][] stringArray = new String[ReasonerManagerPanel.this.ruleDefaultOptions.length][2];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i][0] = ReasonerManagerPanel.this.ruleOptionParams[i];
                    stringArray[i][1] = (String)ReasonerManagerPanel.this.ruleOptionBoxes[i].getSelectedObjects()[0];
                }
                ReasonerManagerPanel.this.reasonerManager.updateRule(n, string, stringArray);
            }
        }
    }

    class DeleteButtonListener
    implements ActionListener {
        DeleteButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InfRuleObject infRuleObject = (InfRuleObject)ReasonerManagerPanel.this.rulesList.getSelectedValue();
            int n = ReasonerManagerPanel.this.rulesList.getSelectedIndex();
            ReasonerManagerPanel.this.rulesList.removeSelectionInterval(n, n);
            ReasonerManagerPanel.this.reasonerManager.deleteRule(infRuleObject);
        }
    }

    class AddButtonListener
    implements ActionListener {
        AddButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InfRuleObject infRuleObject = new InfRuleObject("[new:]");
            for (int i = 0; i < ReasonerManagerPanel.this.ruleOptionBoxes.length; ++i) {
                infRuleObject.setParam(ReasonerManagerPanel.this.ruleOptionParams[i], ReasonerManagerPanel.this.ruleDefaultOptions[i]);
            }
            ReasonerManagerPanel.this.reasonerManager.addRuleObject(infRuleObject);
            ReasonerManagerPanel.this.rulesList.setSelectedIndex(ReasonerManagerPanel.this.reasonerManager.getIndexOfRuleObject(infRuleObject));
        }
    }

    class RulesListCellRenderer
    implements ListCellRenderer {
        Hashtable cells = new Hashtable();

        public RulesListCellRenderer() {
            ReasonerManagerPanel.this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (this.cells.get(object) == null) {
                this.cells.put(object, new JCheckBox(((InfRuleObject)object).getName(), ((InfRuleObject)object).isActive()));
                ((JCheckBox)this.cells.get(object)).setEnabled(true);
            }
            ((JCheckBox)this.cells.get(object)).setOpaque(true);
            ((JCheckBox)this.cells.get(object)).setBackground(Color.WHITE);
            if (bl2) {
                ((JCheckBox)this.cells.get(object)).setBackground(Color.CYAN);
            }
            if (bl) {
                ((JCheckBox)this.cells.get(object)).setBackground(Color.BLUE);
            }
            ((JCheckBox)this.cells.get(object)).setText(((InfRuleObject)object).getName());
            ((JCheckBox)this.cells.get(object)).setSelected(((InfRuleObject)object).isActive());
            return (JCheckBox)this.cells.get(object);
        }
    }

    public class CheckBoxSelectionListener
    implements MouseListener {
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getX() < 20) {
                System.out.println("GOT IT NOW!");
                int n = ReasonerManagerPanel.this.rulesList.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                InfRuleObject infRuleObject = (InfRuleObject)ReasonerManagerPanel.this.rulesList.getModel().getElementAt(n);
                System.out.println("Index: " + n + " " + infRuleObject.getName());
                infRuleObject.invertSelected();
                ReasonerManagerPanel.this.rulesList.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

