/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main.iterator;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpSubstitute;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterConcat;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRepeatApply;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSingleton;
import com.hp.hpl.jena.sparql.engine.main.QC;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class QueryIterUnion
extends QueryIterRepeatApply {
    List subOps;

    public QueryIterUnion(QueryIterator input, List subOps, ExecutionContext context) {
        super(input, context);
        this.subOps = subOps;
    }

    protected QueryIterator nextStage(Binding binding) {
        QueryIterConcat unionQIter = new QueryIterConcat(this.getExecContext());
        ListIterator iter = this.subOps.listIterator();
        while (iter.hasNext()) {
            Op subOp = (Op)iter.next();
            subOp = OpSubstitute.substitute(subOp, binding);
            QueryIterSingleton parent = new QueryIterSingleton(binding, this.getExecContext());
            QueryIterator qIter = QC.compile(subOp, parent, this.getExecContext());
            unionQIter.add(qIter);
        }
        return unionQIter;
    }

    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.println(Utils.className(this));
        out.incIndent();
        Iterator iter = this.subOps.iterator();
        while (iter.hasNext()) {
            Op op = (Op)iter.next();
            op.output(out, sCxt);
        }
        out.decIndent();
        out.ensureStartOfLine();
    }
}

