/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;

public class ModSymbol
implements ArgModuleGeneral {
    protected final ArgDecl setDecl = new ArgDecl(true, "set", "define", "defn", "def");
    Context context = new Context();
    private String namespace;

    public ModSymbol() {
        this("http://jena.hpl.hp.com/ARQ#");
    }

    public ModSymbol(String namespace) {
        this.namespace = namespace;
    }

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Symbol definition");
        cmdLine.add(this.setDecl, "--set", "Set a configuration symbol to a value");
    }

    public void checkCommandLine(CmdArgModule cmdLine) {
    }

    public void processArgs(CmdArgModule cmdLine) {
        if (cmdLine.getValues(this.setDecl) == null || cmdLine.getValues(this.setDecl).size() == 0) {
            return;
        }
        Iterator iter = cmdLine.getValues(this.setDecl).iterator();
        while (iter.hasNext()) {
            String arg = (String)iter.next();
            String[] frags = arg.split("=", 2);
            if (frags.length != 2) {
                throw new RuntimeException("Can't split '" + arg + "'");
            }
            String symbolName = frags[0];
            String value = frags[1];
            if (!symbolName.matches("^[a-zA-Z]*:")) {
                symbolName = this.namespace + symbolName;
            }
            Symbol symbol = Symbol.create((String)symbolName);
            this.context.set(symbol, (Object)value);
        }
        ARQ.getContext().setAll(this.context);
    }

    public void verbose() {
        this.verbose(System.out);
    }

    public void verbose(PrintStream stream) {
        IndentedWriter out = new IndentedWriter((OutputStream)stream);
        this.verbose(out);
        out.flush();
    }

    public void verbose(IndentedWriter out) {
        Iterator iter = this.context.keys().iterator();
        while (iter.hasNext()) {
            Symbol symbol = (Symbol)iter.next();
            String value = this.context.getAsString(symbol);
            out.println(symbol + " -> " + value);
        }
    }
}

