/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology;

import com.hp.hpl.jena.assembler.AssemblerHelp;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.impl.DriverMap;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecImpl;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.rulesys.impl.WrappedReasonerFactory;
import com.hp.hpl.jena.shared.BadDescriptionMultipleRootsException;
import com.hp.hpl.jena.shared.BadDescriptionNoRootException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.NoReasonerSuppliedException;
import com.hp.hpl.jena.shared.NoSuchReasonerException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashMap;
import java.util.Map;

public abstract class OntModelSpecObsolete
extends ModelSpecImpl {
    protected static final RDFNode nullObject = null;
    private static Map values = new HashMap();
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Property;

    public OntModelSpecObsolete(ModelMaker maker) {
        super(maker);
    }

    public abstract Model implementCreateModelOver(String var1);

    protected abstract Model doCreateModel();

    public Property getMakerProperty() {
        return JenaModelSpec.importMaker;
    }

    protected static ModelMaker getMaker(Model description, Resource root, Property makerProperty) {
        Statement mStatement = description.getProperty(root, makerProperty);
        return mStatement == null ? ModelFactory.createMemModelMaker() : OntModelSpecObsolete.createMaker(mStatement.getResource(), description);
    }

    public static Resource findRootByType(Model description, Resource type) {
        Model m = OntModelSpecObsolete.withSpecSchema(description);
        StmtIterator it = m.listStatements(null, RDF.type, type);
        if (!it.hasNext()) {
            throw new BadDescriptionNoRootException(m, type);
        }
        Resource root = it.nextStatement().getSubject();
        if (it.hasNext()) {
            throw new BadDescriptionMultipleRootsException(m, type);
        }
        return root;
    }

    public static ModelMaker createMaker(Resource root, Model d) {
        return OntModelSpecObsolete.createMakerByRoot(root, OntModelSpecObsolete.withSpecSchema(d));
    }

    public static ModelMaker createMakerByRoot(Resource root, Model fullDesc) {
        Resource type = OntModelSpecObsolete.findMakerType(root, fullDesc);
        ModelMakerCreator mmc = OntModelSpecObsolete.findCreator(type);
        if (mmc == null) {
            throw new RuntimeException("no maker type");
        }
        return mmc.create(fullDesc, root);
    }

    private static ModelMakerCreator findCreator(Resource type) {
        if (((Object)type).equals(JenaModelSpec.MakerSpec)) {
            return new MemMakerCreator();
        }
        if (((Object)type).equals(JenaModelSpec.FileMakerSpec)) {
            return new FileMakerCreator();
        }
        if (((Object)type).equals(JenaModelSpec.MemMakerSpec)) {
            return new MemMakerCreator();
        }
        if (((Object)type).equals(JenaModelSpec.RDBMakerSpec)) {
            return new RDBMakerCreator();
        }
        return null;
    }

    private static Resource findMakerType(Resource root, Model fullDesc) {
        return AssemblerHelp.findSpecificType((Resource)root.inModel(fullDesc), JenaModelSpec.MakerSpec);
    }

    public static Model withSpecSchema(Model m) {
        return OntModelSpecObsolete.withSchema(m, JenaModelSpec.getSchema());
    }

    public static Model withSchema(Model m, Model schema) {
        Model result = ModelFactory.createDefaultModel();
        result.add(m);
        OntModelSpecObsolete.addJMSSubclassesFrom(result, schema);
        OntModelSpecObsolete.addDomainTypes(result, m, schema);
        OntModelSpecObsolete.addSupertypesFrom(result, schema);
        OntModelSpecObsolete.addSupertypesFrom(result, m);
        return result;
    }

    protected static boolean notRDF(Resource resource) {
        if (resource.isAnon()) {
            return true;
        }
        if (resource.getNameSpace().equals(RDF.getURI())) {
            return false;
        }
        return !resource.getNameSpace().equals(RDFS.getURI());
    }

    protected static void addJMSSubclassesFrom(Model result, Model schema) {
        StmtIterator it = schema.listStatements(null, RDFS.subClassOf, nullObject);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            if (!OntModelSpecObsolete.notRDF(s.getSubject()) || !OntModelSpecObsolete.notRDF(s.getResource())) continue;
            result.add(s);
        }
    }

    protected static void addDomainTypes(Model result, Model m, Model schema) {
        StmtIterator it = schema.listStatements(null, RDFS.domain, nullObject);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            Property property = (Property)s.getSubject().as(class$com$hp$hpl$jena$rdf$model$Property == null ? OntModelSpecObsolete.class$("com.hp.hpl.jena.rdf.model.Property") : class$com$hp$hpl$jena$rdf$model$Property);
            StmtIterator x = m.listStatements(null, property, nullObject);
            while (x.hasNext()) {
                Statement t = x.nextStatement();
                result.add(t.getSubject(), RDF.type, s.getObject());
            }
        }
    }

    protected static void addSupertypesFrom(Model result, Model source) {
        Model temp = ModelFactory.createDefaultModel();
        StmtIterator it = result.listStatements(null, RDF.type, nullObject);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            StmtIterator subclasses = source.listStatements(s.getResource(), RDFS.subClassOf, nullObject);
            while (subclasses.hasNext()) {
                RDFNode type = subclasses.nextStatement().getObject();
                temp.add(s.getSubject(), RDF.type, type);
            }
        }
        result.add(temp);
    }

    public static ReasonerFactory getReasonerFactory(Resource R, Model rs) {
        StmtIterator r = rs.listStatements(R, JenaModelSpec.reasoner, (RDFNode)null);
        if (!r.hasNext()) {
            throw new NoReasonerSuppliedException();
        }
        Resource rr = r.nextStatement().getResource();
        String rrs = rr.getURI();
        ReasonerFactory rf = ReasonerRegistry.theRegistry().getFactory(rrs);
        if (rf == null) {
            throw new NoSuchReasonerException(rrs);
        }
        return new WrappedReasonerFactory(rf, (Resource)R.inModel(rs));
    }

    public static ReasonerFactory getReasonerFactory(Model description, Resource root) {
        Statement factStatement = description.getProperty(root, JenaModelSpec.reasonsWith);
        if (factStatement == null) {
            return null;
        }
        return OntModelSpec.getReasonerFactory(factStatement.getResource(), description);
    }

    public static OntDocumentManager getDocumentManager(Model description, Resource root) {
        Statement docStatement = description.getProperty(root, JenaModelSpec.docManager);
        if (docStatement == null) {
            return null;
        }
        Resource manager = docStatement.getResource();
        Statement policy = description.getProperty(manager, JenaModelSpec.policyPath);
        if (policy == null) {
            return (OntDocumentManager)OntModelSpecObsolete.getValue(manager);
        }
        return new OntDocumentManager(policy.getString());
    }

    public static ModelMaker getImportMaker(Model description, Resource root) {
        return OntModelSpecObsolete.getMaker(description, root, JenaModelSpec.importMaker);
    }

    public static ModelMaker getBaseMaker(Model description, Resource root) {
        return OntModelSpecObsolete.getMaker(description, root, JenaModelSpec.maker);
    }

    protected static String getBaseModelName(Model description, Resource root) {
        Statement s = description.getProperty(root, JenaModelSpec.modelName);
        return s == null ? null : s.getString();
    }

    public static String getLanguage(Model description, Resource root) {
        Statement langStatement = description.getRequiredProperty(root, JenaModelSpec.ontLanguage);
        return langStatement.getResource().getURI();
    }

    protected void addLanguageDescription(Model d, Resource me, String langURI) {
        d.add(me, JenaModelSpec.ontLanguage, d.createResource(langURI));
    }

    protected void addImportsDescription(Model d, Resource me, ModelMaker m) {
        Resource importSelf = d.createResource();
        d.add(me, JenaModelSpec.importMaker, importSelf);
        m.addDescription(d, importSelf);
    }

    protected void addManagerDescription(Model d, Resource me, OntDocumentManager man) {
        d.add(me, JenaModelSpec.docManager, OntModelSpecObsolete.createValue(man));
    }

    protected void addReasonerDescription(Model d, Resource me, ReasonerFactory rf) {
        Resource reasonerSelf = d.createResource();
        d.add(me, JenaModelSpec.reasonsWith, reasonerSelf);
        if (rf != null) {
            d.add(reasonerSelf, JenaModelSpec.reasoner, d.createResource(rf.getURI()));
        }
    }

    protected Model addDescription(Model d, Resource self, ModelMaker importsMaker, String language, OntDocumentManager documentManager, ReasonerFactory reasonerFactory) {
        this.addMakerDescription(d, self);
        this.addImportsDescription(d, self, importsMaker);
        this.addLanguageDescription(d, self, language);
        this.addManagerDescription(d, self, documentManager);
        this.addReasonerDescription(d, self, reasonerFactory);
        return d;
    }

    public Model getDescription() {
        return this.getDescription(ResourceFactory.createResource());
    }

    public Model getDescription(Resource root) {
        return this.addDescription(ModelFactory.createDefaultModel(), root);
    }

    public Model addMakerDescription(Model desc, Resource root) {
        Resource makerRoot = desc.createResource();
        desc.add(root, JenaModelSpec.maker, makerRoot);
        this.maker.addDescription(desc, makerRoot);
        return desc;
    }

    public static Resource createValue(Object value) {
        Resource it = ResourceFactory.createResource();
        values.put(it, value);
        return it;
    }

    public static Object getValue(RDFNode it) {
        return values.get(it);
    }

    public static class RDBMakerCreator
    implements ModelMakerCreator {
        public ModelMaker create(Model desc, Resource root) {
            return ModelFactory.createModelRDBMaker(RDBMakerCreator.createConnection(desc, root));
        }

        public static IDBConnection createConnection(Model description, Resource root) {
            Resource connection = description.listStatements(root, JenaModelSpec.hasConnection, (RDFNode)null).nextStatement().getResource();
            String url = RDBMakerCreator.getURL(description, connection, JenaModelSpec.dbURL);
            String user = RDBMakerCreator.getString(description, connection, JenaModelSpec.dbUser);
            String password = RDBMakerCreator.getString(description, connection, JenaModelSpec.dbPassword);
            String className = RDBMakerCreator.getClassName(description, connection);
            String dbType = RDBMakerCreator.getDbType(description, connection);
            RDBMakerCreator.loadDrivers(dbType, className);
            return ModelFactory.createSimpleRDBConnection(url, user, password, dbType);
        }

        public static String getDbType(Model description, Resource connection) {
            return RDBMakerCreator.getString(description, connection, JenaModelSpec.dbType);
        }

        public static String getClassName(Model description, Resource root) {
            Statement cnStatement = description.getProperty(root, JenaModelSpec.dbClass);
            if (cnStatement == null) {
                return DriverMap.get(RDBMakerCreator.getDbType(description, root));
            }
            return cnStatement == null ? null : cnStatement.getString();
        }

        public static String getURL(Model description, Resource root, Property p) {
            return description.getRequiredProperty(root, p).getResource().getURI();
        }

        public static String getString(Model description, Resource root, Property p) {
            return description.getRequiredProperty(root, p).getString();
        }

        public static void loadDrivers(String dbType, String className) {
            try {
                Class.forName("com.hp.hpl.jena.db.impl.Driver_" + dbType);
                if (className != null) {
                    Class.forName(className);
                }
            }
            catch (ClassNotFoundException c) {
                throw new JenaException(c);
            }
        }
    }

    public static class FileMakerCreator
    extends MakerCreator
    implements ModelMakerCreator {
        public ModelMaker create(Model desc, Resource root) {
            Statement fb = desc.getProperty(root, JenaModelSpec.fileBase);
            String fileBase = fb == null ? "/tmp" : fb.getString();
            return ModelFactory.createFileModelMaker(fileBase, this.style(desc, root));
        }
    }

    public static class MemMakerCreator
    extends MakerCreator
    implements ModelMakerCreator {
        public ModelMaker create(Model desc, Resource root) {
            return ModelFactory.createMemModelMaker(this.style(desc, root));
        }
    }

    private static class MakerCreator {
        private MakerCreator() {
        }

        public ReificationStyle style(Model desc, Resource root) {
            Statement st = desc.getProperty(root, JenaModelSpec.reificationMode);
            return st == null ? ReificationStyle.Standard : JenaModelSpec.findStyle(st.getObject());
        }
    }

    public static interface ModelMakerCreator {
        public ModelMaker create(Model var1, Resource var2);
    }
}

