/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.context;

import fr.pasteur.sysbio.rdfscape.AbstractModulePanel;
import fr.pasteur.sysbio.rdfscape.Utilities;
import fr.pasteur.sysbio.rdfscape.context.ContextManager;
import fr.pasteur.sysbio.rdfscape.help.HelpManager;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ContextManagerPanel
extends AbstractModulePanel {
    ContextManager myContextManager = null;
    JComboBox contextList = null;
    JButton selectContextButton = null;
    JButton addContextButton = null;
    JButton delContextButton = null;
    JButton saveContextButton = null;

    public ContextManagerPanel(ContextManager contextManager) {
        this.myContextManager = contextManager;
        this.contextList = this.myContextManager.getAvailableContextsNames() != null ? new JComboBox<String>(this.myContextManager.getAvailableContextsNames()) : new JComboBox();
        this.selectContextButton = new JButton("Activate context");
        this.addContextButton = new JButton("Add context");
        this.delContextButton = new JButton("Delete context");
        this.saveContextButton = new JButton("Save current context");
        this.contextList.setSelectedItem(this.myContextManager.getActiveContextName());
        this.redLightText = "<html>Cannot operate an analysis context. This should not happen! You are experiencing problems here... please report!</html>";
        this.yellowLightText = "<html>You can operate on this default context, but it is advisable to create your own context (or to use an exisiting one)</html>";
        this.greenLightText = "<html>You are currentyly working on the " + this.myContextManager.getActiveContextName() + " context</html>";
        this.myTabText = "1) Select an analysis type!";
        this.myTabTooltip = "<html>Create a new analysis context (or use a provided one), select it, and activate it</html>";
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContextManagerPanel.this.myContextManager.setActiveContext((String)ContextManagerPanel.this.contextList.getSelectedItem());
                ContextManagerPanel.this.myContextManager.loadActiveContext();
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContextManagerPanel.this.myContextManager.saveActiveContext();
            }
        };
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog("Context name: ");
                if (string != null) {
                    ContextManagerPanel.this.myContextManager.addContext(string);
                }
            }
        };
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = new String[]{"Delete", "Cancel"};
                if (JOptionPane.showOptionDialog(null, "Deleteing a context will delete all related information. Are you sure ?", "Warning", -1, 2, null, objectArray, objectArray[1]) == 0 && ContextManagerPanel.this.contextList.getSelectedItem() != null) {
                    ContextManagerPanel.this.myContextManager.deleteContext((String)ContextManagerPanel.this.contextList.getSelectedItem());
                }
            }
        };
        this.selectContextButton.addActionListener(actionListener);
        this.addContextButton.addActionListener(actionListener3);
        this.delContextButton.addActionListener(actionListener4);
        this.saveContextButton.addActionListener(actionListener2);
        this.add(this.contextList);
        this.add(this.selectContextButton);
        this.add(this.addContextButton);
        this.add(this.delContextButton);
        this.add(this.saveContextButton);
        this.setVisible(true);
    }

    public void updateContextElementsList() {
        this.remove(this.contextList);
        this.remove(this.selectContextButton);
        this.remove(this.addContextButton);
        this.remove(this.delContextButton);
        this.remove(this.saveContextButton);
        System.out.println("Remove");
        this.contextList = this.myContextManager.getAvailableContextsNames() != null ? new JComboBox<String>(this.myContextManager.getAvailableContextsNames()) : new JComboBox();
        this.add(this.contextList);
        this.add(this.selectContextButton);
        this.add(this.addContextButton);
        this.add(this.delContextButton);
        this.add(this.saveContextButton);
        this.validate();
    }

    public String getHelpLink() {
        return "http://www.bioinformatics.org/rdfscape/wiki/Main/HowToWorkWithAnalysisContexts";
    }

    public JPanel getHelpPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel("<html>Selects an analysis context.<br> You need to activate selected context,<br/> in order for this selection to take effect.<br> (note: the list on the left is only an example and may not reflect what is available on your system)</html>", Utilities.getHelpIcon("selectAnalysisContextButton.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Adds a new context. This only init the relative data structure, doesn't activate it.<br > (The current context is not changed)</html>", Utilities.getHelpIcon("addContextButton.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Deletes the context currently selected <br >(not the content currently active)</html>", Utilities.getHelpIcon("deleteContextButton.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Saves all the settings of the current analysis context</html>", Utilities.getHelpIcon("saveContextButton.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Changes the current analysis context to the selected one.</html>", Utilities.getHelpIcon("activateContextButton.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>An <font color=red> analysis context</font> is grouping of all settings relative to an analysis.<br>You can reuse an analysis context or define your own or even share it.<br><b>Note: the <font color=red>current analysis context</font> and the <font color=red>selected analysis context</font> are distinct. </b></html>");
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        return jPanel;
    }

    public String getPanelName() {
        return "Analysis type selection";
    }

    public int getStatusLevel() {
        if (!this.myContextManager.canOperate()) {
            return 1;
        }
        if (this.myContextManager.getActiveContextName().equalsIgnoreCase("default")) {
            return 2;
        }
        return 3;
    }

    public void refresh() {
    }
}

