/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.cytomapper;

import fr.pasteur.sysbio.rdfscape.AbstractModulePanel;
import fr.pasteur.sysbio.rdfscape.Utilities;
import fr.pasteur.sysbio.rdfscape.cytomapper.CytoMapper;
import fr.pasteur.sysbio.rdfscape.cytomapper.MappingRule;
import fr.pasteur.sysbio.rdfscape.help.HelpManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

public class CytoMapperOptionPanel
extends AbstractModulePanel {
    private CytoMapper cytoMapper = null;
    private JPanel rulePanel = null;
    private JTable myResultTable = null;
    private JTabbedPane ruleTextPanels = null;
    private JLabel statLabel = new JLabel();
    private JButton addButton = null;
    private JButton delButton = null;
    private JButton resolveButton = null;

    public CytoMapperOptionPanel(CytoMapper cytoMapper) {
        this.cytoMapper = cytoMapper;
        this.redLightText = "<html>This should not happen! You are experiencing problems here... please report!</html>";
        this.yellowLightText = "<html>This should not happen! You are experiencing problems here... please report!</html>";
        this.greenLightText = "<html>You can always specify mapping options</html>";
        this.myTabText = "Mapping ontologies on Cytoscape networks";
        this.myTabTooltip = "<html>Configure the mappings between ontologies and other networks in Cytoscape (see Help for details)</html>";
        this.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.rulePanel = new JPanel(new BorderLayout());
        this.myResultTable = new JTable(this.cytoMapper.mapperTable);
        JScrollPane jScrollPane = new JScrollPane(this.myResultTable);
        this.ruleTextPanels = new JTabbedPane();
        JPanel jPanel = new JPanel(new GridLayout(1, 4));
        this.addButton = new JButton("New");
        this.delButton = new JButton("Del");
        this.resolveButton = new JButton("Resolve");
        jPanel.add(this.addButton);
        jPanel.add(this.delButton);
        jPanel.add(this.resolveButton);
        this.rulePanel.add((Component)this.ruleTextPanels, "Center");
        this.rulePanel.add((Component)jPanel, "South");
        jTabbedPane.add((Component)this.rulePanel, "Rules");
        jTabbedPane.add((Component)jScrollPane, "Results");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog("Insert rule name");
                if (string == null) {
                    return;
                }
                MappingRule mappingRule = new MappingRule();
                mappingRule.name = string;
                CytoMapperOptionPanel.this.cytoMapper.addMappingRule(mappingRule);
            }
        };
        this.addButton.addActionListener(actionListener);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CytoMapperOptionPanel.this.ruleTextPanels.getSelectedIndex() >= 0) {
                    ((CytoMapperOptionPanel)CytoMapperOptionPanel.this).cytoMapper.mappingRuleList.remove(CytoMapperOptionPanel.this.ruleTextPanels.getTitleAt(CytoMapperOptionPanel.this.ruleTextPanels.getSelectedIndex()));
                    CytoMapperOptionPanel.this.ruleTextPanels.remove(CytoMapperOptionPanel.this.ruleTextPanels.getSelectedComponent());
                }
            }
        };
        this.delButton.addActionListener(actionListener2);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CytoMapperOptionPanel.this.cytoMapper.resolve();
                CytoMapperOptionPanel.this.showStats();
            }
        };
        this.resolveButton.addActionListener(actionListener3);
        this.add((Component)jTabbedPane, "Center");
        this.add((Component)this.statLabel, "North");
        this.showStats();
    }

    private void showStats() {
        this.remove(this.statLabel);
        this.statLabel = new JLabel("URIs: " + this.cytoMapper.totalURIs + "              IDs: " + this.cytoMapper.totalIDs + "              Conflicts: " + this.cytoMapper.clashes + "             Multi: " + this.cytoMapper.multi);
        this.add((Component)this.statLabel, "North");
        this.validate();
    }

    public void refresh() {
        this.reset();
        Enumeration<MappingRule> enumeration = this.cytoMapper.mappingRuleList.elements();
        while (enumeration.hasMoreElements()) {
            MappingRule mappingRule = enumeration.nextElement();
            this.ruleTextPanels.add((Component)mappingRule.getPanel(), mappingRule.name);
        }
    }

    public void reset() {
        Component[] componentArray = this.ruleTextPanels.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            this.ruleTextPanels.remove(componentArray[i]);
        }
    }

    public void resetAfterKnowledgeBaseChange() {
        if (this.cytoMapper.canResolve()) {
            this.resolveButton.setEnabled(true);
        } else {
            this.resolveButton.setEnabled(false);
        }
    }

    public String getHelpLink() {
        return "http://www.bioinformatics.org/rdfscape/wiki/Main/LinkingGraphsInCytoscapeAndOntologies";
    }

    public JPanel getHelpPanel() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = null;
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jLabel = new JLabel("<html>Mapping between ontologies and networks in Cytoscape is specified through a set of <i>query bodies</i> or <i>patterns</i>.<br>For each pattern, a tab is present. Swithcing to <b>Results</b> shows all mappings currently possible. That is, alla association between URIs in the ontologyand IDs in Cytoscape. These are potential IDs. They are not necessarily representeed in the current network.<br><b>Note that mapping is defined for nodes only!</b></html>", Utilities.getHelpIcon("cytoMapperOptionTabs.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel(Utilities.getHelpIcon("cytoMapperRuleBody.png"));
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jLabel = new JLabel("<html>The specification of a <i>Pattern</i>. All this patterns are composed in a query to the ontology that is evaluated in OR.Within the result of this query associations between URIs and object of datatype properties corresponding to IDs in Cytoscape is found.<br>Which element in the result is the URI, and which the literal corresponding to the Cytoscape ID, can be indicated in  the boxes <b>URI</b> and <b>ID</b>.<br><b>Commit</b> records the rule in memory. It does not execute it (use <b>Resolve</b>), neither store it permanently (refer to <b>Analysis contexts</b>).</html>");
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 100));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Add a new mapping pattern.</html>", Utilities.getHelpIcon("newCytoMapperButton.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Deletes the mapping pattern currently displayed.</html>", Utilities.getHelpIcon("delCytoMapperButton.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Applies all patterns (in OR) to generate correspondences between URIs and possible IDs.<br>Results of this operation are displayed in the <b>Results</b> panel.<br>This action enables <b>Map</b> in the <b>Map ontologies to my network</b> panel. </html>", Utilities.getHelpIcon("cytoResolveButton.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel(Utilities.getHelpIcon("cytoMapperResolveResults.png"));
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 50));
        jPanel.add(jLabel);
        jLabel = new JLabel("<html><ul><li><b>URIs:</b> The total number of URIs identified by the specified patterns</li><li><b>IDs:</b> The total number of IDs identified by the specified patterns</li><li><b>Conflicts:</b> The number of cases in which two URIs can be attributes to the same ID. Note that this situation should not conceptually happen (each node is assumed to represent one concept in the ontology). The ontology should be augmented accordingly (through a proper mapping file). No garantee are done on the result: only one of the possible URIs chosed randomly will be assigne to the node.</li><li><b>Multi:</b> The number of URIs that have multiple Identifier. This is possible, but should not be the standard consition in which analysis of microarray data will be applied.</li></ul> </html>");
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 100));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        return jPanel;
    }

    public String getPanelName() {
        return "Mapping to Cytoscape Options";
    }

    public int getStatusLevel() {
        return 3;
    }
}

